#ifndef  __LEXER_H__
#define  __LEXER_H__ 1

#include "dfa.h"
#include "lexer.fdf"

DfaNode  conconDfas[] =
        {
                { "++", 1,              3 },     /*  0 real */
                { "--", 2,              3 },     /*  1 */
                { "09", END_REJECT,     4 },     /*  2 */
                { "09", END_REJECT,     4 },     /*  3 */
                { "09", 5,              4 },     /*  4 */
                { "..", END_REJECT,     6 },     /*  5 */
                { "09", END_REJECT,     7 },     /*  6 */
                { "09", 8,              7 },     /*  7 */
                { "EE", 9,             10 },     /*  8 */
                { "ee", END_ACCEPT,    10 },     /*  9 */
                { "++", 11,            13 },     /* 10 */
                { "--", 12,            13 },     /* 11 */
                { "09", END_REJECT,    14 },     /* 12 */
                { "09", END_REJECT ,   14 },     /* 13 */
                { "09", END_ACCEPT ,   14 },     /* 14 */
                { "++", 16,            18 },     /* 15 integer */
                { "--", 17,            18 },     /* 16 */
                { "09", END_REJECT,    19 },     /* 17 */
                { "09", END_REJECT,    19 },     /* 18 */
                { "09", END_ACCEPT,    19 },     /* 19 */
                { "  ", 21,            34 },     /* 20 spaces */
                { "\t\t",END_REJECT,   34 },     /* 21 */
                { "((", END_REJECT,    34 },     /* 22 bra */
                { "))", END_REJECT,    34 },     /* 23 ket */
                { "//", END_REJECT,    25 },     /* 24 remark */
                { "**", END_REJECT,    34 },     /* 25 */
                { "**", END_REJECT,    27 },     /* 26 unremark */
                { "//", END_REJECT,    34 },     /* 27 */
                { "__", END_REJECT,    29 },     /* 28 atom */
                { "__", END_ACCEPT,    29 },     /* 29 */
                { "\n\n",END_REJECT,   34 },     /* 30 newline */
                { "\"\"", END_REJECT,   32 },     /* 31 literal */
                { "\0\0", END_ACCEPT,  32 },     /* 32 */
                { "\'\'", END_REJECT,  32 },     /* 33 quote */
        		{ "ba"  , END_ACCEPT,  34 }      /* 34 acceptor */
        };


TokenRules  conconRules[] = 
        {
        { 0,   proLex_real     },
        { 15,  proLex_integer  },
        { 20,  proLex_space    },
        { 22,  proLex_bra      },
        { 23,  proLex_ket      },
        { 24,  proLex_remark   },
        { 26,  proLex_unremark },
        { 28,  proLex_alpha    },
        { 30,  proLex_newline  },
        { 31,  proLex_literal  },
        { 33,  proLex_quote    },
        { END_REJECT, (Inherit (*)(void))nofunc     }
        };

#endif



