# Generated by default/object.tt
package Paws::MediaTailor::SourceLocation;
  use Moose;
  has AccessConfiguration => (is => 'ro', isa => 'Paws::MediaTailor::AccessConfiguration');
  has Arn => (is => 'ro', isa => 'Str', required => 1);
  has CreationTime => (is => 'ro', isa => 'Str');
  has DefaultSegmentDeliveryConfiguration => (is => 'ro', isa => 'Paws::MediaTailor::DefaultSegmentDeliveryConfiguration');
  has HttpConfiguration => (is => 'ro', isa => 'Paws::MediaTailor::HttpConfiguration', required => 1);
  has LastModifiedTime => (is => 'ro', isa => 'Str');
  has SourceLocationName => (is => 'ro', isa => 'Str', required => 1);
  has Tags => (is => 'ro', isa => 'Paws::MediaTailor::__mapOf__string', request_name => 'tags', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::MediaTailor::SourceLocation

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::MediaTailor::SourceLocation object:

  $service_obj->Method(Att1 => { AccessConfiguration => $value, ..., Tags => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::MediaTailor::SourceLocation object:

  $result = $service_obj->Method(...);
  $result->Att1->AccessConfiguration

=head1 DESCRIPTION

This response includes only the "type" : "object" property.

=head1 ATTRIBUTES


=head2 AccessConfiguration => L<Paws::MediaTailor::AccessConfiguration>

The access configuration for the source location.


=head2 B<REQUIRED> Arn => Str

The ARN of the SourceLocation.


=head2 CreationTime => Str

The timestamp that indicates when the source location was created.


=head2 DefaultSegmentDeliveryConfiguration => L<Paws::MediaTailor::DefaultSegmentDeliveryConfiguration>

The default segment delivery configuration.


=head2 B<REQUIRED> HttpConfiguration => L<Paws::MediaTailor::HttpConfiguration>

The HTTP configuration for the source location.


=head2 LastModifiedTime => Str

The timestamp that indicates when the source location was last
modified.


=head2 B<REQUIRED> SourceLocationName => Str

The name of the source location.


=head2 Tags => L<Paws::MediaTailor::__mapOf__string>

The tags assigned to the source location.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::MediaTailor>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

