package Dist::Zilla::Plugin::PodSyntaxTests 6.032;
# ABSTRACT: a author test for Pod syntax

use Moose;
extends 'Dist::Zilla::Plugin::InlineFiles';
with 'Dist::Zilla::Role::PrereqSource';

use Dist::Zilla::Pragmas;

use namespace::autoclean;

#pod =head1 SYNTAX
#pod
#pod     # Add this to your dist.ini.
#pod     [PodSyntaxTests]
#pod
#pod     # To test for POD validity, run this in the shell:
#pod     $ dzil test --release
#pod
#pod =head1 DESCRIPTION
#pod
#pod This is an extension of L<Dist::Zilla::Plugin::InlineFiles>, providing the
#pod following files:
#pod
#pod   xt/author/pod-syntax.t   - a standard Test::Pod test
#pod
#pod L<Test::Pod> C<1.41> will be added as a C<develop requires> dependency.
#pod
#pod One can run the release tests by invoking C<dzil test --release>.
#pod
#pod =cut


# Register the author test prereq as a "develop requires"
# so it will be listed in "dzil listdeps --author"
sub register_prereqs {
  my ($self) = @_;

  $self->zilla->register_prereqs(
    {
      type  => 'requires',
      phase => 'develop',
    },
    'Test::Pod' => '1.41',
  );
}


__PACKAGE__->meta->make_immutable;
1;

=pod

=encoding UTF-8

=head1 NAME

Dist::Zilla::Plugin::PodSyntaxTests - a author test for Pod syntax

=head1 VERSION

version 6.032

=head1 DESCRIPTION

This is an extension of L<Dist::Zilla::Plugin::InlineFiles>, providing the
following files:

  xt/author/pod-syntax.t   - a standard Test::Pod test

L<Test::Pod> C<1.41> will be added as a C<develop requires> dependency.

One can run the release tests by invoking C<dzil test --release>.

=head1 PERL VERSION

This module should work on any version of perl still receiving updates from
the Perl 5 Porters.  This means it should work on any version of perl
released in the last two to three years.  (That is, if the most recently
released version is v5.40, then this module should work on both v5.40 and
v5.38.)

Although it may work on older versions of perl, no guarantee is made that the
minimum required version will not be increased.  The version may be increased
for any reason, and there is no promise that patches will be accepted to
lower the minimum required perl.

=head1 SYNTAX

    # Add this to your dist.ini.
    [PodSyntaxTests]

    # To test for POD validity, run this in the shell:
    $ dzil test --release

=head1 AUTHOR

Ricardo SIGNES 😏 <cpan@semiotic.systems>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2024 by Ricardo SIGNES.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut

__DATA__
___[ xt/author/pod-syntax.t ]___
#!perl
# This file was automatically generated by Dist::Zilla::Plugin::PodSyntaxTests.
use strict; use warnings;
use Test::More;
use Test::Pod 1.41;

all_pod_files_ok();
