use strict;
use Digest::SHA3;

my $TAGS = join('|', qw(Len Msg MD));
my @vecs = ();
while (<DATA>) {
	next unless /^\s*($TAGS)\s*=\s*([\dA-F]+)/o;
	push(@vecs, $2);
}

my $numtests = scalar(@vecs) / 3;
print "1..$numtests\n";

for (1 .. $numtests) {
	my $sha3 = Digest::SHA3->new(384);
	my $Len = shift @vecs;
	my $Msg = pack("H*", shift @vecs);
	if ($Len % 8) {
		my @a = unpack("C*", $Msg);
		my $b = pop(@a);
		$b <<= (8 - $Len % 8);
		push(@a, $b);
		$Msg = pack("C*", @a);
	}
	my $MD = shift @vecs;
	my $computed = $sha3->add_bits($Msg, $Len)->hexdigest;
	print "not " unless $computed eq lc($MD);
	print "ok ", $_, "\n";
}

__DATA__
# Keccak(input|01)[r=832, c=768] truncated to 384 bits, or SHA3-384 as in FIPS 202 draft

Len = 7
Msg = 4C
MD = 98B40541E6CC2807193976B1848AE2611683002C16CC325AC04DDC0C64FA3BE89DB2AA2379642342A9F23453BE520D02

Len = 827
Msg = D076043F4045A478C51530D457FC950916FAEAF555C2B28E8567394D0BB8A3C7D8A7225E6C0C94D39D03F0F50133ABBE6F009302153014025FB4B1F7B8EFCC9F4F9C3EAB0608DB41095AAD0D2B63037F3986DF71D6651946EE9F18DF52635BBD360F21E2555C5001
MD = 38F5D214B253434EF9B90518651AFEABC46CDDB006CB40A1F68219E42C62D73572B144D84C9E9F2602BEC91852D568DD

Len = 2047
Msg = 1F42ADD25C0A80A4C82AAE3A0E302ABF9261DCA7E7884FD869D96ED4CE88AAAA25304D2D79E1FA5CC1FA2C95899229BC87431AD06DA524F2140E70BD0536E9685EE7808F598D8A9FE15D40A72AEFF431239292C5F64BDB7F620E5D160B329DEB58CF6D5C0665A3DED61AE4ADBCA94DC2B7B02CDF3992FDF79B3D93E546D5823C3A630923064ED24C3D974C4602A49DF75E49CF7BD51EDC7382214CBA850C4D3D11B40A70B1D926E3755EC79693620C242AB0F23EA206BA337A7EDC5421D63126CB6C7094F6BC1CF9943796BE2A0D9EB74FC726AA0C0D3B3D39039DEAD39A7169F8C3E2365DD349E358BF08C717D2E436D65172A76ED5E1F1E694A75C19280B15
MD = 63B0BF06BE376C877B378D26C80B7D8FCC6BC501C68EEB653F9A82E705997D0F92687C94D7BA8FE52F083BE7D6534B19
