# HOW TO CONTRIBUTE

Thank you for considering contributing to Crypt-URandom-MonkeyPatch.

There are multiple ways that you can help with this project.

Any contributions (bug reports, feature requests, security issues, or patches)
must cite any tools which generated the reports or code, and any software that
the code is based on.

Contributions must not include content generated by large language models
(LLMs) or other probabilistic tools, including but not limited to Anthropic,
Copilot or ChatGPT.  This policy covers code, documentation, pull requests,
issues, comments, and any other contributions to this project.

See [AI Contributions](#ai-contributions) below for more more details.

## Report Bugs and Submit Feature Requests

Please report any bugs or feature requests on the bugtracker website
[https://github.com/robrwo/perl-Crypt-URandom-MonkeyPatch/issues](https://github.com/robrwo/perl-Crypt-URandom-MonkeyPatch/issues).

When submitting a bug or request, please include a test-file or a patch to an
existing test-file that illustrates the bug or desired feature.

Using the bugtracker is preferable to emailing the maintainer, as identified
in the AUTHOR section of the POD.  But if you are unable to use the
bugtracker, then you may email the current maintainer,
Robert Rothenberg <rrwo@cpan.org>.

### Reporting Security Vulnerabilities

Security issues should not be reported on the bugtracker website. Please see
`SECURITY.md` for instructions how to report security vulnerabilities.

## Submitting Patches

The source code is available via GitHub at
[https://github.com/robrwo/perl-Crypt-URandom-MonkeyPatch](https://github.com/robrwo/perl-Crypt-URandom-MonkeyPatch).

Patches should be based on a recent fork of the `main` branch.

This distribution is managed with [Dist::Zilla](https://dzil.org/).  This
means that many of the usual files you might expect are not in the repository,
but are generated at release time, as is much of the documentation.  Some
generated files are kept in the repository as a convenience
(e.g. `Makefile.PL` or `cpanfile`).

Generally, **you do not need Dist::Zilla to contribute patches**.  You do need
Dist::Zilla to create a tarball.
See [Installing and using Dist::Zilla](#installing-and-using-distzilla) below
for guidance.

### Getting dependencies

If you have [App::cpanminus](https://metacpan.org/pod/App::cpanminus) 1.6 or
later installed, you can use `cpanm` to satisfy dependencies like this:

    $ cpanm --installdeps .

Otherwise, look for either a `Makefile.PL` or `cpanfile` file for a list of
dependencies to satisfy.

### Running tests

You can run tests directly using the `prove` tool:

    $ prove -l
    $ prove -lv t/some_test_file.t

For most cases, `prove` is entirely sufficient to test any patches you have.

### Code style and tidying

Please try to match any existing coding style.  If there is a `.perltidyrc`
file, please install [Perl::Tidy](https://metacpan.org/pod/Perl::Tidy) and use
`perltidy` before submitting patches.

If there is a `tidyall.ini` file, you can also install
[Code::TidyAll](https://metacpan.org/pod/Code::TidyAll) and run `tidyall` on a
file or `tidyall -a` to tidy all files.

### Patching documentation

Much of the documentation POD is generated at release time.  Some is generated
boilerplate; other documentation is built from
[Pod::Weaver](https://metacpan.org/pod/Pod::Weaver) pseudo-POD directives in
the source like C<=attr>, C<=method> or C<=export>.

If you would like to submit a documentation edit, please limit yourself to the
documentation you see.

If you see typos or documentation issues in the generated docs, please email
the maintainers or open a bug ticket instead of patching.

### Where to send patches and pull requests

If you found this distribution on GitHub, sending a pull-request is the best way to contribute.

If a pull-request isn't possible, a bug ticket with a patch file is the next best option.

As a last resort, an email to the maintainer is acceptable.

## Installing and using Dist::Zilla

Dist::Zilla is not required for contributing, but if you'd like to learn more,
this section will get you up to speed.

Dist::Zilla is a very powerful authoring tool, optimised for maintaining a
large number of distributions with a high degree of automation, but it has a
large dependency chain, a bit of a learning curve and requires a number of
author-specific plugins.

To install it from CPAN, I recommend one of the following approaches for the
quickest installation:

    # using CPAN.pm, but bypassing non-functional pod tests
    $ cpan TAP::Harness::Restricted
    $ PERL_MM_USE_DEFAULT=1 HARNESS_CLASS=TAP::Harness::Restricted cpan Dist::Zilla

    # using cpanm, bypassing *all* tests
    $ cpanm -n Dist::Zilla

In either case, it's probably going to take several minutes.  Go for a walk,
go get a cup of your favourite beverage, take a bathroom break, or whatever.
When you get back, Dist::Zilla should be ready for you.

Then you need to install any plugins specific to this distribution:

    $ cpan `dzil authordeps`
    $ dzil authordeps | cpanm

Once installed, here are some dzil commands you might try:

    $ dzil build
    $ dzil test

You can learn more about Dist::Zilla at <http://dzil.org>.

## AI Contributions

Contributions must not include content generated by large language models
(LLMs) or other probabilistic tools, including but not limited to Anthropic,
Copilot or ChatGPT.  This policy covers code, documentation, pull requests,
issues, comments, and any other contributions to this project.

This restriction is based on several concerns:

### Maintainer burden

These tools make it easy to generate large amounts of plausible-looking bug
reports or code that the contributor does not understand and cannot explain.
Instead, the burden of understanding is placed on the maintainers.

### Correctness and security

These tools generate code based on probabilities of symbols in their models.
There is no semantic model about what the code does.  There is no guarantee
that it is correct, and no indication of what security implications it may
have.

### Copyright issues

These tools may use models that are trained on copyrighted content, both
accidentally and intentionally, and their output often includes that content
verbatim, without attribution.  Since the legality of this is uncertain, these
contributions may violate the licenses of copyrighted works.

Using these tools also requires training their models on the source code from
this project, and it makes it likely that code from this project will be used
in other projects in ways that violate this project's license.

### Ethical issues

These tools require an unreasonable amount of energy and water to build and
operate, and they are being used to undermine labour and justify layoffs.
These are harms that the maintainers of this project do not want to
perpetuate, even if only indirectly.

# Credits

This file was adapted from an initial `CONTRIBUTING.mkdn` file from David
Golden under the terms of the Apache 2 license.

The text in "AI Contributions" was adapted from the
[Contributing to Servo](https://book.servo.org/contributing.html) section of
The Servo Book, which is licensed as no rights reserved under
[CC0](https://creativecommons.org/public-domain/cc0/).
