/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.writer;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Formatter;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.DataType;
import ucar.ma2.StructureData;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.DataIterator;
import ucar.nc2.dt.PointObsDataset;
import ucar.nc2.dt.PointObsDatatype;
import ucar.nc2.dt.TypedDatasetFactory;
import ucar.nc2.ft.FeatureCollection;
import ucar.nc2.ft.FeatureDataset;
import ucar.nc2.ft.FeatureDatasetFactoryManager;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.PointFeatureCollection;
import ucar.nc2.ft.point.writer.PointObVar;
import ucar.nc2.ft.point.writer.WriterCFPointDataset;
import ucar.unidata.geoloc.EarthLocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CFPointObWriter {
    private WriterCFPointDataset ncWriter;

    public CFPointObWriter(DataOutputStream stream, List<Attribute> globalAtts, String altUnits, List<PointObVar> dataVars, int numrec) throws IOException {
        this.ncWriter = new WriterCFPointDataset(stream, globalAtts, altUnits);
        ArrayList<PointObVarAdapter> vars = new ArrayList<PointObVarAdapter>(dataVars.size());
        for (PointObVar pvar : dataVars) {
            vars.add(new PointObVarAdapter(pvar));
        }
        this.ncWriter.writeHeader(vars, numrec);
    }

    public void addPoint(double lat, double lon, double alt, Date time, double[] vals, String[] svals) throws IOException {
        this.ncWriter.writeRecord(lat, lon, alt, time, vals, svals);
    }

    public void finish() throws IOException {
        this.ncWriter.finish();
    }

    public static boolean rewritePointObsDataset(String fileIn, String fileOut, boolean inMemory) throws IOException {
        System.out.println("Rewrite2 .nc files from " + fileIn + " to " + fileOut + " inMemory= " + inMemory);
        long start = System.currentTimeMillis();
        NetcdfFile ncfile = inMemory ? NetcdfFile.openInMemory(fileIn) : NetcdfFile.open(fileIn);
        NetcdfDataset ncd = new NetcdfDataset(ncfile);
        StringBuilder errlog = new StringBuilder();
        PointObsDataset pobsDataset = (PointObsDataset)TypedDatasetFactory.open(FeatureType.POINT, ncd, null, errlog);
        if (pobsDataset == null) {
            return false;
        }
        CFPointObWriter.writePointObsDataset(pobsDataset, fileOut);
        pobsDataset.close();
        long took = System.currentTimeMillis() - start;
        System.out.println(" that took " + (took - start) + " msecs");
        return true;
    }

    public static void writePointObsDataset(PointObsDataset pobsDataset, String fileOut) throws IOException {
        String altUnits = null;
        DataIterator iterOne = pobsDataset.getDataIterator(-1);
        if (iterOne.hasNext()) {
            PointObsDatatype pobsData = (PointObsDatatype)iterOne.nextData();
            EarthLocation loc = pobsData.getLocation();
            altUnits = Double.isNaN(loc.getAltitude()) ? null : "meters";
        }
        List<VariableSimpleIF> vars = pobsDataset.getDataVariables();
        ArrayList<PointObVar> nvars = new ArrayList<PointObVar>(vars.size());
        for (VariableSimpleIF v : vars) {
            if (!v.getDataType().isNumeric()) continue;
            nvars.add(new PointObVar(v));
        }
        int ndoubles = vars.size();
        double[] dvals = new double[ndoubles];
        for (VariableSimpleIF v : vars) {
            if (!v.getDataType().isString()) continue;
            nvars.add(new PointObVar(v));
        }
        String[] svals = new String[vars.size() - ndoubles];
        FileOutputStream fos = new FileOutputStream(fileOut);
        DataOutputStream out = new DataOutputStream(fos);
        CFPointObWriter writer = new CFPointObWriter(out, pobsDataset.getGlobalAttributes(), altUnits, nvars, -1);
        DataIterator iter = pobsDataset.getDataIterator(1000000);
        while (iter.hasNext()) {
            PointObsDatatype pobsData = (PointObsDatatype)iter.nextData();
            StructureData sdata = pobsData.getData();
            int dcount = 0;
            int scount = 0;
            for (PointObVar v : nvars) {
                Array data;
                if (v.getDataType().isNumeric()) {
                    data = sdata.getArray(v.getName());
                    data.resetLocalIterator();
                    if (!data.hasNext()) continue;
                    dvals[dcount++] = data.nextDouble();
                    continue;
                }
                if (!v.getDataType().isString()) continue;
                data = (ArrayChar)sdata.getArray(v.getName());
                svals[scount++] = ((ArrayChar)data).getString();
            }
            EarthLocation loc = pobsData.getLocation();
            writer.addPoint(loc.getLatitude(), loc.getLongitude(), loc.getAltitude(), pobsData.getObservationTimeAsDate(), dvals, svals);
        }
        writer.finish();
    }

    public static boolean rewritePointFeatureDataset(String fileIn, String fileOut, boolean inMemory) throws IOException {
        System.out.println("Rewrite2 .nc files from " + fileIn + " to " + fileOut + " inMemory= " + inMemory);
        long start = System.currentTimeMillis();
        NetcdfFile ncfile = inMemory ? NetcdfFile.openInMemory(fileIn) : NetcdfFile.open(fileIn);
        NetcdfDataset ncd = new NetcdfDataset(ncfile);
        Formatter errlog = new Formatter();
        FeatureDataset fd = FeatureDatasetFactoryManager.wrap(FeatureType.ANY_POINT, ncd, null, errlog);
        if (fd == null) {
            return false;
        }
        if (fd instanceof FeatureDatasetPoint) {
            CFPointObWriter.writePointFeatureCollection((FeatureDatasetPoint)fd, fileOut);
            fd.close();
            long took = System.currentTimeMillis() - start;
            System.out.println(" that took " + (took - start) + " msecs");
            return true;
        }
        return false;
    }

    public static int writePointFeatureCollection(FeatureDatasetPoint pfDataset, String fileOut) throws IOException {
        PointFeatureCollection pointFeatureCollection = null;
        List<FeatureCollection> featureCollectionList = pfDataset.getPointFeatureCollectionList();
        for (FeatureCollection featureCollection : featureCollectionList) {
            if (!(featureCollection instanceof PointFeatureCollection)) continue;
            pointFeatureCollection = (PointFeatureCollection)featureCollection;
        }
        if (null == pointFeatureCollection) {
            throw new IOException("There is no PointFeatureCollection in  " + pfDataset.getLocation());
        }
        long start = System.currentTimeMillis();
        FileOutputStream fos = new FileOutputStream(fileOut);
        DataOutputStream out = new DataOutputStream(new BufferedOutputStream(fos, 10000));
        WriterCFPointDataset writer = null;
        int count = 0;
        pointFeatureCollection.resetIteration();
        while (pointFeatureCollection.hasNext()) {
            PointFeature pointFeature = pointFeatureCollection.next();
            StructureData data = pointFeature.getData();
            if (count == 0) {
                EarthLocation loc = pointFeature.getLocation();
                String altUnits = Double.isNaN(loc.getAltitude()) ? null : "meters";
                writer = new WriterCFPointDataset(out, pfDataset.getGlobalAttributes(), altUnits);
                writer.writeHeader(pfDataset.getDataVariables(), -1);
            }
            writer.writeRecord(pointFeature, data);
            ++count;
        }
        writer.finish();
        out.flush();
        out.close();
        long took = System.currentTimeMillis() - start;
        System.out.printf("Write %d records from %s to %s took %d msecs %n", count, pfDataset.getLocation(), fileOut, took);
        return count;
    }

    public static void main2(String[] args) throws IOException {
        String location = "R:/testdata/point/netcdf/madis.nc";
        File file = new File(location);
        CFPointObWriter.rewritePointFeatureDataset(location, "C:/TEMP/" + file.getName(), true);
    }

    public static void main(String[] args) throws IOException {
        ArrayList<PointObVar> dataVars = new ArrayList<PointObVar>();
        dataVars.add(new PointObVar("test1", "units1", "desc1", DataType.CHAR, 4));
        dataVars.add(new PointObVar("test2", "units2", "desc3", DataType.CHAR, 4));
        FileOutputStream fos = new FileOutputStream("C:/temp/test.out");
        DataOutputStream out = new DataOutputStream(new BufferedOutputStream(fos, 10000));
        CFPointObWriter writer = new CFPointObWriter(out, new ArrayList<Attribute>(), "meters", dataVars, 1);
        double[] dvals = new double[]{};
        String[] svals = new String[]{"valu", "value"};
        writer.addPoint(1.0, 2.0, 3.0, new Date(), dvals, svals);
        writer.finish();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PointObVarAdapter
    implements VariableSimpleIF {
        PointObVar pov;
        List<Attribute> atts = new ArrayList<Attribute>(2);

        PointObVarAdapter(PointObVar pov) {
            this.pov = pov;
        }

        @Override
        public String getName() {
            return this.pov.getName();
        }

        @Override
        public String getShortName() {
            return this.pov.getName();
        }

        @Override
        public String getDescription() {
            return this.pov.getDesc();
        }

        @Override
        public String getUnitsString() {
            return this.pov.getUnits();
        }

        @Override
        public int getRank() {
            return this.pov.getLen() > 1 ? 1 : 0;
        }

        @Override
        public int[] getShape() {
            int[] nArray;
            if (this.pov.getLen() > 1) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = this.pov.getLen();
            } else {
                nArray = new int[]{};
            }
            return nArray;
        }

        @Override
        public List<Dimension> getDimensions() {
            if (this.pov.getLen() > 1) {
                ArrayList<Dimension> dims = new ArrayList<Dimension>(1);
                String suffix = this.pov.getDataType() == DataType.STRING || this.pov.getDataType() == DataType.CHAR ? "_strlen" : "_len";
                dims.add(new Dimension(this.pov.getName() + suffix, this.pov.getLen(), false, false, false));
                return dims;
            }
            return new ArrayList<Dimension>(0);
        }

        @Override
        public DataType getDataType() {
            return this.pov.getDataType() == DataType.STRING ? DataType.CHAR : this.pov.getDataType();
        }

        @Override
        public List<Attribute> getAttributes() {
            if (this.atts == null) {
                this.atts = new ArrayList<Attribute>(2);
            }
            if (this.pov.getDesc() != null) {
                this.atts.add(new Attribute("long_name", this.pov.getDesc()));
            }
            if (this.pov.getUnits() != null) {
                this.atts.add(new Attribute("units", this.pov.getUnits()));
            }
            return this.atts;
        }

        @Override
        public Attribute findAttributeIgnoreCase(String name) {
            for (Attribute att : this.getAttributes()) {
                if (!att.getName().equalsIgnoreCase(name)) continue;
                return att;
            }
            return null;
        }

        @Override
        public int compareTo(VariableSimpleIF o) {
            return -1;
        }
    }
}

