#
# $Id$
#

package Oracle::CAPI;

use 5.006;
use strict;
use warnings;
use Carp;

##at should attempt at some point to document, get rid of all export symbols and
##at clean (free) all underlying C objects

require Exporter;
require DynaLoader;
use AutoLoader;

our @ISA = qw(Exporter DynaLoader);

# Items to export into callers namespace by default. Note: do not export
# names by default without a very good reason. Use EXPORT_OK instead.
# Do not simply export all your public functions/methods/constants.

our @EXPORT = qw(
	CAPI_ALARM_DUETIME
	CAPI_ALARM_STARTTIME
	CAPI_CALLBACK_CANT_MALLOC_ERR
	CAPI_CALLBACK_CANT_REALLOC_ERR
	CAPI_CALLBACK_CONTINUE
	CAPI_CALLBACK_DONE
	CAPI_CAPAB_ABOUT_BOX
	CAPI_CAPAB_AUTH
	CAPI_CAPAB_CAPI_VERSION
	CAPI_CAPAB_COMP
	CAPI_CAPAB_ENCR
	CAPI_CAPAB_MAXDATE
	CAPI_CAPAB_SERVER_VERSION
	CAPI_CAPAB_UNSUPPORTED_ICAL_COMP
	CAPI_CAPAB_UNSUPPORTED_ICAL_PROP
	CAPI_CAPAB_VERSION
	CAPI_CreateCallbackStream
	CAPI_CreateFileStreamFromFilenames
	CAPI_CreateMemoryStream
	CAPI_DestroyHandles
	CAPI_DestroyStreams
	CAPI_FLAGS_NONE
	CAPI_FLAG_ALARM_DUETIME
	CAPI_FLAG_ALARM_STARTTIME
	CAPI_FLAG_FETCH_EXCLUDE_APPOINTMENTS
	CAPI_FLAG_FETCH_EXCLUDE_DAILYNOTES
	CAPI_FLAG_FETCH_EXCLUDE_DAYEVENTS
	CAPI_FLAG_FETCH_EXCLUDE_HOLIDAYS
	CAPI_FLAG_FETCH_NO_FIELDHOLDERS
	CAPI_FLAG_NONE
	CAPI_FLAG_STORE_DELPROPS
	CAPI_FLAG_STORE_MODPROPS
	CAPI_GetCapabilities
	CAPI_GetHandle
	CAPI_GetStatusLevels
	CAPI_GetStatusString
	CAPI_H
	CAPI_HANDLE_INITIALIZER
	CAPI_HANDLE_MAILTO
	CAPI_HANDLE_NAME
	CAPI_HANDLE_TYPE
	CAPI_HandleInfo
	CAPI_LOGOFF_STAY_CONNECTED
	CAPI_NOTIFY_EMAIL
	CAPI_NOTIFY_SMS
	CAPI_SESSION_INITIALIZER
	CAPI_STATMASK_3
	CAPI_STATMASK_3_FIELD
	CAPI_STATMASK_4
	CAPI_STATMASK_4_FIELD
	CAPI_STATMASK_5
	CAPI_STATMASK_5_FIELD
	CAPI_STATMASK_CLASS
	CAPI_STATMASK_CLASS_FIELD
	CAPI_STATMASK_MODE_FIELD
	CAPI_STATMODE_FATAL
	CAPI_STAT_API
	CAPI_STAT_API_BADPARAM
	CAPI_STAT_API_CALLBACK
	CAPI_STAT_API_CALLBACK_ERROR
	CAPI_STAT_API_FLAGS
	CAPI_STAT_API_HANDLE
	CAPI_STAT_API_HANDLE_BAD
	CAPI_STAT_API_HANDLE_NOTNULL
	CAPI_STAT_API_HANDLE_NULL
	CAPI_STAT_API_NULL
	CAPI_STAT_API_POOL
	CAPI_STAT_API_POOL_LOCKFAILED
	CAPI_STAT_API_POOL_NOCONNECTIONS
	CAPI_STAT_API_POOL_NOTINITIALIZED
	CAPI_STAT_API_SESSION
	CAPI_STAT_API_SESSION_BAD
	CAPI_STAT_API_SESSION_NOTNULL
	CAPI_STAT_API_SESSION_NULL
	CAPI_STAT_API_STREAM
	CAPI_STAT_API_STREAM_BAD
	CAPI_STAT_API_STREAM_NOTNULL
	CAPI_STAT_API_STREAM_NULL
	CAPI_STAT_CONFIG
	CAPI_STAT_CONFIG_CANNOT_OPEN
	CAPI_STAT_DATA
	CAPI_STAT_DATA_COOKIE
	CAPI_STAT_DATA_DATE
	CAPI_STAT_DATA_DATE_FORMAT
	CAPI_STAT_DATA_DATE_INVALID
	CAPI_STAT_DATA_DATE_NOT_LOCAL
	CAPI_STAT_DATA_DATE_OUTOFRANGE
	CAPI_STAT_DATA_DATE_RANGE
	CAPI_STAT_DATA_EMAIL
	CAPI_STAT_DATA_EMAIL_NOTSET
	CAPI_STAT_DATA_ENCODING
	CAPI_STAT_DATA_HOSTNAME
	CAPI_STAT_DATA_HOSTNAME_FORMAT
	CAPI_STAT_DATA_HOSTNAME_HOST
	CAPI_STAT_DATA_HOSTNAME_SERVER
	CAPI_STAT_DATA_ICAL
	CAPI_STAT_DATA_ICAL_CANTMODIFYRRULE
	CAPI_STAT_DATA_ICAL_COMPEXTRA
	CAPI_STAT_DATA_ICAL_COMPMISSING
	CAPI_STAT_DATA_ICAL_COMPNAME
	CAPI_STAT_DATA_ICAL_COMPVALUE
	CAPI_STAT_DATA_ICAL_FOLDING
	CAPI_STAT_DATA_ICAL_IMPLEMENT
	CAPI_STAT_DATA_ICAL_LINEOVERFLOW
	CAPI_STAT_DATA_ICAL_MISSINGRECURID
	CAPI_STAT_DATA_ICAL_MISSING_UID
	CAPI_STAT_DATA_ICAL_NOATTENDEES
	CAPI_STAT_DATA_ICAL_NONE
	CAPI_STAT_DATA_ICAL_OVERFLOW
	CAPI_STAT_DATA_ICAL_PARAMEXTRA
	CAPI_STAT_DATA_ICAL_PARAMMISSING
	CAPI_STAT_DATA_ICAL_PARAMNAME
	CAPI_STAT_DATA_ICAL_PARAMVALUE
	CAPI_STAT_DATA_ICAL_PROPEXTRA
	CAPI_STAT_DATA_ICAL_PROPMISSING
	CAPI_STAT_DATA_ICAL_PROPNAME
	CAPI_STAT_DATA_ICAL_PROPVALUE
	CAPI_STAT_DATA_ICAL_RECURMODE
	CAPI_STAT_DATA_MIME
	CAPI_STAT_DATA_MIME_CHARSET
	CAPI_STAT_DATA_MIME_COMMENT
	CAPI_STAT_DATA_MIME_ENCODING
	CAPI_STAT_DATA_MIME_HEADER
	CAPI_STAT_DATA_MIME_IMPLEMENT
	CAPI_STAT_DATA_MIME_IMPLEMENT_NESTING
	CAPI_STAT_DATA_MIME_LENGTH
	CAPI_STAT_DATA_MIME_NOICAL
	CAPI_STAT_DATA_MIME_NONE
	CAPI_STAT_DATA_MIME_OVERFLOW
	CAPI_STAT_DATA_QUERY
	CAPI_STAT_DATA_QUERY_CONDITION_ILLEGAL_OPERATOR
	CAPI_STAT_DATA_QUERY_CONDITION_NULL
	CAPI_STAT_DATA_QUERY_CONDITION_PROPERTY_NULL
	CAPI_STAT_DATA_QUERY_CONDITION_PROPERTY_TOO_LONG
	CAPI_STAT_DATA_QUERY_CONDITION_UNKNOWN_OPERATOR
	CAPI_STAT_DATA_QUERY_CONDITION_VALUE_NULL
	CAPI_STAT_DATA_QUERY_CONDITION_VALUE_TOO_LONG
	CAPI_STAT_DATA_QUERY_ILLEGAL_OPERATOR
	CAPI_STAT_DATA_QUERY_NULL
	CAPI_STAT_DATA_RRESULT
	CAPI_STAT_DATA_RRESULT_EOR
	CAPI_STAT_DATA_SERVER
	CAPI_STAT_DATA_UID
	CAPI_STAT_DATA_UID_ALREADYEXISTS
	CAPI_STAT_DATA_UID_FORMAT
	CAPI_STAT_DATA_UID_MULTIPLEMATCHES
	CAPI_STAT_DATA_UID_NOTFOUND
	CAPI_STAT_DATA_UID_RECURRENCE
	CAPI_STAT_DATA_USERID
	CAPI_STAT_DATA_USERID_EXT
	CAPI_STAT_DATA_USERID_EXT_CONFLICT
	CAPI_STAT_DATA_USERID_EXT_FORMAT
	CAPI_STAT_DATA_USERID_EXT_INIFILE
	CAPI_STAT_DATA_USERID_EXT_MANY
	CAPI_STAT_DATA_USERID_EXT_NODE
	CAPI_STAT_DATA_USERID_EXT_NONE
	CAPI_STAT_DATA_USERID_FORMAT
	CAPI_STAT_DATA_USERID_ID
	CAPI_STAT_DATA_VCARD
	CAPI_STAT_DATA_VCARD_COMPNAME
	CAPI_STAT_DATA_VCARD_DUPERROR
	CAPI_STAT_DATA_VCARD_PARAMEXTRA
	CAPI_STAT_DATA_VCARD_PARAMMISSING
	CAPI_STAT_DATA_VCARD_PARAMNAME
	CAPI_STAT_DATA_VCARD_PARAMVALUE
	CAPI_STAT_DATA_VCARD_PROPEXTRA
	CAPI_STAT_DATA_VCARD_PROPMISSING
	CAPI_STAT_DATA_VCARD_PROPNAME
	CAPI_STAT_DATA_VCARD_PROPVALUE
	CAPI_STAT_DATA_VCARD_VERSION_UNSUPPORTED
	CAPI_STAT_LIBRARY
	CAPI_STAT_LIBRARY_IMPLEMENTATION
	CAPI_STAT_LIBRARY_INTERNAL
	CAPI_STAT_LIBRARY_INTERNAL_CONTEXT
	CAPI_STAT_LIBRARY_INTERNAL_COSMICRAY
	CAPI_STAT_LIBRARY_INTERNAL_DATA
	CAPI_STAT_LIBRARY_INTERNAL_EXPIRY
	CAPI_STAT_LIBRARY_INTERNAL_FUNCTION
	CAPI_STAT_LIBRARY_INTERNAL_OVERFLOW
	CAPI_STAT_LIBRARY_INTERNAL_PROTOCOL
	CAPI_STAT_LIBRARY_INTERNAL_UNKNOWN_EXCEPTION
	CAPI_STAT_LIBRARY_INTERNAL_UNKNOWN_LIBRARY_ERRCODE
	CAPI_STAT_LIBRARY_SERVER
	CAPI_STAT_LIBRARY_SERVER_BUSY
	CAPI_STAT_LIBRARY_SERVER_SUPPORT
	CAPI_STAT_LIBRARY_SERVER_SUPPORT_CHARSET
	CAPI_STAT_LIBRARY_SERVER_SUPPORT_STANDARDS
	CAPI_STAT_LIBRARY_SERVER_SUPPORT_UID
	CAPI_STAT_LIBRARY_SERVER_TIMEZONE
	CAPI_STAT_LIBRARY_SERVER_UNAVAILABLE
	CAPI_STAT_LIBRARY_SERVER_USERDATA
	CAPI_STAT_OK
	CAPI_STAT_SECUR
	CAPI_STAT_SECUR_CANTBOOKATTENDEE
	CAPI_STAT_SECUR_LOGON
	CAPI_STAT_SECUR_LOGON_AUTH
	CAPI_STAT_SECUR_LOGON_LOCKED
	CAPI_STAT_SECUR_LOGON_LOCKED_RESOURCE
	CAPI_STAT_SECUR_LOGON_LOCKED_SYSOP
	CAPI_STAT_SECUR_READ
	CAPI_STAT_SECUR_READ_ALARM
	CAPI_STAT_SECUR_READ_PROPS
	CAPI_STAT_SECUR_SERVER
	CAPI_STAT_SECUR_SERVER_LICENSE
	CAPI_STAT_SECUR_SERVER_SET_IDENTITY_SYSOP
	CAPI_STAT_SECUR_SERVER_SET_IDENTITY_SYSOP_REMOTE
	CAPI_STAT_SECUR_WRITE
	CAPI_STAT_SECUR_WRITE_AGENDA
	CAPI_STAT_SECUR_WRITE_EVENT
	CAPI_STAT_SERVICE
	CAPI_STAT_SERVICE_ACE
	CAPI_STAT_SERVICE_ACE_LOAD
	CAPI_STAT_SERVICE_ACE_SUPPORT
	CAPI_STAT_SERVICE_FILE
	CAPI_STAT_SERVICE_FILE_CLOSE
	CAPI_STAT_SERVICE_FILE_DELETE
	CAPI_STAT_SERVICE_FILE_MODE
	CAPI_STAT_SERVICE_FILE_OPEN
	CAPI_STAT_SERVICE_FILE_READ
	CAPI_STAT_SERVICE_FILE_TEMP
	CAPI_STAT_SERVICE_FILE_WRITE
	CAPI_STAT_SERVICE_LIBRARY
	CAPI_STAT_SERVICE_MEM
	CAPI_STAT_SERVICE_MEM_ALLOC
	CAPI_STAT_SERVICE_NET
	CAPI_STAT_SERVICE_NET_TIMEOUT
	CAPI_STAT_SERVICE_THREAD
	CAPI_STAT_SERVICE_TIME
	CAPI_STAT_SERVICE_TIME_GMTIME
	CAPI_STORE_DELPROP
	CAPI_STORE_REPLACE
	CAPI_STORE_UPDATE
	CAPI_SetConfigFile
	CAPI_SetIdentity
	CAPI_SetStreamCallbacks
	CAPI_TASK_RANGE_COMPLETEDTIME
	CAPI_TASK_RANGE_DUETIME
	CAPI_TASK_RANGE_MASK
	CAPI_TASK_RANGE_STARTTIME
	CAPI_THISANDFUTURE
	CAPI_THISANDPRIOR
	CAPI_THISINSTANCE
	FLAG_FETCH_AGENDA_ATTENDEE_ONLY
	FLAG_FETCH_COMBINED
	FLAG_FETCH_DO_NOT_EXPAND_RRULE
	FLAG_FETCH_EXCLUDE_ACCEPTED
	FLAG_FETCH_EXCLUDE_APPOINTMENTS
	FLAG_FETCH_EXCLUDE_DAILYNOTES
	FLAG_FETCH_EXCLUDE_DAYEVENTS
	FLAG_FETCH_EXCLUDE_DECLINED
	FLAG_FETCH_EXCLUDE_HOLIDAYS
	FLAG_FETCH_EXCLUDE_NOTOWNER
	FLAG_FETCH_EXCLUDE_UNCONFIRMED
	FLAG_FETCH_EXPAND_RRULE
	FLAG_FETCH_LOCALTIMES
	FLAG_FETCH_VCARD_VERSION_2_1
	FLAG_FETCH_VCARD_VERSION_3_0
	FLAG_NONE
	FLAG_STORE_CREATE
	FLAG_STORE_IMPORT
	FLAG_STORE_INVITE_SELF
	FLAG_STORE_MODIFY
	FLAG_STORE_REMOVE
	FLAG_STORE_REPLACE
	FLAG_STORE_REPLY
	FLAG_STREAM_NOT_MIME
	HANDLE_INITIALIZER
	LOP_AND
	LOP_OR
	OP_EQ
	OP_EQ_CS
	OP_GE
	OP_GT
	OP_LE
	OP_LT
	OP_NE
	OP_NE_CS
	OP_STARTSWITH
	OP_STARTSWITH_CS
	QUERY_INITIALIZER
	REQUEST_RESULT_INITIALIZER
	SESSION_INITIALIZER
	STREAM_INITIALIZER
	USE_OLD_NAMES
);
our $VERSION = '1.03';

sub AUTOLOAD {
    # This AUTOLOAD is used to 'autoload' constants from the constant()
    # XS function.  If a constant is not found then control is passed
    # to the AUTOLOAD in AutoLoader.

    my $constname;
    our $AUTOLOAD;
    ($constname = $AUTOLOAD) =~ s/.*:://;
    croak "& not defined" if $constname eq 'constant';
    my $val = constant($constname, @_ ? $_[0] : 0);
    if ($! != 0) {
	if ($! =~ /Invalid/ || $!{EINVAL}) {
	    $AutoLoader::AUTOLOAD = $AUTOLOAD;
	    goto &AutoLoader::AUTOLOAD;
	}
	else {
	    croak "Your vendor has not defined CAPI macro $constname";
	}
    }
    {
	no strict 'refs';
	# Fixed between 5.005_53 and 5.005_61
	if ($] >= 5.00561) {
	    *$AUTOLOAD = sub () { $val };
	}
	else {
	    *$AUTOLOAD = sub { $val };
	}
    }
    goto &$AUTOLOAD;
}

bootstrap Oracle::CAPI $VERSION;

# Preloaded methods go here.

# Autoload methods go after =cut, and are processed by the autosplit program.

1;
__END__
# Below is stub documentation for your module. You better edit it!

=head1 NAME

Oracle::CAPI - Perl XS wrapper extension for the Oracle Collaboration Suite CAPI SDK

=head1 SYNOPSIS

  use Oracle::CAPI;
  use Text::vCard;

  Oracle::CAPI::SetConfigFile($CAPI_INI_FNAME,$CAPI_LOG_FNAME) && die("Can't init/log CAPI");
  $capi_session = Oracle::CAPI::CreateSession() || die("Can't create CAPI session");

  # Authenticate to OCS
  $rv = Oracle::CAPI::ReconnectAuthUser($capi_session,$HOSTNAME,$nodeid,$pass,$uname);

  $rv = Oracle::CAPI::FetchContactsFile($capi_session,$VCARD_NAME_TYPE,$VCARD_STARTSWITH_OP,$chr,$filename);
  $rv = Oracle::CAPI::CreateContact($capi_session,$vcard);
  $rv = Oracle::CAPI::DeleteContact($capi_session,$uid);

  $rv = Oracle::CAPI::DestroyPerlSession($capi_session);


=head1 DESCRIPTION

A perl XS wrapper to ctapi.h from the Oracle Collaboration Suite CAPI SDK. This was built and
tested against OCS version 9.0.4.2 on Linux.

=head1 EXPORT

	CAPI_ALARM_DUETIME
	CAPI_ALARM_STARTTIME
	CAPI_CALLBACK_CANT_MALLOC_ERR
	CAPI_CALLBACK_CANT_REALLOC_ERR
	CAPI_CALLBACK_CONTINUE
	CAPI_CALLBACK_DONE
	CAPI_CAPAB_ABOUT_BOX
	CAPI_CAPAB_AUTH
	CAPI_CAPAB_CAPI_VERSION
	CAPI_CAPAB_COMP
	CAPI_CAPAB_ENCR
	CAPI_CAPAB_MAXDATE
	CAPI_CAPAB_SERVER_VERSION
	CAPI_CAPAB_UNSUPPORTED_ICAL_COMP
	CAPI_CAPAB_UNSUPPORTED_ICAL_PROP
	CAPI_CAPAB_VERSION
	CAPI_CreateCallbackStream
	CAPI_CreateFileStreamFromFilenames
	CAPI_CreateMemoryStream
	CAPI_DestroyHandles
	CAPI_DestroyStreams
	CAPI_FLAGS_NONE
	CAPI_FLAG_ALARM_DUETIME
	CAPI_FLAG_ALARM_STARTTIME
	CAPI_FLAG_FETCH_EXCLUDE_APPOINTMENTS
	CAPI_FLAG_FETCH_EXCLUDE_DAILYNOTES
	CAPI_FLAG_FETCH_EXCLUDE_DAYEVENTS
	CAPI_FLAG_FETCH_EXCLUDE_HOLIDAYS
	CAPI_FLAG_FETCH_NO_FIELDHOLDERS
	CAPI_FLAG_NONE
	CAPI_FLAG_STORE_DELPROPS
	CAPI_FLAG_STORE_MODPROPS
	CAPI_GetCapabilities
	CAPI_GetHandle
	CAPI_GetStatusLevels
	CAPI_GetStatusString
	CAPI_H
	CAPI_HANDLE_INITIALIZER
	CAPI_HANDLE_MAILTO
	CAPI_HANDLE_NAME
	CAPI_HANDLE_TYPE
	CAPI_HandleInfo
	CAPI_LOGOFF_STAY_CONNECTED
	CAPI_NOTIFY_EMAIL
	CAPI_NOTIFY_SMS
	CAPI_SESSION_INITIALIZER
	CAPI_STATMASK_3
	CAPI_STATMASK_3_FIELD
	CAPI_STATMASK_4
	CAPI_STATMASK_4_FIELD
	CAPI_STATMASK_5
	CAPI_STATMASK_5_FIELD
	CAPI_STATMASK_CLASS
	CAPI_STATMASK_CLASS_FIELD
	CAPI_STATMASK_MODE_FIELD
	CAPI_STATMODE_FATAL
	CAPI_STAT_API
	CAPI_STAT_API_BADPARAM
	CAPI_STAT_API_CALLBACK
	CAPI_STAT_API_CALLBACK_ERROR
	CAPI_STAT_API_FLAGS
	CAPI_STAT_API_HANDLE
	CAPI_STAT_API_HANDLE_BAD
	CAPI_STAT_API_HANDLE_NOTNULL
	CAPI_STAT_API_HANDLE_NULL
	CAPI_STAT_API_NULL
	CAPI_STAT_API_POOL
	CAPI_STAT_API_POOL_LOCKFAILED
	CAPI_STAT_API_POOL_NOCONNECTIONS
	CAPI_STAT_API_POOL_NOTINITIALIZED
	CAPI_STAT_API_SESSION
	CAPI_STAT_API_SESSION_BAD
	CAPI_STAT_API_SESSION_NOTNULL
	CAPI_STAT_API_SESSION_NULL
	CAPI_STAT_API_STREAM
	CAPI_STAT_API_STREAM_BAD
	CAPI_STAT_API_STREAM_NOTNULL
	CAPI_STAT_API_STREAM_NULL
	CAPI_STAT_CONFIG
	CAPI_STAT_CONFIG_CANNOT_OPEN
	CAPI_STAT_DATA
	CAPI_STAT_DATA_COOKIE
	CAPI_STAT_DATA_DATE
	CAPI_STAT_DATA_DATE_FORMAT
	CAPI_STAT_DATA_DATE_INVALID
	CAPI_STAT_DATA_DATE_NOT_LOCAL
	CAPI_STAT_DATA_DATE_OUTOFRANGE
	CAPI_STAT_DATA_DATE_RANGE
	CAPI_STAT_DATA_EMAIL
	CAPI_STAT_DATA_EMAIL_NOTSET
	CAPI_STAT_DATA_ENCODING
	CAPI_STAT_DATA_HOSTNAME
	CAPI_STAT_DATA_HOSTNAME_FORMAT
	CAPI_STAT_DATA_HOSTNAME_HOST
	CAPI_STAT_DATA_HOSTNAME_SERVER
	CAPI_STAT_DATA_ICAL
	CAPI_STAT_DATA_ICAL_CANTMODIFYRRULE
	CAPI_STAT_DATA_ICAL_COMPEXTRA
	CAPI_STAT_DATA_ICAL_COMPMISSING
	CAPI_STAT_DATA_ICAL_COMPNAME
	CAPI_STAT_DATA_ICAL_COMPVALUE
	CAPI_STAT_DATA_ICAL_FOLDING
	CAPI_STAT_DATA_ICAL_IMPLEMENT
	CAPI_STAT_DATA_ICAL_LINEOVERFLOW
	CAPI_STAT_DATA_ICAL_MISSINGRECURID
	CAPI_STAT_DATA_ICAL_MISSING_UID
	CAPI_STAT_DATA_ICAL_NOATTENDEES
	CAPI_STAT_DATA_ICAL_NONE
	CAPI_STAT_DATA_ICAL_OVERFLOW
	CAPI_STAT_DATA_ICAL_PARAMEXTRA
	CAPI_STAT_DATA_ICAL_PARAMMISSING
	CAPI_STAT_DATA_ICAL_PARAMNAME
	CAPI_STAT_DATA_ICAL_PARAMVALUE
	CAPI_STAT_DATA_ICAL_PROPEXTRA
	CAPI_STAT_DATA_ICAL_PROPMISSING
	CAPI_STAT_DATA_ICAL_PROPNAME
	CAPI_STAT_DATA_ICAL_PROPVALUE
	CAPI_STAT_DATA_ICAL_RECURMODE
	CAPI_STAT_DATA_MIME
	CAPI_STAT_DATA_MIME_CHARSET
	CAPI_STAT_DATA_MIME_COMMENT
	CAPI_STAT_DATA_MIME_ENCODING
	CAPI_STAT_DATA_MIME_HEADER
	CAPI_STAT_DATA_MIME_IMPLEMENT
	CAPI_STAT_DATA_MIME_IMPLEMENT_NESTING
	CAPI_STAT_DATA_MIME_LENGTH
	CAPI_STAT_DATA_MIME_NOICAL
	CAPI_STAT_DATA_MIME_NONE
	CAPI_STAT_DATA_MIME_OVERFLOW
	CAPI_STAT_DATA_QUERY
	CAPI_STAT_DATA_QUERY_CONDITION_ILLEGAL_OPERATOR
	CAPI_STAT_DATA_QUERY_CONDITION_NULL
	CAPI_STAT_DATA_QUERY_CONDITION_PROPERTY_NULL
	CAPI_STAT_DATA_QUERY_CONDITION_PROPERTY_TOO_LONG
	CAPI_STAT_DATA_QUERY_CONDITION_UNKNOWN_OPERATOR
	CAPI_STAT_DATA_QUERY_CONDITION_VALUE_NULL
	CAPI_STAT_DATA_QUERY_CONDITION_VALUE_TOO_LONG
	CAPI_STAT_DATA_QUERY_ILLEGAL_OPERATOR
	CAPI_STAT_DATA_QUERY_NULL
	CAPI_STAT_DATA_RRESULT
	CAPI_STAT_DATA_RRESULT_EOR
	CAPI_STAT_DATA_SERVER
	CAPI_STAT_DATA_UID
	CAPI_STAT_DATA_UID_ALREADYEXISTS
	CAPI_STAT_DATA_UID_FORMAT
	CAPI_STAT_DATA_UID_MULTIPLEMATCHES
	CAPI_STAT_DATA_UID_NOTFOUND
	CAPI_STAT_DATA_UID_RECURRENCE
	CAPI_STAT_DATA_USERID
	CAPI_STAT_DATA_USERID_EXT
	CAPI_STAT_DATA_USERID_EXT_CONFLICT
	CAPI_STAT_DATA_USERID_EXT_FORMAT
	CAPI_STAT_DATA_USERID_EXT_INIFILE
	CAPI_STAT_DATA_USERID_EXT_MANY
	CAPI_STAT_DATA_USERID_EXT_NODE
	CAPI_STAT_DATA_USERID_EXT_NONE
	CAPI_STAT_DATA_USERID_FORMAT
	CAPI_STAT_DATA_USERID_ID
	CAPI_STAT_DATA_VCARD
	CAPI_STAT_DATA_VCARD_COMPNAME
	CAPI_STAT_DATA_VCARD_DUPERROR
	CAPI_STAT_DATA_VCARD_PARAMEXTRA
	CAPI_STAT_DATA_VCARD_PARAMMISSING
	CAPI_STAT_DATA_VCARD_PARAMNAME
	CAPI_STAT_DATA_VCARD_PARAMVALUE
	CAPI_STAT_DATA_VCARD_PROPEXTRA
	CAPI_STAT_DATA_VCARD_PROPMISSING
	CAPI_STAT_DATA_VCARD_PROPNAME
	CAPI_STAT_DATA_VCARD_PROPVALUE
	CAPI_STAT_DATA_VCARD_VERSION_UNSUPPORTED
	CAPI_STAT_LIBRARY
	CAPI_STAT_LIBRARY_IMPLEMENTATION
	CAPI_STAT_LIBRARY_INTERNAL
	CAPI_STAT_LIBRARY_INTERNAL_CONTEXT
	CAPI_STAT_LIBRARY_INTERNAL_COSMICRAY
	CAPI_STAT_LIBRARY_INTERNAL_DATA
	CAPI_STAT_LIBRARY_INTERNAL_EXPIRY
	CAPI_STAT_LIBRARY_INTERNAL_FUNCTION
	CAPI_STAT_LIBRARY_INTERNAL_OVERFLOW
	CAPI_STAT_LIBRARY_INTERNAL_PROTOCOL
	CAPI_STAT_LIBRARY_INTERNAL_UNKNOWN_EXCEPTION
	CAPI_STAT_LIBRARY_INTERNAL_UNKNOWN_LIBRARY_ERRCODE
	CAPI_STAT_LIBRARY_SERVER
	CAPI_STAT_LIBRARY_SERVER_BUSY
	CAPI_STAT_LIBRARY_SERVER_SUPPORT
	CAPI_STAT_LIBRARY_SERVER_SUPPORT_CHARSET
	CAPI_STAT_LIBRARY_SERVER_SUPPORT_STANDARDS
	CAPI_STAT_LIBRARY_SERVER_SUPPORT_UID
	CAPI_STAT_LIBRARY_SERVER_TIMEZONE
	CAPI_STAT_LIBRARY_SERVER_UNAVAILABLE
	CAPI_STAT_LIBRARY_SERVER_USERDATA
	CAPI_STAT_OK
	CAPI_STAT_SECUR
	CAPI_STAT_SECUR_CANTBOOKATTENDEE
	CAPI_STAT_SECUR_LOGON
	CAPI_STAT_SECUR_LOGON_AUTH
	CAPI_STAT_SECUR_LOGON_LOCKED
	CAPI_STAT_SECUR_LOGON_LOCKED_RESOURCE
	CAPI_STAT_SECUR_LOGON_LOCKED_SYSOP
	CAPI_STAT_SECUR_READ
	CAPI_STAT_SECUR_READ_ALARM
	CAPI_STAT_SECUR_READ_PROPS
	CAPI_STAT_SECUR_SERVER
	CAPI_STAT_SECUR_SERVER_LICENSE
	CAPI_STAT_SECUR_SERVER_SET_IDENTITY_SYSOP
	CAPI_STAT_SECUR_SERVER_SET_IDENTITY_SYSOP_REMOTE
	CAPI_STAT_SECUR_WRITE
	CAPI_STAT_SECUR_WRITE_AGENDA
	CAPI_STAT_SECUR_WRITE_EVENT
	CAPI_STAT_SERVICE
	CAPI_STAT_SERVICE_ACE
	CAPI_STAT_SERVICE_ACE_LOAD
	CAPI_STAT_SERVICE_ACE_SUPPORT
	CAPI_STAT_SERVICE_FILE
	CAPI_STAT_SERVICE_FILE_CLOSE
	CAPI_STAT_SERVICE_FILE_DELETE
	CAPI_STAT_SERVICE_FILE_MODE
	CAPI_STAT_SERVICE_FILE_OPEN
	CAPI_STAT_SERVICE_FILE_READ
	CAPI_STAT_SERVICE_FILE_TEMP
	CAPI_STAT_SERVICE_FILE_WRITE
	CAPI_STAT_SERVICE_LIBRARY
	CAPI_STAT_SERVICE_MEM
	CAPI_STAT_SERVICE_MEM_ALLOC
	CAPI_STAT_SERVICE_NET
	CAPI_STAT_SERVICE_NET_TIMEOUT
	CAPI_STAT_SERVICE_THREAD
	CAPI_STAT_SERVICE_TIME
	CAPI_STAT_SERVICE_TIME_GMTIME
	CAPI_STORE_DELPROP
	CAPI_STORE_REPLACE
	CAPI_STORE_UPDATE
	CAPI_SetConfigFile
	CAPI_SetIdentity
	CAPI_SetStreamCallbacks
	CAPI_TASK_RANGE_COMPLETEDTIME
	CAPI_TASK_RANGE_DUETIME
	CAPI_TASK_RANGE_MASK
	CAPI_TASK_RANGE_STARTTIME
	CAPI_THISANDFUTURE
	CAPI_THISANDPRIOR
	CAPI_THISINSTANCE
	FLAG_FETCH_AGENDA_ATTENDEE_ONLY
	FLAG_FETCH_COMBINED
	FLAG_FETCH_DO_NOT_EXPAND_RRULE
	FLAG_FETCH_EXCLUDE_ACCEPTED
	FLAG_FETCH_EXCLUDE_APPOINTMENTS
	FLAG_FETCH_EXCLUDE_DAILYNOTES
	FLAG_FETCH_EXCLUDE_DAYEVENTS
	FLAG_FETCH_EXCLUDE_DECLINED
	FLAG_FETCH_EXCLUDE_HOLIDAYS
	FLAG_FETCH_EXCLUDE_NOTOWNER
	FLAG_FETCH_EXCLUDE_UNCONFIRMED
	FLAG_FETCH_EXPAND_RRULE
	FLAG_FETCH_LOCALTIMES
	FLAG_FETCH_VCARD_VERSION_2_1
	FLAG_FETCH_VCARD_VERSION_3_0
	FLAG_NONE
	FLAG_STORE_CREATE
	FLAG_STORE_IMPORT
	FLAG_STORE_INVITE_SELF
	FLAG_STORE_MODIFY
	FLAG_STORE_REMOVE
	FLAG_STORE_REPLACE
	FLAG_STORE_REPLY
	FLAG_STREAM_NOT_MIME
	HANDLE_INITIALIZER
	LOP_AND
	LOP_OR
	OP_EQ
	OP_EQ_CS
	OP_GE
	OP_GT
	OP_LE
	OP_LT
	OP_NE
	OP_NE_CS
	OP_STARTSWITH
	OP_STARTSWITH_CS
	QUERY_INITIALIZER
	REQUEST_RESULT_INITIALIZER
	SESSION_INITIALIZER
	STREAM_INITIALIZER
	USE_OLD_NAMES

=head1 FUNCTIONS

Unless otherwise noted, all functions return false on success. Check $rv against a CAPI_STAT* constant
for more details (see C<GetStatusString>. Refer to the Oracle CAPI SDK documentation for more details on the functions.

=over

=item C<SetConfigFile>

 $rv = Oracle::CAPI::SetConfigFile($config_filename,$log_filename);

This will usually be called first, set the CAPI ini file and log filenames.


=item C<Authenticate>

 $capi_session = Oracle::CAPI::Authenticate($hostname,$username,$password);

Create an authenticated session for $hostname using $username and $password. Return the session object
or undef on failure.


=item C<SysopAuthUser>

 $capi_session = Oracle::CAPI::SysopAuthUser($hostname,$nodeid,$sysop_pass,$uname);

Create an authenticated session for $hostname, $uname and $nodeid using the sysop password $sysop_pass. Return the session object
or undef on failure.


=item C<CreateSession>

 $capi_session = Oracle::CAPI::CreateSession();

Initialize a session process.


=item C<ReconnectAuthUser>

 $capi_session = Oracle::CAPI::ReconnectAuthUser($capi_session,$HOSTNAME,$nodeid,$sysop_pass,$uname);

Reconnect $capi_session to $uname using the sysop password $sysop_pass.


=item C<FetchContactsFile>

 $rv = Oracle::CAPI::FetchContactsFile($capi_session,$VCARD_NAME_TYPE,$VCARD_STARTSWITH_OP,$chr,$output_filename);

Query for contacts and dump to $output_filename see CAPI SDK documentation for details on query search parameters.

NOTE! Returns false on SUCCESS.


=item C<CreateContact>

 $rv = Oracle::CAPI::CreateContact($capi_session,$vcard);

Create a contact represented by a new vCard $vcard.


=item C<StoreContactUpdate>

 $rv = Oracle::CAPI::StoreContactUpdate($capi_session,$vcard);

Updates a contact already on the server with the new vCard as $vcard. The vCard with that UID is then updated: all properties contained
in the vCard on the server that are present in the passed-in vCard are modified to contain the property values of the passed-in
vCard. Also, all properties that exist in the passed-in vCard that don't exist on the server vCard are added to the server vCard.
All other properties not present in the passed-in vCard that exist on the server are ignored.


=item C<DeleteContact>

 $rv = Oracle::CAPI::DeleteContact($capi_session,$uid);

Delete the contact identified by the vCard's UID ($uid).


=item C<GetStatusString>

 $status = Oracle::CAPI::GetStatusString($rv);

Return the constant name (see EXPORT) for the return status $rv returned from
many of the CAPI functions.


=item C<DestroyPerlSession>

 $rv = Oracle::CAPI::DestroyPerlSession($capi_session);

Destroy the session $capi_session.


=back


=head1 BUGS

C<StoreContactUpdate> had some problems due to the SDK implementation of early 9.0.4 releases.

There are many other functions available (see CAPI.xs), those not documented here may or may not work.

=head1 AUTHOR

Reed Sandberg, E<lt>reed_sandberg Ӓ yahooE<gt>

=head1 SEE ALSO

Oracle CAPI SDK (CSDK) docs.

=head1 COPYRIGHT

Copyright (C) 2004 Reed Sandberg
All rights reserved. This program is free software; you can redistribute
it and/or modify it under the same terms as Perl itself.

=cut
