use strictures 2;
use lib '../lib';
use SDL2 qw[:all];

# https://gigi.nullneuron.net/gigilabs/sdl2-pixel-drawing/
my $quit  = 0;
my $event = SDL2::Event->new();
SDL_Init(SDL_INIT_VIDEO);
my $window = SDL_CreateWindow( "SDL2 Pixel Drawing",
    SDL2::SDL_WINDOWPOS_UNDEFINED, SDL2::SDL_WINDOWPOS_UNDEFINED, 640, 480, 0 );
my $renderer = SDL_CreateRenderer( $window, -1, 0 );
my $texture  = SDL_CreateTexture(
    $renderer,
    SDL2::SDL_PIXELFORMAT_ARGB8888,
    SDL2::SDL_TEXTUREACCESS_STATIC,
    640, 480
);
my @pixels;
my $drawing = 0;

while ( !$quit ) {
    SDL2::SDL_WaitEventTimeout( $event, 10 );
    if ( $event->type == SDL2::SDL_QUIT ) {
        $quit = 1;
    }
    elsif ( $event->type == SDL2::SDL_MOUSEBUTTONDOWN &&
        $event->button->button == SDL2::SDL_BUTTON_LEFT ) {
        $drawing = 1;
    }
    elsif ( $event->type == SDL2::SDL_MOUSEBUTTONUP &&
        $event->button->button == SDL2::SDL_BUTTON_LEFT ) {
        $drawing = 0;
    }
    elsif ( $event->type == SDL2::SDL_MOUSEMOTION && $drawing ) {
        push @pixels,    #{x => $event->motion->x, y => $event->motion->y};
            SDL2::Point->new( { x => $event->motion->x, y => $event->motion->y } );

        #warn sprintf 'x: %d * y: %d', $pixels[-1]->x, $pixels[-1]->y;
    }
    SDL_SetRenderDrawColor( $renderer, 242, 242, 242, 255 );
    SDL_RenderClear($renderer);
    CORE::state $i  = 0;
    CORE::state $up = 1;
    $up = -1 if $i >= 255;
    $up = 1  if $i <= 0;
    $i += $up;
    SDL_SetRenderDrawColor( $renderer, $i, 128, 128, 255 );
    SDL_RenderDrawPoints( $renderer, @pixels ) if @pixels;
    SDL_RenderDrawLine( $renderer, 300, 240, 340, 240 );
    SDL_RenderDrawPointF( $renderer, 25.5, 100.25 );
    SDL_RenderDrawLineF( $renderer, 100, 100, 250, 150 );
    SDL_RenderDrawLineF( $renderer, 120, 120, 270, 170 );
    SDL_RenderFillRects(
        $renderer,
        SDL2::Rect->new( { x => 100, y => 100, w => 100, h => 100 } ),
        SDL2::Rect->new( { x => 75,  y => 75,  w => 50,  h => 50 } )
    );

    #warn SDL_GetError() if @pixels;
    SDL2::SDL_RenderPresent($renderer);
}
SDL2::SDL_DestroyRenderer($renderer);
SDL2::SDL_DestroyWindow($window);
SDL2::SDL_Quit();
exit;
