use ExtUtils::MakeMaker;
use IO::File;
require 5.006;
# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.

my($cvs_bin) = prompt('Your cvs path and binary name: ', '/usr/bin/cvs');
my($external) = prompt('cvs -d option: ', '');

my($subs) = "sub CVS_BIN  () { '$cvs_bin' }";
if(defined($external)) { $subs .= "\nsub EXTERNAL () { '$external' }" };

my($fh) = IO::File->new('lib/Cvs/Simple/Config.pm', 'w');
$fh->print(<<"CONFIG");
#!/usr/bin/perl
# Auto-generated by Makefile.PL
package Cvs::Simple::Config;
use strict;
use warnings;

$subs

1;

__END__

=pod

=head1 Cvs::Simple::Config

=head1 DESCRIPTION

This module is auto-generated by Makefile.PL during installation of
Cvs::Simple.  Any changes made here will be lost if the module is re-installed
or upgraded.

=head1 FUNCTIONS

=over 4

=item CVS_BIN

Stores location of cvs binary. Defaults to C</usr/bin/cvs>.

=item EXTERNAL

Stores location of external repository, i.e. whatever you would give to C<cvs
-d>.  This function will not appear if the option is not set at install time.

=back

=cut

CONFIG

$fh->close;

WriteMakefile(
    NAME              => 'Cvs::Simple',
    VERSION_FROM      => 'lib/Cvs/Simple.pm', # finds $VERSION
    LICENSE           => 'perl',
    PREREQ_PM => {
            'version'             => 0,
            'Class::Std::Utils'   => 0,
            'Cwd'                 => 0,
            'Scalar::Util'        => 0,
            'File::Copy'          => 0,
            'File::Path'          => 0,
            'File::Spec'          => 0,
            'Test::Pod'           => 1.14,
            'Test::Pod::Coverage' => 1.04,
            'Test::More'          => 0,
    },
    ($] >= 5.005 ?     ## Add these new keywords supported since 5.005
      (ABSTRACT_FROM  => 'lib/Cvs/Simple.pm', # retrieve abstract from module
       AUTHOR         => 'Stephen Cardie <stephenca@ls26.net>') : ()),
);
