/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.SQLBinary;
import org.apache.derby.iapi.util.StringUtil;

public class SQLBit
extends SQLBinary {
    public Object getObject() throws StandardException {
        return this.getBytes();
    }

    public String getTypeName() {
        return "CHAR () FOR BIT DATA";
    }

    public int getTypeFormatId() {
        return 87;
    }

    public DataValueDescriptor getNewNull() {
        return new SQLBit();
    }

    public void setValueFromResultSet(ResultSet resultSet, int n, boolean bl) throws SQLException {
        this.dataValue = resultSet.getBytes(n);
        if (bl && resultSet.wasNull()) {
            this.setToNull();
        }
    }

    public int typePrecedence() {
        return 140;
    }

    public SQLBit() {
    }

    public SQLBit(byte[] byArray) {
        this.dataValue = byArray;
    }

    public final void setValue(Object object) throws StandardException {
        if (object == null) {
            this.setToNull();
        } else if (object instanceof byte[]) {
            this.setValue((byte[])object);
        } else {
            this.throwLangSetMismatch(object);
        }
    }

    public void normalize(DataTypeDescriptor dataTypeDescriptor, DataValueDescriptor dataValueDescriptor) throws StandardException {
        int n = dataTypeDescriptor.getMaximumWidth();
        this.setValue(dataValueDescriptor.getBytes());
        this.setWidth(n, 0, true);
    }

    public DataValueDescriptor setWidth(int n, int n2, boolean bl) throws StandardException {
        if (this.getValue() == null) {
            return this;
        }
        int n3 = this.dataValue.length;
        if (n3 < n) {
            byte[] byArray = new byte[n];
            System.arraycopy(this.dataValue, 0, byArray, 0, this.dataValue.length);
            Arrays.fill(byArray, this.dataValue.length, byArray.length, (byte)32);
            this.dataValue = byArray;
        } else if (n3 > n) {
            if (bl) {
                for (int i = n; i < this.dataValue.length; ++i) {
                    if (this.dataValue[i] == 32) continue;
                    throw StandardException.newException("22001", this.getTypeName(), (Object)StringUtil.formatForPrint(this.toString()), (Object)String.valueOf(n));
                }
            }
            byte[] byArray = new byte[n];
            System.arraycopy(this.dataValue, 0, byArray, 0, n);
            this.dataValue = byArray;
        }
        return this;
    }
}

