use inc::Module::Install;

name            "Catalyst-Authentication-Credential-OpenID";
all_from        "lib/Catalyst/Authentication/Credential/OpenID.pm";
author          "Ashley Pond V <ashley@cpan.org>";

requires  "parent"                => "0.2";
requires  "Class::Accessor::Fast" => undef;
requires  "HTML::Parser"          => "3";
requires  "LWP::UserAgent"        => undef;
requires  "Catalyst"              => "5.7";
requires  "Catalyst::Devel"       => "1";
requires  "Crypt::DH"             => "0.05"; # IIRC OpenID stuff forgets to prereq this
requires  "Net::OpenID::Consumer" => "0.14";
requires  "Catalyst::Authentication::User::Hash" => undef;
requires  "Cache::FastMmap"       => "1.28";
requires  "Catalyst::Plugin::Session::Store::FastMmap" => "0.05";
requires  "Catalyst::Plugin::Session::State::Cookie" => "0.08";
requires  "Catalyst::Engine::HTTP" => undef;

recommends "Config::General"     => "2";
recommends "YAML"                => "0.6";
recommends "LWPx::ParanoidAgent" => "1.03";
recommends "Math::BigInt"        => undef;

build_requires  "Test::More"           => "0.42";
build_requires  "Net::OpenID::Server"  => undef;
build_requires  "Test::WWW::Mechanize" => "1.20";
build_requires  "Net::DNS"             => undef;
build_requires  "IO::Socket::INET"     => undef;

auto_install;
WriteAll;

__END__
