use strict;
use warnings;
use lib 'lib';
use aliased 'Javonet::Javonet' => 'Javonet', qw(in_memory tcp);

use File::Spec;
use Test::More qw(no_plan);

my $runtimeContextInMemoryFirst = Javonet->in_memory()->perl();
my $runtimeContextInMemorySecond = Javonet->in_memory()->perl();
my $runtimeContextTcpFirst = Javonet->tcp('123.121.22.55:2212')->perl();
my $runtimeContextTcpSecond =  Javonet->tcp("123.121.22.56:2212")->perl();
my $runtimeContextTcpThird =  Javonet->tcp("123.121.22.55:2212")->perl();

cmp_ok(scalar $runtimeContextInMemoryFirst, '==', $runtimeContextInMemorySecond, 'Invoking_multiple_runtime_contexts_in_memory_to_check_if_singleton');
cmp_ok(scalar $runtimeContextInMemoryFirst, '!=', $runtimeContextTcpFirst, 'In memory and tcp runtimes are not the same');
cmp_ok(scalar $runtimeContextTcpFirst, '!=', $runtimeContextTcpSecond, 'Tcp runtimes with different address are not the same');
cmp_ok(scalar $runtimeContextTcpFirst, '==', $runtimeContextTcpThird, 'Tcp runtimes with same address are the same');

done_testing();
