# all.tcl --
#
# This file contains a top-level script to run all of the Tcl
# tests.  Execute it by invoking "source all.test" when running tcltest
# in this directory.
#
# Copyright (c) 1998-2000 by Ajuba Solutions
# Copyright (c) 2002 Jeffrey Hobbs
#
# See the file "license.txt" for information on usage and redistribution
# of this file, and for a DISCLAIMER OF ALL WARRANTIES.
# 
# RCS: @(#) $Id: all.tcl,v 1.5 2002/04/30 01:30:27 hobbs Exp $

package require tcltest
namespace import -force ::tcltest::*

set ::tcltest::testSingleFile false
set ::tcltest::testsDirectory [file dir [info script]]

# We need to ensure that the testsDirectory is absolute
catch {::tcltest::normalizePath ::tcltest::testsDirectory}

set chan $::tcltest::outputChannel
set shell [info nameofexecutable]

puts $chan "Tk $tk_patchLevel tests running in interp: [info nameofexecutable]"
puts $chan "Tests running with pwd:           [pwd]"
puts $chan "Tests running in working dir:     $::tcltest::testsDirectory"
if {[llength $::tcltest::skip] > 0} {
    puts $chan "Skipping tests that match:            $::tcltest::skip"
}
if {[llength $::tcltest::match] > 0} {
    puts $chan "Only running tests that match:        $::tcltest::match"
}

if {[llength $::tcltest::skipFiles] > 0} {
    puts $chan "Skipping test files that match:       $::tcltest::skipFiles"
}
if {[llength $::tcltest::matchFiles] > 0} {
    puts $chan "Only sourcing test files that match:  $::tcltest::matchFiles"
}

set timeCmd {clock format [clock seconds]}
puts $chan "Tests began at [eval $timeCmd]"

# source each of the specified tests
foreach file [lsort [::tcltest::getMatchingFiles]] {
    set tail [file tail $file]
    puts $chan $tail

    # Change to the tests directory so the value of the following
    # variable is set correctly when we spawn the child test processes
    #cd $::tcltest::testsDirectory
    set cmd [concat [list | $shell $file] [split $argv]]
    if {[catch {
	set pipeFd [open $cmd "r"] 
	while {[gets $pipeFd line] >= 0} {
	    puts $chan $line
	}
	close $pipeFd
    } msg]} {
	# Print results to ::tcltest::outputChannel.
	puts $chan $msg
    }
}

# cleanup
puts $chan "\nTests ended at [eval $timeCmd]"
::tcltest::cleanupTests 1

exit
