# $Id: filechsr.tcl,v 1.1 1993/03/28 02:15:15 sls Exp $

#
# FileChooser implements a simple file chooser.
#
class FileChooser {
    member w .filechooser
    member ok 0
    member read 1
    member write 0
    member file {}
    method run {prompt {read 1} {write 0} {default {}}} {
	set w [getmember w]
	setmember read $read
	setmember write $write
	catch {destroy $w}
	toplevel $w
	frame $w.e
	label $w.e.l -text $prompt -anchor w
	entry $w.e.e -relief sunken -width 40
	if {$default != {}} {
	    $w.e.e insert 0 $default
	}
	pack append $w.e \
	    $w.e.l "left frame w padx 2" \
	    $w.e.e "right fillx expand"
	bind $w.e.e <Return> "FileChooser:ok $this"
	frame $w.buts
	button $w.ok -text "Ok" -command "FileChooser:ok $this"
	button $w.cancel -text "Cancel" -command "FileChooser:cancel $this"
	pack append $w.buts \
	    $w.ok "left fillx expand" \
	    $w.cancel "left fillx expand"
	label $w.status -anchor w -bd 2 -relief sunken \
	    -font -*-Helvetica-Medium-R-*-*-14-*
	pack append $w \
	    $w.e "top fillx expand" \
	    $w.buts "fillx pady .5c" \
	    $w.status "fillx"
	grab set $w
	tkwait window $w
	if [getmember ok] {
	    return [getmember file]
	}
	return {}
    }
    method ok {} {
	set w [getmember w]
	set file [$w.e.e get]
	setmember file $file
	if [getmember read] {
	    if [file readable $file] {
		setmember ok 1
		destroy $w
	    } else {
		$w.status config -text "Can't read file $file"
	    }
	    return
	}
	if [getmember write] {
	    if ![catch {open $file w} f] {
		close $f
		setmember ok 1
		destroy $w
	    } else {
		$w.status config -text "Can't write to file $file"
	    }
	    return
	}
    }
    method cancel {} {
	setmember ok 0
	destroy [getmember w]
    }
}
