#############################################################################
#
# convert.tcl
#	Conversion of names
#
# RF {FileName {Prefix $env(HOME)}}
#       Prepend a file or directory name with the Prefix if the name is not
#       absolute (doesn't begin with '/'). Return this name.
#
# FW {Fol}
#	check if foldername contains '.', and replace by 'dOt'. prepend 
#	with '.f'. return w
# WF {w}
#	extract foldername from window name, return Fol
# 
# SW {Fol Msg}
#	Do the same for a show window
# WS {w} 
#	reverse, return {Fol Msg}
#
# EW {Fol Msg}
# WE {w}
#	And for an edit window
#
#############################################################################

proc RF "FileName {Prefix $env(HOME)}" {
    if {[string first "/" $FileName] != 0} {
        set FileName $Prefix/$FileName
    }
    return $FileName
}

proc FW Fol {
    regsub -all {\.} $Fol {DoT} Fol
    return ".f$Fol"
}
proc WF {w} {
    regsub {.f} $w {} Fol
    regsub -all {DoT} $Fol {.} Fol
    return $Fol
}

proc SW {Fol Msg} {
    regsub -all {\.} $Fol {DoT} Fol
    return .s$Fol#$Msg
}
proc WS {w} {
    regsub {.s} $w {} w
    set i [string last {#} $w]
    set Fol [string range $w 0 [expr $i - 1]]
    regsub -all {DoT} $Fol {.} Fol
    set Msg [string range $w [expr $i + 1] [expr [string length $w] - 1]]
    return "$Fol $Msg"
}

proc EW {Fol Msg} {
    regsub -all {\.} $Fol {DoT} Fol
    return .e$Fol#$Msg
}
proc WE {w} {
    regsub {.e} $w {} w
    set i [string last {#} $w]
    set Fol [string range $w 0 [expr $i - 1]]
    regsub -all {DoT} $Fol {.} Fol
    set Msg [string range $w [expr $i + 1] [expr [string length $w] - 1]]
    return "$Fol $Msg"
}

