.TH "ipcNewReceiver" TCL "" "TCL"
.ad b
.SH NAME
ipcNewReceiver, ipcDestroyReceiver, ipcDestroyReceiverFromHandle - create and destroy tclIPC receivers.
.SH SYNOPSIS
.PP
.nf
.ft CW
#include <tclipc.h>

Receiver
ipcNewReceiver(Tcl_Interp *interp,
               char *label, 
               char *portManHost);

int
ipcDestroyReceiver(Tcl_Interp *interp, 
                   Receiver receiver);

int
ipcDestroyReceiverFromHandle(Tcl_Interp *interp,
                             char *handle);
.ft R
.fi
'
.SH DESCRIPTION
.PP
These functions allow the C programmer to create and destroy \fBtclIPC\fR receivers.
'
.SS ipcNewReceiver
.PP
Create a new receiver.  The receiver is an opaque structure.  The PortManager on machine portManHost is used to register the label/host pair where the host is the name of the the machine executing the ipcNewReceiver procedure.  The label/host pair must be unique on the destination PortManager or the ipcNewReceiver call will fail.
.PP
Parameters:
.RS 2
\fBo \fIinterp\fR -  Any error messages generated will be returned in this interpreter's result. This interpreter is used to evaluate commands submitted to the newly created receiver. 
.br
.PP
\fBo \fIlabel\fR - This string value is used to identify this receiver when it is registered with the PortManager.
.br
.PP
\fBo \fIportManHost\fR - The name of the machine where the PortManager that should be used to register this receiver is located.
.br
.RE
.PP
Returns:
.RS 2
Returns NULL if the new receiver could not be created.  The result string of the Tcl_Interp is set to the cause.  The successful function call returns a new, registered receiver.
.RE
'
.SS ipcDestroyReceiver
.PP
Delete a receiver and the resources associated with the receiver.  The input argument is an opaque receiver structure.  The appropriate PortManager is contacted and the receiver's registration is removed. 
.PP
Parameters:
.RS 2
\fBo \fIinterp\fR - Any error message will be returned in the result of this interpreter.
.br
.PP
\fBo \fIreceiver\fR - A receiver as returned by ipcNewReceiver.
.br
.RE
.PP
Returns:
.RS 2
TCL_OK if the receiver was destroyed or TCL_ERROR if an error was generated during the destruction.
.RE
'
.SS ipcDestroyReceiverFromHandle
.PP
Delete a receiver and the resources associated with the receiver.  The input argument is an IPC handle name.  The appropriate PortManager is contacted and the receiver's registration is removed. 
.PP
Parameters:
.RS 2
\fBo \fIinterp\fR - Any error message will be returned in the result of this interpreter.
.br
.PP
\fBo \fIhandle\fR - A string-valued IPC handle as returned by the TCL receiver new command.  This is an Extended-TCL handle.
.RE
.PP
Returns:
.RS 2
TCL_OK if the receiver was destroyed or TCL_ERROR if an error was generated during the destruction.
.RE
'


