/*
 * Copyright 1987-1991 Regents of the University of California
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without
 * fee is hereby granted, provided that the above copyright
 * notice appears in all copies.  The University of California
 * makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without
 * express or implied warranty.
 */
/*
 * Copyright 1992 by the National Optical Astronomy Observatories(*)
 *
 * Permission to use, copy, and distribute
 * is hereby granted without fee, providing that the above copyright
 * notice appear in all copies and that both the copyright notice and this
 * permission notice appear in supporting documentation.
 *
 * This software is provided "as is" without any express or implied warranty.
 *
 * (*) Operated by the Association of Universities for Research in
 *     Astronomy, Inc. (AURA) under cooperative agreement with the
 *     National Science Foundation.
 */
/* Program: pm.c
 *      This file is the main for the TCL IPC PortManager.
 *	This file does rude things that normal users of tclIPC probably
 *	would not do.
 *
 * Created: K. Gillies 26 June 1992
 * SCCS INFO
 *      @(#)pm.c	1.1 9/11/92
 *
 */
#include <stdio.h>
#include <assert.h>
#include <string.h>
#include "tcl.h"
#include "tclipc.h"
#include "tclpm.h"

/* This is the "label" for the PortManager.  PortManager is too long. */
#define PROGRAMNAME "portmanager"             /* Portmanager */

/* Used for setting time for message checks */
#define TIMEOUTSECS     0
#define TIMEOUTUSECS    200000

#define TRUE            1
#define FALSE           0
#define MYBUFSIZ        64

/* Something I use to reduce length of arg lists */
typedef struct _tclInfo {
  Tcl_Interp *interp;
  Tcl_CmdBuf buffer;
} tclinfo, *tclInfo;

/* In file function prototypes */
static int cmdQuit _ANSI_ARGS_((ClientData *clientData, Tcl_Interp *interp, 
				int argc, char *argv[]));
static int cmdEcho _ANSI_ARGS_((ClientData *clientData, Tcl_Interp *interp, 
			       int argc, char *argv[]));
static tclInfo tclInit _ANSI_ARGS_((void));
static void Usage _ANSI_ARGS_((char *name));
static void tclEventLoop _ANSI_ARGS_((tclInfo info));

/* In file variables */
static char prompt[MYBUFSIZ];
static int foregroundFlag = FALSE;

#if defined(__STDC__)        /* Gcc optimizes this away unless it's volatile */
static volatile int quitFlag = FALSE;
#else
static int quitFlag = FALSE;
#endif

static char *initCmd =
 "if [file exists [info library]/init.tcl] {source [info library]/init.tcl}";

/*
 *--------------------------------------------------------------
 *
 * main
 *
 *      Initialize the PortManager and wait for connects.
 *
 * Results:
 *      
 *--------------------------------------------------------------
 */
#ifdef STANDALONE
int main(argc, argv)
int argc;
char *argv[];
{
  tclInfo info;	               /* the pm interpereter */
  char *program;

  /* Set the prompt to show us a reminder */
  program = argv[0];
  sprintf(prompt, "%s> ", PROGRAMNAME);

  argc--, argv++;
  while (argc) {
    if (**argv == '-') {
      if (strcmp(*argv, "-f") == 0) {        /* start in foreground */
        foregroundFlag = TRUE;
      } else {
        Usage(program);
      }
      argc--, argv++;
    }
  }

  /* Initialize my TCL stuff and the ipc code */
  info = tclInit();
  /* Add the commands */
  ipcInterpInit(info->interp);

  /* Set the time to check for commands and use our own listener */
  ipcSendInit(TIMEOUTSECS, TIMEOUTUSECS, 0, 0,
	      NULL, pmListenForMessages, NULL, NULL);
  /* Initialize the PortManager list */
  tclPmInit(info->interp);   
  if (foregroundFlag) {
    tclEventLoop(info);
  } else {
    while (!quitFlag) {
      ipcWaitForMessages();
    }
  }
  return 0;
}
#endif

/*
 *--------------------------------------------------------------
 *
 * usage
 *
 *      Show the programs correct usage.
 *
 * Results:
 * 
 */
static void Usage(name)
char *name;
{
  fprintf(stderr, "usage: %s name [-f]\n", name);
  exit(1);
}

/*
 *--------------------------------------------------------------
 *
 * tclInit
 *
 *      Create the an interpreter, command buffer and add a
 *      couple of commands.
 *
 * Results: a valid tclInfo struct.
 * 
 */
static tclInfo tclInit()
{
  int result;
  tclInfo info;

  info = (tclInfo)ckalloc(sizeof(tclinfo));
  assert(info != NULL);

  info->interp = Tcl_CreateInterp();

  /* Some standard tcl built-ins */
  Tcl_CreateCommand(info->interp, "echo", (Tcl_CmdProc *)cmdEcho,
                    (ClientData) "echo",
                    (Tcl_CmdDeleteProc *) NULL);
  Tcl_CreateCommand(info->interp, "quit", (Tcl_CmdProc *)cmdQuit,
                    (ClientData) 0,
                    (Tcl_CmdDeleteProc *) NULL);

  info->buffer = Tcl_CreateCmdBuf();

  /* Source the tcl library */
  result = Tcl_Eval(info->interp, initCmd, 0, (char **) NULL);
  assert(result == TCL_OK);

  return info;
}

static void tclEventLoop(info)
tclInfo info;
{
  char line[1000], *cmd;
  int result, gotPartial;

  gotPartial = 0;
  while (1) {
    clearerr(stdin);
    if (!gotPartial) {
      fputs(prompt, stdout);
      fflush(stdout);
    }
    if (fgets(line, 1000, stdin) == NULL) {
      if (!gotPartial) {
	exit(0);
      }
      line[0] = 0;
    }
    cmd = Tcl_AssembleCmd(info->buffer, line);
    if (cmd == NULL) {
      gotPartial = 1;
      continue;
    }

    gotPartial = 0;
    result = Tcl_Eval(info->interp, cmd, 0, (char **)NULL);
    if (result == TCL_OK) {
      if (*(info->interp->result) != 0) {
	printf("%s\n", info->interp->result);
      }
      if (quitFlag) {
	Tcl_DeleteInterp(info->interp);
	Tcl_DeleteCmdBuf(info->buffer);
        return;
      }
    } else {
      if (result == TCL_ERROR) {
	printf("Error");
      } else {
	printf("Error %d", result);
      }
      if (*(info->interp->result) != 0) {
	printf(": %s\n", info->interp->result);
      } else {
	printf("\n");
      }
    }
  }
}

/* Echo command arguments */
static int cmdEcho(clientData, interp, argc, argv)
ClientData *clientData;
Tcl_Interp *interp;
int argc;
char *argv[];
{
  int i;

  for (i = 1; ; i++) {
    if (argv[i] == NULL) {
      if (i != argc) {
        echoError:
        sprintf(interp->result,
          "argument list wasn't properly NULL-terminated in \"%s\" command",
          argv[0]);
      }
      break;
    }
    if (i >= argc) {
      goto echoError;
    }
    fputs(argv[i], stdout);
    if (i < (argc-1)) {
      printf(" ");
    }
  }
  printf("\n");
  return TCL_OK;
}

/* A formal quit command */
static int cmdQuit(clientData, interp, argc, argv)
ClientData *clientData;
Tcl_Interp *interp;
int argc;
char *argv[];
{
  quitFlag = 1;
  return TCL_OK;
}

