#---------------------------------------------------------------------------
#
#	Create a menu button with an associated menu
#
#---------------------------------------------------------------------------

defwidget Menubutton Button

defmethod Menubutton new {name args} {

  args	text {textfont bold} bitmap items layout symbolic parentframe menu

  if { $bitmap == {} } then {
    menubutton ${name} -relief raised -text ${text} \
	-font [Font slot $textfont] -width 12 \
	-foreground [Color slot fg] \
	-background [Color slot bg,button] \
	-activebackground [Color slot bg,active] \
	-activeforeground [Color slot fg,active] \
	-disabledforeground [Color slot fg,disabled]
  } else {
    menubutton ${name} -relief flat -borderwidth 0 \
	-bitmap ${bitmap} \
	-foreground [Color slot fg] \
	-background [Color slot bg] \
	-activebackground [Color slot bg,active] \
	-activeforeground [Color slot fg,active] \
	-disabledforeground [Color slot fg,disabled]
  }
  if { $items != {} } {
    set menu [$self _menus $name $items]
  } elseif { $menu == {} } {
    set menu [Menu new *$name]
  }
  $name configure -menu $menu

  Menubutton instantiate $name $layout [list \
	[list symbolic $symbolic] \
	[list _parentframe $parentframe]]

  bind $name <Any-Enter> { %W _activate }
  bind $name <Any-Leave> { %W _deactivate }
  bind $name <B1-Enter> { %W _activate 1 }

  bind $name <1> { %W _down }
  bind $name <Any-ButtonRelease-1> { %W _up }

  return $menu
}

defmethod Menubutton _menus {name items} {

  set m [Menu new *$name]

  foreach item $items {
    case [lindex ${item} 0] in {
    { item } {
	$m addItem -text [lindex ${item} 1] -action [lrange ${item} 2 end]
      }
    { submenu } {
	$m addSubmenu -text [lindex ${item} 1] \
	  -submenu [$self _menus $name [lrange ${item} 2 end]]
      }
    { sep } {
	$m addSeparator
      }
    }
  }
  return $m
}

set system(_button) {}
set system(_inMenuButton) {}
set system(_grab) {}

defmethod Menubutton _activate {{post 0}} {
  global system

  set system(_inMenuButton) $self
  if { [lindex [$self! config -state] 4] != "disabled" } {
    $self! config -state active
    if { $post } {
      $self _post
    }
  }
}

defmethod Menubutton _deactivate {} {
  global system

  set system(_inMenuButton) {}
  if { [lindex [$self! config -state] 4] == "active" } {
    $self! config -state normal
  }
}

defmethod Menubutton _down {} {
  global system

  if { [lindex [$self! config -state] 4] == "disabled" } {
    return
  }
  if { $system(_button) == "" || $system(_button) != $system(_inMenuButton) } {
    $self _post
  } {
    $self _unpost
  }
}

defmethod Menubutton _up {} {
  global system

  if {[lindex [$self! config -state] 4] == "disabled"} {
    return
  }
  if { $system(_inMenuButton) == $self } {
    [lindex [$self! config -menu] 4] _enter none
  } else {
    $self _unpost
  }
}

defmethod Menubutton _post {} {
  global system

  # button disabled?
  if { [lindex [$self! config -state] 4] == "disabled" } {
    return
  }
  # button's menu is already posted?
  if { $self == $system(_button) } {
    return
  }

  # check for menu  
  set menu [lindex [$self! config -menu] 4]
  if { $menu == "" } {
    return
  }
  if { ![string match $self* $menu] } {
    error "can't post $menu:  it isn't a descendant of $self"
  }
  if { $system(_button) != "" } {
    $system(_button) _unpost
  }

  set system(_button) $self
  $menu _enter none
  $menu _post [winfo rootx $self] \
	[expr [winfo rooty $self]+[winfo height $self]] 0

  set grab [$self slot _parentframe]
  if { $grab == "" } {
    set grab $self
  }
  set system(_cursor) [lindex [$grab! config -cursor] 4]
  $grab! config -cursor arrow
  set system(_grab) $grab
  $grab grab
}

defmethod Menubutton _unpost {} {
  global system

  set w $system(_button)
  if {$w != ""} {
    $system(_grab)! config -cursor $system(_cursor)
    $system(_grab) ungrab
    set menu [lindex [$w! config -menu] 4]
    $menu _unpost
    set system(_button) {}
  }
}

bind Menubutton <2> {
  global tk_priv 

  if {($tk_priv(posted) == "")
	&& ([lindex [%W! config -state] 4] != "disabled")} {
    set tk_priv(dragging) %W
    [lindex [$tk_priv(dragging)! config -menu] 4] post %X %Y
  }
}

bind Menubutton <B2-Motion> {
  global tk_priv

  if {$tk_priv(dragging) != ""} {
    [lindex [$tk_priv(dragging)! config -menu] 4] post %X %Y
  }
}

bind Menubutton <ButtonRelease-2> {
  global tk_priv

  set tk_priv(dragging) ""
}

#---------------------------------------------------------------------------
#
#	A menu button with an associated variable. The label of the
#	menu button and the variable value will reflect the current
#	selection. The first element of 'items' is the initial value,
#	the cdr of 'items' is the list of alternatives.
#

defwidget Varmenubutton Menubutton

defmethod Varmenubutton new {name args} {

  args	text {textfont bold} items action layout variable symbolic

  if { $text == "" } {
    set text [lindex $items 0]
  }

  Menubutton new $name -text "$text" -menu $name.m

  Menu new $name.m

  foreach i $items {
    $name.m addItem -text $i -action [list $name event $i $action]
  }

  if { $variable != {} } {
    uplevel #0 [list trace variable [slot-variable $name $variable] w \
	[list $name _set]]
  }

  defsuper $name Varmenubutton
  $name slot _var $variable
  $name slot symbolic $symbolic

  $name layout $layout
  return $name.m
}

defmethod Varmenubutton _set {arr ind op} {
  global $arr

  $self event [set ${arr}(${ind})] {}
  return
}

defmethod Varmenubutton event {value action} {

  $self! configure -text $value
  set var [$self slot _var]
  if { $var != {} } {
    $self slot $var $value
  }
  if { $action != {} } {
    eval [concat $action [list $value]]
  }
}

