[comment {-*- tcl -*- doctools manpage}]
[manpage_begin irc n 0.2]
[moddesc   {Low Level Tcl IRC Interface}]
[titledesc {Create IRC connection and interface.}]
[require Tcl]
[require irc [opt 0.2]]
[description]

This package provides low-level commands to deal with the IRC protocol
(Internet Relay Chat) for immediate and interactive multi-cast
communication.

[para]

[list_begin definitions]

[call [cmd ::irc::connection] [arg hostname]]

The command creates a new object to deal with an IRC connection.
Creating this IRC object does not automatically create the network
connection.  It returns a new irc namespace command which can be used
to interact with the new IRC connection.


[call [cmd ::irc::config] [arg key] [arg value]]

Sets configuration [arg key] to [arg value].  Currently, the only
config key defined is the boolean flag [strong debug] which, when
turned on, makes [package irc] print more information about what is
going on.

[list_end]

[section {Per-connection Commands}]
[para]

In the following list of available connection methods [arg net]
represents a connection command as returned by
[cmd ::irc::connection].

[list_begin definitions]

[call [arg net] [method registerevent] [arg event] [arg script]]

Registers a callback handler for the specific event.  Events available
are those described in the IRC RFC: 1459.  In addition, there are
several other events defined. [strong defaultcommand] adds a command
that is called if no other callback is present.  [strong EOF] is
called if the connection signals an End of File condition.

[arg script] is executed in the connection namespace, which can take
advantage of several commands (see [sectref {Callback Commands}]
below) to aid in the parsing of data.


[call [arg net] [method connect]]

This causes the socket to be established.  [cmd ::irc::connection]
created the namespace and the commands to be used, but did not
actually open the socket. This is done here.


[call [arg net] [method user] [arg username] [arg localhostname] [arg userinfo]]

Sends USER command to server.  [arg username] is the username you want
to appear.  [arg localhostname] is the name of your server, and

[arg userinfo] is a short description of who you are.


[call [arg net] [method nick] [arg nick]]

NICK command.  [arg nick] is the nickname you wish to use for the
particular connection.


[call [arg net] [method ping]]

PING the IRC server.


[call [arg net] [method join] [arg channel]]

[arg channel] is the IRC channel to join.  IRC channels typically
begin with a hashmark ("#").

[call [arg net] [method part] [arg channel]]

Makes the client leave [arg channel].

[call [arg net] [method privmsg] [arg target] [arg message]]

Sends [arg message] to [arg target], which can be either a channel, or
another user, in which case their nick is used.

[call [arg net] [method send] [arg text]]

Sends [arg text] to the IRC server.

[list_end]

[section {Callback Commands}]
[para]

These commands can be used within callbacks

[list_begin definitions]

[call [cmd who] [opt [strong address]]]

Returns the nick of the user who performed a command.  The optional
[strong address] keyword causes the command to return the user in the
format "username@address".

[call [cmd action]]

Returns the action perfomed, such as KICK, PRIVMSG, MODE, etc...
Normally not useful, as callbacks are bound to a particular event.

[call [cmd target] [opt [arg index]]]

Returns the target of a particular command, such as the channel or
user to whom a PRIVMSG is sent.  In the case of multiple targets, the
optional [arg index] argument may be used to specify which one to
return.  The default is 0.

[call [cmd msg]]

Returns the message portion of the command (the part after the :).

[list_end]

[see_also {rfc 1459}]
[keywords irc chat]
[manpage_end]
