$PACKAGE = "MOTIF12";

#include <X11/Shell.h>
#include <Xm/RepType.h>
#include <Xm/Text.h>
#include <Xm/ScrolledW.h>

~handles 
	MOTIF12


# conv "VerticalDimension"  XtRString       None CvtDimensionToString    None

~require
motif12.inc
	conv XtRString "DropTransfers" None CvtStringToDropTransfers None
	conv XtRString "CallbackProc"  None CvtStringToCallbackProc  None
	conv XtRString "SelectionCallbackProc" None CvtStringToSelectionCallbackProc None
	conv XtRString "ConvertSelectionIncrProc" None CvtStringToConvertSelectionIncrProc None
	conv XtRString "DragOperations" None CvtStringToDragOperations None
	conv XtRString "DropSiteOperations" None CvtStringToDragOperations None
	conv XtRString "TransferStatus" None CvtStringToTransferStatus None
	init XmRepTypeInstallTearOffModelConverter();
	quark dragProc
	quark dropProc
	quark transferProc
	quark convertProc
	quark clientData



#include <Xm/DragDrop.h>

~objectClass 
XmDropSiteManager
	include <Xm/DragDrop.h>
  	addres animationMask Pixmap
 	addRes animationPixmap Pixmap
	addRes animationPixmapDepth Int
	addRes animationStyle AnimationStyle
	addRes dragProc CallbackProc
	addRes dropProc CallbackProc
	addRes dropRectangles RectangleList
	addRes dropSiteActivity DropSiteActivity
	addRes dropSiteOperations DropSiteOperations
	addRes dropSiteType DropSiteType
	addRes importTargets AtomList
	addRes numDropRectangles Cardinal
	addRes numImportTargets Cardinal
	dragProc c WidgetID: \
		(WidgetID)((XmDragProcCallbackStruct *)callData)->dragContext 	# dragContext
	dragProc x Position: \
		((XmDragProcCallbackStruct *)callData)->x 		# x position
	dragProc y Position: \
		((XmDragProcCallbackStruct *)callData)->y	 	# y position
	dragProc o int: \
		((XmDragProcCallbackStruct *)callData)->operation 	# operation
	dragProc O int: \
		((XmDragProcCallbackStruct *)callData)->operations 	# operations


~widgetClass
XmDragContext
	dropProc c WidgetID: \
		(WidgetID)((XmDropProcCallbackStruct *)callData)->dragContext 	# dragContext
	dropProc x Position: \
		((XmDropProcCallbackStruct *)callData)->x 		# x position
	dropProc y Position: \
		((XmDropProcCallbackStruct *)callData)->y	 	# y position
	dropProc o int: \
		((XmDropProcCallbackStruct *)callData)->operation 	# operation
	dropProc O int: \
		((XmDropProcCallbackStruct *)callData)->operations 	# operations
	convertProc t String: \
		(String)callData					# target widget
	addRes convertProc ConvertSelectionIncrProc
	addRes dragOperations DragOperations

~objectClass
XmDropTransfer
	addRes transferProc SelectionCallbackProc
	transferProc d WidgetID: \
		(WidgetID)((dropTransferCallbackStruct *)callData)->dest	# destination widget
	transferProc v String: \
		(String)((dropTransferCallbackStruct *)callData)->value		# value
	
	
#define convertSpecialResources(command,w,class,argc,argv) {\
    ArgList           args; \
    int               numArgs; \
    XtInitializeWidgetClass(class); \
    if (wafeConvert(ParentWidget(w), class, \
		argv, &argc, &args, &numArgs, w)) { \
	command(w, args, numArgs); \
	wafeCurrentAttribList = NULL; \
	XtFree((String)args); \
	} \
    } 


void
convertSpecialResources vulgo XmDropSiteRegister 
	const: XmDropSiteRegister
	in: Widget		# Widget to be registered
	const: xmDropSiteManagerObjectClass
	in: [args avp]          # drop site resources

void
convertSpecialResources vulgo XmDropSiteUpdate
	const: XmDropSiteUpdate
	in: Widget		# Drop site to be modified
	const: xmDropSiteManagerObjectClass
	in: [args avp]          # drop site resources

void
XmDropSiteUnregister
	in: Widget		# Widget to be unregistered

void
XmDropSiteStartUpdate
	in: Widget		# Widget to identify shell with multiple drop sites

void
XmDropSiteEndUpdate
	in: Widget		# Widget to identify shell with multiple drop sites


#define createDnDWidget4(c,w,x,y) c(w,args,numArgs)
#define createDnDWidget5(c,w,e,x,y) c(w,e,args,numArgs)

WidgetID (WidgetID)
createDnDWidget4 vulgo XmDropTransferStart
        pre: { ArgList args; int numArgs; \
	       currentDragContext = localVar1; \
               wafeConvert(localVar1,xmDropTransferObjectClass,argvArg,&argc,&args,&numArgs, NULL);
        const: XmDropTransferStart
	in: Widget		# Drag Context
	in: [args avp]          # Drop Transfer Resources
        post: wafeMMsetAttribList((Widget)returnVar); \
	      wafeCurrentAttribList = NULL; \
	      XtAddCallback((Widget)returnVar,XtNdestroyCallback,CBfreeAttribs,NULL); \
	      XtFree((char*)args); }

WidgetID (WidgetID)
createDnDWidget5 vulgo XmDragStart
        pre: { ArgList args; int numArgs; \
               wafeConvert(localVar1,xmDragContextClass,argvArg,&argc,&args,&numArgs, NULL);
        const: XmDragStart
	in: Widget		# Widget (source for drag and drop)
	const: wafeCurrentEvent
	in: [args avp]          # Drag Context Resources
        post: wafeMMsetAttribList((Widget)returnVar); \
	      wafeCurrentAttribList = NULL; \
	      XtAddCallback((Widget)returnVar,XtNdestroyCallback,CBfreeAttribs,NULL); \
	      XtVaSetValues((Widget)returnVar,XmNconvertProc,convertSelectionIncrProc); \
	      XtFree((char*)args); }


# ... seems broken, but we don't need it ...
# void
# XmDropTransferAdd
#	in: XmDropTransferObject
#	in: XmDropTransferEntryRec*
#	in: int

void
xmChangeColor vulgo XmChangeColor
	in: Widget		# widget
	in: String		# color string for background

void
XmTextDisableRedisplay
	in: XmTextWidget 	# Text widget

void
XmTextEnableRedisplay
	in: XmTextWidget 	# Text widget

void
XmScrollVisible
	in: XmScrolledWindowWidget	# scrolled window
	in: Widget			# widget to be made visible
	in: Dimension			# left-right margin for positioning
	in: Dimension			# top-botton margin for positioning
