proc mkAliasIndex {dir args} {
    global errorCode errorInfo
    set oldDir [pwd]
    cd $dir
    set dir [pwd]
    append index "# Tcl autoload index file, version 2.0\n"
    append index "# This file is generated by the \"mkAliasIndex\" command\n"
    append index "# and sourced to set up indexing information for one or\n"
    append index "# more commands.  ... slight modification of auto_mkindex\n"
    append index "# from tcl 7.2\n\n"
    foreach file [eval glob $args] {
	set f ""
	set error [catch {
	    set f [open $file]
	    while {[gets $f line] >= 0} {
		if [regexp {^alias +([^ ]*) +([^ ]*) *$} $line match procName defName] {
		    append index "set [list auto_index($procName)]"
		    append index " \"puts {** alias $procName $defName};"
                    append index "alias $procName $defName\"\n"
		}
	    }
	    close $f
	} msg]
	if $error {
	    set code $errorCode
	    set info $errorInfo
	    catch {close $f}
	    cd $oldDir
	    error $msg $info $code
	}
    }
    set f [open tclIndex w]
    puts $f $index nonewline
    close $f
    cd $oldDir
}
