/*
 * This software is Copyright (C) 1988 by Steven Dorner and the
 * University of Illinois Board of Trustees.  No warranties of any
 * kind are expressed or implied.  No support will be provided.
 * This software may not be redistributed for commercial purposes.
 * You may direct questions to nameserv@uiuc.edu
 */

/*
 * replaces ssn fields with id fields, using id database
 */
#include "conf.h"
#include <stdio.h>
#include <ndbm.h>
#include <sys/types.h>
#ifdef SYSV
# include <sys/fcntl.h>
#else /* !SYSV */
# include <sys/file.h>
#endif /* SYSV */

#ifdef __STDC__
# include <stdlib.h>
# include <string.h>
# ifndef index
#  define index strchr
#  define rindex strrchr
# endif /* !index */
#else /* !__STDC__ */
char	*index();
#endif /* __STDC__ */

#define BUF_SIZE    1024

main(argc, argv)
	int argc;
	char **argv;
{
	char	buffer[BUF_SIZE];
	int	err;
	DBM	*db;
	datum	first, second;


	if (argc != 2)
	{
		fprintf(stderr, "Usage: ssnload ssndb\n");
		exit(1);
	}
	if ((db = dbm_open(argv[1], O_RDWR | O_CREAT, 0660)) == NULL)
	{
		perror(argv[1]);
		exit(3);
	}
	first.dptr = buffer;
	while (gets(buffer) != NULL)
	{
		second.dptr = index(buffer, ':');	/* find end of ssn */
		if (!second.dptr)
			continue;	/* skip */
		first.dsize = second.dptr - first.dptr;
		*second.dptr++ = '\0';
		first.dsize = second.dptr - first.dptr;
		second.dsize = strlen(second.dptr) + 1;
		if (err = dbm_store(db, first, second, DBM_INSERT))
			fprintf(stderr, "Dbm err %d on <%s:%s>\n", first.dptr, second.dptr);
#ifdef DEBUG
		else
			printf("%d %s:%d %s\n", first.dsize, first.dptr, second.dsize, second.dptr);
#endif
	}

	dbm_close(db);
	exit(0);
}
