;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Copyright (c) 1993 by William M. Perry (wmperry@indiana.edu)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Experimental HTML+ parsing functions
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(require 'w3)

(defun w3-determine-table-width ()
  "Figure out how wide (number of columns) a data table is
Expects the region to be narrowed between the <TBL> and </TBL> tags."
  (goto-char (point-min))
  (re-search-forward "^.*</TBL>" nil t)
  (let ((nd (match-beginning 0))  ;; where the table ends
	(ln 0)                    ;; highest width found so far
	(cur-ln 0))               ;; current lines width
    (goto-char (point-min))
    (forward-line 1)
    (while (/= (point) nd)
      (save-restriction
	(let ((st (progn (beginning-of-line) (point)))
	      (nd (if (re-search-forward "<TR>" nil t) (point)
		    (progn (end-of-line) (point)))))
					;	  (if (not (equal (buffer-substring (point) (1+ (point))) "\n"))
					;	      (insert "\n"))
	  (narrow-to-region st nd)
	  (goto-char (point-min))
	  (setq cur-ln (w3-count-occurences "<TD[^>]*>"))
	  (if (> cur-ln ln) (setq ln cur-ln))
	  (goto-char (point-min))))
      (forward-line 1)
      (beginning-of-line))
    ln))

(defun w3-handle-tables ()
  "Build tables from HTML+ source"
  (w3-replace-regexp "\\\n*<TR>\\\n*" "<TR>\n")
  (goto-char (point-min))
  (while (re-search-forward "<TBL[ \\\t]+\\([^>]*\\)>" nil t)
    (let ((st (match-beginning 0))
	  (nd (progn
		(re-search-forward "</TBL>" nil t)
		(point))))
      (narrow-to-region st nd)
      (w3-table-helper)
      (widen))))

(defun w3-table-build-it ()
  "Build the headers for the current table"
  (goto-char (point-min))
  (while (re-search-forward "<T[DH]\\([^>]*\\)>" nil t)
    (let ((mod (buffer-substring (match-beginning 1) (match-end 1)))
	  (ln 1)
	  (tmp 0)
	  (str ""))
      (replace-match "|")
      (if (string-match "S[ \\\t]*=[ \\\t]*\"\\([0-9]+\\)\"" mod)
	  (setq ln (string-to-int (substring mod (match-beginning 1)
					     (match-end 1)))))
      (setq tmp (point))
      (if (re-search-forward "<T[HDR][^>]*>" nil t)
	  (progn
	    (setq str (buffer-substring tmp (match-beginning 0)))
	    (goto-char tmp)
	    (if (< (length str) (+ (* ln width) (if (> ln 1) (1- ln) 0)))
		(insert (make-string
			 (- (+ (* ln width) (if (> ln 1) (1- ln) 0))
			    (length str)) 32))))))))

(defun w3-table-helper ()
  "Actually build the table"
  (goto-char (point-min))
  (let* ((ttl (if (re-search-forward "<TT[^>]*>" nil t)
		  (prog1
		      (buffer-substring (point) (progn (end-of-line)
						       (point)))
		    (delete-region (match-beginning 0) (point)))
		""))
	 (numrows (w3-determine-table-width))
	 (width (- (/ (- (screen-width) 8) numrows) 1)))
    (goto-char (point-min))
    (re-search-forward "</TBL>" nil t)
    (w3-table-build-it)
    (w3-replace-regexp "<TR>" "|")))

(provide 'w3-html+)
