/************************************************************************
*                                                                       *
*       Adding an X-Window interface to SMART --- smart_xsec.c          *
*                                                                       *
*                                                                       *
*    by: Victuria Chiu, senior in CS from Univ. of Cal. at Berkeley,    *
*                e-mail: victoria@csr.lbl.gov                           *
*                                                                       *
*        Tong Li, graduate student in CS from Oregon State University,  *
*                e-mail: lit@mist.cs.orst.edu                           *
*                                                                       *
*    at Lawrence berkeley Laboratory, Summer 1991                       *
*                                                                       *
************************************************************************/
/****************************************************************************/
/* smart_xsec.c - Notify and event callback function.                       */
/* for X_window interface to SMART retrieval system.                        */
/* This original template file was generated by `gxv' from `smart_xsec.G'.  */
/****************************************************************************/

#include <stdio.h>
#include <sys/param.h>
#include <sys/types.h>
#include <xview/xview.h>
#include <xview/panel.h>
#include <xview/textsw.h>
#include <xview/xv_xrect.h>
#include <gdd.h>
#include "smart_xsec_ui.h"
#include "smart_xmain_ui.h"
#include "xfunctions.h"
#include "param.h"

INTER_STATE is_x;
COMMAND *parse_command_line();
void do_next_document();
void delete_text();

/*
 * Event callback function for `docnext_button'.
 */
void
x_docnext_document(item, event)
	Panel_item	item;
	Event		*event;
{
	smart_xsec_document_popup_objects	*ip = (smart_xsec_document_popup_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

	do_next_document(event);
/*	fprintf(stderr, "smart_xsec: x_docnext_document: event %d\n", event_id(event)); */
}

/*
 * Event callback function for `docdone_button'.
 */
void
close_doc_popup(item, event)
	Panel_item	item;
	Event		*event;
{
	smart_xsec_document_popup_objects	*ip = (smart_xsec_document_popup_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

	if (event_left_is_down(event)) {
	  delete_text(smart_xsec_document_popup->doc_textpane);
	  xv_set(smart_xsec_document_popup->document_popup, PANEL_INACTIVE, 
		 TRUE, NULL);	
	}
	
/*	fprintf(stderr, "smart_xsec: close_doc_popup: event %d\n", event_id(event));*/
	panel_default_handle_event(item, event);
}

/*
 * Event callback function for `helpdone_button'.
 */
void
close_help_popup(item, event)
	Panel_item	item;
	Event		*event;
{
	smart_xsec_help_popup_objects	*ip = (smart_xsec_help_popup_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

	xv_set(smart_xsec_help_popup->help_popup, XV_SHOW , FALSE, NULL);
	
/*	fprintf(stderr, "smart_xsec: close_help_popup: event %d\n", event_id(event)); */
	panel_default_handle_event(item, event);
}


/*
 * Event callback function for `savelast_filetext'.
 */
void
get_text(item, event)
	Panel_item	item;
	Event		*event;
{

       smart_xsec_savelast_popup_objects	*ip = (smart_xsec_savelast_popup_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

	panel_default_handle_event(item, event);
}

/*
 * Event callback function for `savelast_ok_button'.
 */
void
x_savelast(item, event)
	Panel_item	item;
	Event		*event;
{

       char             in_buffer[PATH_LEN];
       COMMAND          *command;
       int              status;

       smart_xsec_savelast_popup_objects	*ip = (smart_xsec_savelast_popup_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

       if (!(event_left_is_down(event)))  {
	   bzero (in_buffer, PATH_LEN);
	   is_x.err_buf.end = 0;

	   strcpy(in_buffer, "save ");
	 
	   strcat(in_buffer, (char *) xv_get(smart_xsec_savelast_popup->savelast_filetext, PANEL_VALUE));

	   if (NULL != (command = parse_command_line(in_buffer,&is_x))) { 
	     if (-1 == (status = command->proc.proc (&is_x, (char *) NULL)) 
		 || command->end_inter) 
	       printf("saving file failed\n");
	   } 
	   is_x.err_buf.buf[is_x.err_buf.end] = '\0';
	   xv_set(smart_xmain_basewindow->general_msg, PANEL_LABEL_STRING, 
		  is_x.err_buf.buf, NULL);

	 }

/*	fprintf(stderr, "smart_xsec: x_savelast: event %d\n", event_id(event)); */
	panel_default_handle_event(item, event);
     }


/*
 * Event callback function for `advdone_button'.
 */
void
close_adv_popup(item, event)
	Panel_item	item;
	Event		*event;
{
	smart_xsec_advance_popup_objects	*ip = (smart_xsec_advance_popup_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

	if (event_left_is_down(event)) {
	  delete_text(smart_xsec_advance_popup->doc_textpane1);
	  xv_set(smart_xsec_advance_popup->advance_popup, PANEL_INACTIVE, 
		 TRUE, NULL);	
	}
/* 	fprintf(stderr, "smart_xsec: close_adv_popup: event %d\n", event_id(event)); */
	panel_default_handle_event(item, event);
}


