/*
 * log.c: Dealing with the logs and errors
 * 
 * from httpd_log.c, by Rob McCool
 * 
 */

/*
 * $Log: log.c,v $
 * Revision 0.14  1994/05/17  13:41:20  reinpost
 * nothing of importance
 *
 * Revision 0.14  1994/05/17  13:41:20  reinpost
 * nothing of importance
 *
 * Revision 0.12  1994/04/01  15:08:17  reinpost
 * *** empty log message ***
 *
 * Revision 0.12  1994/04/01  15:08:17  reinpost
 * *** empty log message ***
 *
 * Revision 0.10  1994/03/11  13:41:24  reinpost
 * new variables to dump in dump_g_vars
 *
 * Revision 0.10  1994/03/11  13:41:24  reinpost
 * new variables to dump in dump_g_vars
 *
 * Revision 0.9  1994/03/02  21:24:45  reinpost
 * some new variablkes are dumped in dump_vars
 *
 * Revision 0.8  1994/02/25  20:27:31  reinpost
 * dump_global_vars extended
 *
 * Revision 0.7  1994/02/18  13:18:58  reinpost
 * some compilers don't accept multi-line strings
 *
 * Revision 0.6  1994/02/17  21:25:47  reinpost
 * *** empty log message ***
 *
 * Revision 0.5  1994/02/17  10:23:54  reinpost
 * a handy routine - used to be inline in cache.c
 * not used presently
 *
 * Revision 0.4  1994/02/10  12:51:18  reinpost
 * log_if_debug: print log message only if the DEBUG flag is set
 *
 * Revision 0.3  1994/02/01  19:51:18  reinpost
 * two name changes, and the logfile names are now configurable at run time
 *
 * Revision 0.2  1994/01/25  16:07:14  reinpost
 * keep it simple
 * mainly used for debugging messages
 * no -DEBUG flag yet which would be a good idea
 */

static char rcsid[] =
  "$Id: log.c,v 0.14 1994/05/17 13:41:20 reinpost Exp $";

#include <stdio.h>
#include <string.h>

#include "system.h"

#include "constants.h"
#include "config.h"
#include "error.h"
#include "gettime.h"

static FILE *error_log;
static FILE *xfer_log;

static int xfer_is_open  = 0;
static int error_is_open = 0;


void init_logging()
{
  /* hope and prey that uninitialized static memory is zeroed */
  if (!(xfer_log = fopen(transfer_logfile,"a")))
  {
    char errmsg[1024];
    sprintf(errmsg,
      "The transfer log file, %s, could not be opened.", transfer_logfile);
    die(DIE_LOGFILE,errmsg);
  }
  if (!(error_log = fopen(error_logfile,"a")))
  {
    char errmsg[1024];
    sprintf(errmsg,
      "The error log file, %s, could not be opened.", error_logfile);
    die(DIE_LOGFILE,errmsg);
  }
  xfer_is_open = error_is_open = 1;
}

void quit_logging()
{
  if (xfer_is_open)
    fclose(xfer_log);
  if (error_is_open)
    fclose(error_log);
  xfer_is_open = error_is_open = 0;
}

void log_msg(char *msg1, char *msg2)
{
  if (xfer_is_open)
  {
    fprintf(xfer_log, "%s [%s] %s %s\n",
      env_remote_host, get_time(), msg1, msg2);
    fflush(xfer_log);
  }
}

void log_error(char *err)
{
  if (error_is_open)
  {
    fprintf(error_log, "[%s] %s\n",get_gmt(),err);
    fflush(error_log);
  }
}

#if DEBUG

void _log_if_debug(char *msg1, char *msg2)
{
  char msg[HUGE_STRING_LEN+1];
  strcpy(msg,"debug: ");
  strcat(msg,msg1);
  strcat(msg," ");
  strcat(msg,msg2);
  log_error(msg);
}

void _dump_global_vars()
{
  char msg[10*HUGE_STRING_LEN+1];  /* let's hope this is enough */
  char *s = msg;
  sprintf(msg,"debug: configuration values:\n");
  s += strlen(s); sprintf(s,"  cache_conf: %s\n",CACHE_CONF);
  s += strlen(s); sprintf(s,"  cache_version: %s\n",cache_version);
  s += strlen(s); sprintf(s,"  cache_root: %s\n",cache_root);
  s += strlen(s); sprintf(s,"  cache_prefix: %s\n",cache_prefix);
  s += strlen(s); sprintf(s,"  db_dir: %s\n",db_dir);
  s += strlen(s); sprintf(s,"  transfer_logfile: %s\n",transfer_logfile);
  s += strlen(s); sprintf(s,"  error_logfile: %s\n",error_logfile);
  s += strlen(s); sprintf(s,"  mime_types_confname: %s\n",mime_types_confname);
  s += strlen(s); sprintf(s,"  expire_confname: %s\n",expire_confname);
  s += strlen(s); sprintf(s,"  default_mime_type: %s\n",default_mime_type);
  s += strlen(s); sprintf(s,"  server_maintainer: %s\n",server_maintainer);
  s += strlen(s); sprintf(s,"  cache_queries: %d\n",cache_queries);
  s += strlen(s); sprintf(s,"  translate_escaped: %d\n",translate_escaped);
  s += strlen(s); sprintf(s,"  timeout: %d\n",timeout);
  s += strlen(s); sprintf(s,"  m_expires: %d\n",m_expires);
  s += strlen(s); sprintf(s,"  a_expires: %d\n",a_expires);
  s += strlen(s); sprintf(s,"  cache_threshold: %d\n",cache_threshold);
  s += strlen(s); sprintf(s,"  env_server_software: %s\n",env_server_software);
  s += strlen(s); sprintf(s,"  env_server_name: %s\n",env_server_name);
  s += strlen(s); sprintf(s,"  env_gateway_interface: %s\n",env_gateway_interface);
  s += strlen(s); sprintf(s,"  env_server_protocol: %s\n",env_server_protocol);
  s += strlen(s); sprintf(s,"  env_server_port: %s\n",env_server_port);
  s += strlen(s); sprintf(s,"  env_request_method: %s\n",env_request_method);
  s += strlen(s); sprintf(s,"  env_http_accept: %s\n",env_http_accept);
  s += strlen(s); sprintf(s,"  env_path_info: %s\n",env_path_info);
  s += strlen(s); sprintf(s,"  env_path_translated: %s\n",env_path_translated);
  s += strlen(s); sprintf(s,"  env_script_name: %s\n",env_script_name);
  s += strlen(s); sprintf(s,"  env_query_string: %s\n",env_query_string);
  s += strlen(s); sprintf(s,"  env_remote_host: %s\n",env_remote_host);
  s += strlen(s); sprintf(s,"  env_remote_addr: %s\n",env_remote_addr);
  s += strlen(s); sprintf(s,"  env_remote_user: %s\n",env_remote_user);
  s += strlen(s); sprintf(s,"  env_auth_type: %s\n",env_auth_type);
  s += strlen(s); sprintf(s,"  env_content_type: %s\n",env_content_type);
  s += strlen(s); sprintf(s,"  env_content_length: %s\n",env_content_length);
  s += strlen(s); sprintf(s,"  url: %s\n",env_url);
  s += strlen(s); sprintf(s,"  url_with_query: %s\n",env_url_with_query);
  s += strlen(s); sprintf(s,"  url_anchor: %s\n",env_url_anchor);
  s += strlen(s); sprintf(s,"  assbackwards: %d\n",env_assbackwards);
  s += strlen(s); sprintf(s,"  refresh: %d\n",env_refresh);
  s += strlen(s); sprintf(s,"  its_proxy: %d\n",env_its_proxy);
  log_error(msg);
}

#endif /* DEBUG */
