/*
 * mime.c: Sends/gets MIME headers for requests
 * does some HTTP specific things, too
 * 
 * from http_mime.c by Rob McCool
 * several adjustments and new routines by Reinier Post
 */

static char rcsid[] =
  "$Id: mime.c,v 0.15 1994/05/18 07:57:20 reinpost Exp reinpost $";

/*
 * $Log: mime.c,v $
 * Revision 0.15  1994/05/18  07:57:20  reinpost
 * bug in POST script passing removed
 *
 * Revision 0.14  1994/05/17  13:41:40  reinpost
 * some code cleanup; extensions to sending of HTTP requests in order to
 * handle POST requests
 *
 * Revision 0.13  1994/05/03  19:32:05  reinpost
 * some small changes and a new routine that isn't used yet
 *
 * Revision 0.12  1994/04/01  15:08:23  reinpost
 * some obvious changes
 *
 * Revision 0.11  1994/03/25  20:45:30  reinpost
 * cleaned up the code somewhat ... also added some real improvements
 * to MIME header handling necessary to make redirections work etc.
 * it still is not according to the best possible world
 * some dates are incorrectly set etc.
 *
 *
 * Revision 0.5  1994/02/17  10:24:40  reinpost
 * brand new version from NCSA httpd 1.1, merged in manually with old code
 *
 * Revision 0.4  1994/02/10  12:52:02  reinpost
 * mime.c now uses environment variable values passed from the server
 *
 * Revision 0.3  1994/02/01  19:54:23  reinpost
 * this is still a heap of trash, basically
 * one particularly nasty #define was changed to a runtime
 * configurable parameter
 * and a premature exit was removed
 */

/* some relevant stuff from httpd.h */

#if defined(SVR4) || defined(SOLARIS2)
#include <string.h>
#else
#include <strings.h>	/* not string.h, we need strcasecmp */
#endif
#include <stdio.h>
#include <time.h>

#include "system.h"

#include "constants.h"
#include "util.h"
#include "gettime.h"
#include "config.h"

#include "log.h"

#include "error.h"

#include "mime.h"

/* the rest is basically from ncsa-httpd_1.1/src/http_mime.c */

struct mime_ext {
    char *ext;
    char *ct;
    struct mime_ext *next;
};

#define hash(i) (isalpha(i) ? (tolower(i)) - 'a' : 26)

/* Hash table */
struct mime_ext *types[27];
struct mime_ext *forced_types;
struct mime_ext *encoding_types;

static int content_length = 0;  /* causes header to be omitted */
static char content_type[MAX_STRING_LEN];

static char location[HUGE_STRING_LEN+1];
static char last_modified[MAX_STRING_LEN];
static char content_encoding[MAX_STRING_LEN];
static char *http_accept;  /* still a hack. RP */

char auth_line[MAX_STRING_LEN];

/*
 * extra variables, introduced by RP - dynamically allocated strings
 * caution: they can be NULL
 *
 * see get_http_header
 */
static char *http_version = (char *)NULL;
static char *http_reason = (char *)NULL;
static int http_status_code = 0;

/* more extra variables - non-HTTP headers added by cache in client response */
/* may be searched for in server response, too */
static char cache_last_refreshed[MAX_STRING_LEN];
static char cache_via[HUGE_STRING_LEN];
static char cache_last_retrieved[MAX_STRING_LEN];
/* not used, yet */

static void hash_insert(struct mime_ext *me) {
    register int i = hash(me->ext[0]);
    register struct mime_ext *p, *q;

    if(!(q=types[i])) {
        types[i]=me;
        return;
    }
    if((!(p=q->next)) && (strcmp(q->ext,me->ext) >= 0)) {
        types[i]=me;
        me->next=q;
        return;
    }
    while(p) {
        if(strcmp(p->ext,me->ext) >= 0) break;
        q=p;
        p=p->next;
    }
    me->next=p;
    q->next=me;
}

void kill_mime() {
    register struct mime_ext *p,*q;
    register int x;

    for(x=0;x<27;x++) {
        p=types[x];
        while(p) {
            free(p->ext);
            free(p->ct);
            q=p;
            p=p->next;
            free(q);
        }
    }
    p=forced_types;
    while(p) {
        free(p->ext);
        free(p->ct);
        q=p;
        p=p->next;
        free(q);
    }
    p=encoding_types;
    while(p) {
        free(p->ext);
        free(p->ct);
        q=p;
        p=p->next;
        free(q);
    }
}

int init_mime() {
    char l[MAX_STRING_LEN],w[MAX_STRING_LEN],*ct;
    FILE *f;
    register struct mime_ext *me;
    register int x;

    if(!(f = fopen(mime_types_confname,"r")))
	return(-1);

    for(x=0;x<27;x++) 
        types[x] = NULL;
    forced_types = NULL;
    encoding_types = NULL;

    while(!(cfg_getline(l,MAX_STRING_LEN,f))) {
        if(l[0] == '#') continue;
        cfg_getword(w,l);
        if(!(ct = (char *)malloc(sizeof(char) * (strlen(w) + 1))))
            return(-2);
        strcpy(ct,w);

        while(l[0]) {
            cfg_getword(w,l);
            if(!(me = (struct mime_ext *)malloc(sizeof(struct mime_ext))))
                return(-2);
            if(!(me->ext = (char *)malloc(sizeof(char) * (strlen(w)+1))))
                return(-2);
            for(x=0;w[x];x++)
                me->ext[x] = (islower(w[x]) ? w[x] : tolower(w[x]));
            me->ext[x] = '\0';
            if(!(me->ct=strdup(ct)))
                return(-2);
            me->next=NULL;
            hash_insert(me);
        }
        free(ct);
    }

    fclose(f);
    return(0);
}

void dump_types() {
    struct mime_ext *p;
    register int x;

    for(x=0;x<27;x++) {
        p=types[x];
        while(p) {
            printf("ext %s: %s\n",p->ext,p->ct);
            p=p->next;
        }
    }
    p=forced_types;
    while(p) {
        printf("file %s: %s\n",p->ext,p->ct);
        p=p->next;
    }
}

int is_content_type(char *type) {
    return(!strcmp(content_type,type));
}

void set_content_type(char *file) {
    int i,l,l2;
    struct mime_ext *p;
    char fn[MAX_STRING_LEN];

    strcpy(fn,file);
    if((i=rind(fn,'.')) >= 0) {
        ++i;
        l=strlen(fn);
        p = encoding_types;

        while(p) {
            if(!strcmp(p->ext,&fn[i])) {
                fn[i-1] = '\0';
                if(content_encoding[0])
                    sprintf(content_encoding,"%s, %s",content_encoding,p->ct);
                else
                    strcpy(content_encoding,p->ct);
                if((i=rind(fn,'.')) < 0)
                    break;
                ++i;
                l=strlen(fn);
                p=encoding_types;
            }
            else
                p=p->next;
        }
    }
    p=forced_types;
    l=strlen(fn);

    while(p) {
        l2=l-strlen(p->ext);
        if((l2 >= 0) && (!strcasecmp(p->ext,&fn[l2]))) {
            strcpy(content_type,p->ct);
            return;
        }
        p=p->next;
    }

    if((i = rind(fn,'.')) < 0) {
        strcpy(content_type,default_mime_type);
        return;
    }
    ++i;
    p=types[hash(fn[i])];

    while(p) {
        if(!strcasecmp(p->ext,&fn[i])) {
            strcpy(content_type,p->ct);
            return;
        }
        p=p->next;
    }
    strcpy(content_type,default_mime_type);
}

int url_says_html(char *url)
/* by RP */
{
  int its_html;
  char *old_type = strdup(content_type);
  set_content_type(url);  /* supposed to be a filename, but what the hack */
  its_html = is_content_type("text/html");
  strcpy(content_type,old_type);
  free(old_type);
  return(its_html);
}

/* copied not checked.  Fantasy return codes. RP */
int scan_script_header(FILE *f, FILE *fd) {
    char l[MAX_STRING_LEN];  /* can't be right for accept header.  RP */
    char w[MAX_STRING_LEN];

    while(1) {
        if(getline(l,MAX_STRING_LEN,fileno(f),timeout)) {
            log_error("httpd: script failed to produce output");
            return(-1);
	}

        if(l[0] == '\0') return is_url(location);
        getword(w,l,':');
        if(!strcasecmp(w,"Content-type"))
            sscanf(l,"%s",content_type);
        else if(!strcasecmp(w,"Location"))
            sscanf(l,"%s",location);
    }
    return(0);
}

/* maybe add print_errors here or a return code !!! RP */
void add_type(char *fn, char *t, FILE *out) {
    struct mime_ext *n;

    if(!(n=(struct mime_ext *)malloc(sizeof(struct mime_ext))))
        log_error("add_type is out of memory");

    if(!(n->ext = strdup(fn)))
        log_error("add_type is out of memory");
    if(!(n->ct = strdup(t)))
        log_error("add_type is out of memory");
    n->next = forced_types;
    forced_types = n;
}

/* idem, RP */
void add_encoding(char *fn, char *t,FILE *out) {
    struct mime_ext *n;

    if(!(n=(struct mime_ext *)malloc(sizeof(struct mime_ext))))
        log_error("add_encoding is out of memory");

    if(!(n->ext = strdup(fn)))
        log_error("add_encoding is out of memory");
    if(!(n->ct = strdup(t)))
        log_error("add_encoding is out of memory");
    n->next = encoding_types;
    encoding_types = n;
}

void set_content_length(int l) {
    content_length = l;
}

void set_location(char *l)
{
  if (strlen(l) > HUGE_STRING_LEN)
  {
    log_error("URL for location header too long, not set");
  }
  else
  {
    strcpy(location,l);
  }
}

void set_http_status(int status)
{
  http_status_code = status;
}

void set_http_reason(char *reason)
{
  if (http_reason) free(http_reason);
  http_reason = strdup(reason);
}

void get_location(char *l)
{
  strcpy(l,location);
}

void set_last_modified(time_t t) {
    strcpy(last_modified,gm_timestr_822(t));
    log_if_debug("setting last_modified:",last_modified);
}

void set_mime_headers_from_cgi_env()
{
  if (http_accept) free(http_accept);
  http_accept = strdup(env_http_accept);
  strcpy(content_type,env_content_type);
  content_length = atoi(env_content_length);
}

static int get_http_header_line(int fd)
/*
 * returns 0 if the header line was read successfully
 * -2 if no header line could be read, -1 on parse error
 * see http://info.cern.ch/hypertext/WWW/Protocols/HTTP/Response.html
 * for details
 */
{
  char l[HUGE_STRING_LEN];
  char w[MAX_STRING_LEN];

  http_status_code = 500;  /* internal error */

  if (http_version) free(http_version);
  http_version = (char *)NULL;

  if (http_reason) free(http_reason);
  http_reason = (char *)NULL;

  if (getline(l,HUGE_STRING_LEN,fd,timeout))
    return(-2);

  cfg_getword(w,l);
  if (strncmp(w,"HTTP",4))
    return(-1);
  http_version = strdup(w);

  cfg_getword(w,l);
  if (! (http_status_code = atoi(w))
	&& 100 <= http_status_code && http_status_code <= 999)
    return(-1);

  http_reason = strdup(l);

  return(0);
}

void raw_get_mime_headers(int fd) {
    char l[10*HUGE_STRING_LEN];  /* for Accept: header, RP */
    char w[MAX_STRING_LEN];

    content_type[0] = '\0';
    last_modified[0] = '\0';
    content_length = -1;
    auth_line[0] = '\0';
    content_encoding[0] = '\0';
    if (http_accept) free(http_accept);
    http_accept = strdup("\0");
    location[0] = '\0';

    while(!getline(l,HUGE_STRING_LEN,fd,timeout)) {
        getword2(w,l,':');
	/* not getword(); continue if the line is no header line (RP) */
        if(!strcasecmp(w,"Content-type")) 
            sscanf(l,"%s",content_type);
        else if(!strcasecmp(w,"Authorization"))
            strcpy(auth_line,l);
        else if(!strcasecmp(w,"Content-length"))
            sscanf(l,"%d",&content_length);
        else if(!strcasecmp(w,"Location"))  /* added by RP ... */
            sscanf(l,"%s",location);
        else if(!strcasecmp(w,"Accept")) {
            if(http_accept[0])
	    /* hack by RP: dynamically allocated */
	    {
	      char *old_accept = http_accept;
	      http_accept = (char *)malloc(strlen(http_accept)+strlen(l)+3);
              sprintf(http_accept,"%s,%s%s",old_accept,l[0]==' '?"":" ",l);
	      free(old_accept);
	    }
            else
            {
	      http_accept = strdup(l);
	    }
        }
        else if(!l[0])
            return;
    }
}

int raw_get_http_header(int fd)
/* 0 if HTTP header line was read, -1 if not */
{
  if (!get_http_header_line(fd))
  {
    raw_get_mime_headers(fd);
    return(0);
  }
  else
  {
    log_error("error getting HTTP header line");
    return(-1);
  }
}

/* what follows was (re)implemented by RP: send headers to buf, then print */

/* attention */
#define fd (s+=strlen(s))

static void string_dump_default_header(char *s)
{
  /* sprintf(fd,"Date: %s GMT%c",get_gmt(),LF); */
  sprintf(fd,"Date: %s%c",gm_timestr_822(time(NULL)),LF);
  sprintf(fd,"Server: %s%c",env_server_software,LF);
  sprintf(fd,"MIME-version: 1.0%c",LF);
}

static void string_send_redirect(char *s, char *url)
{
  *s = '\0';

  sprintf(fd,"%s %d %s%c",env_server_protocol,302,"Found",LF);
  string_dump_default_header(fd);
  sprintf(fd,"Location: %s%c",url,LF);
  sprintf(fd,"Content-type: %s%c","text/html",LF);
  sprintf(fd,"%c",LF);
  sprintf(fd,"<HEAD><TITLE>Uncached document</TITLE></HEAD>\n<BODY>");
  sprintf(fd,"<H1>No caching for this document</H1>\nThe cache server ");
  sprintf(fd,"doesn't cache <A HREF=\"%s\">this document</A>.<P>\n</BODY>",url);
}

static int status_known()
{
  return(http_status_code && http_reason);
}

static void string_begin_http_header(char *s)
{
  if (status_known())
    sprintf(fd,"%s %d %s%c",
	env_server_protocol,http_status_code,http_reason,LF);
  string_dump_default_header(fd);
}

static void string_send_http_header(char *s)
{
  *s = '\0';  /* essential! see redef. of fd */

  /* string_begin_http_header(fd,(location[0] ? "302 Found" : "200 OK")); */
  string_begin_http_header(fd);
  /* no check for presence/absence of location */

  if (content_type[0])
    sprintf(fd,"Content-type: %s%c",content_type,LF);
  if (last_modified[0])
    sprintf(fd,"Last-modified: %s%c",last_modified,LF);
  if (content_length >= 0)
    sprintf(fd,"Content-length: %d%c",content_length,LF);
  if (location[0])
    sprintf(fd,"Location: %s%c",location,LF);
  if (content_encoding[0])
    sprintf(fd,"Content-encoding: %s%c",content_encoding,LF);
  if (strcmp(env_gateway_interface,"CGI/1.0") && status_known())
    /* I'm a post-1.0 script */
    sprintf(fd,"Status: %d %s%c",http_status_code,http_reason,LF);

  sprintf(fd,"%c",LF);
}

#undef fd
/* sigh */

void send_redirect(FILE *fd,char *url)
{
  char h[HUGE_STRING_LEN+1];  /* should be enough */
  string_send_redirect(h,url);
  if (HUGE_STRING_LEN+1 < strlen(h))
    log_error("internal error: HTTP redirect message too long for buffer");
  fwrite(h,1,strlen(h),fd);
}

void send_http_header(FILE *fd)
{
  char h[HUGE_STRING_LEN+1];  /* should be enough */
  string_send_http_header(h);
  if (HUGE_STRING_LEN+1 < strlen(h))
    log_error("internal error: HTTP header too long for buffer");
  fwrite(h,1,strlen(h),fd);
}

int raw_send_http_header(int fd)
{
  char h[HUGE_STRING_LEN+1];  /* should be enough */
  string_send_http_header(h);
  if (HUGE_STRING_LEN+1 < strlen(h))
    log_error("internal error: HTTP header too long for buffer");
  return(write(fd,h,strlen(h)));
}

void send_cgi_header(FILE *fd)
{
  if (content_type[0])
  {
    fprintf(fd,"Content-type: %s%c",content_type,LF);
  }
  else  /* shouldn't happen */
  {
    log_error("the content type of this document could not be determined");
    fprintf(fd,"Content-type: %s%c",default_mime_type,LF);
  }
  fprintf(fd,"%c",LF);
}

#define MAX_WR 140  /* I think it is ... manpage is not too clear */
int writen(int fd, char *buf, int nbyte)
{
  int rc;
  int nb = 0;
  while (nbyte-nb > MAX_WR)
  {
    rc = write(fd,&buf[nb],MAX_WR);
    if (rc < MAX_WR) return(rc);
    nb += rc;
  }
  rc = write(fd,&buf[nb],nbyte-nb);
  if (rc < nbyte-nb) return(rc);
  nb += rc;
  return(nb);
}

int raw_send_http_request(char *request, char *input, int fd)
/* if no input, just supply ""; never (char *)NULL */
{
  /* use Referer: and If-modified-since: at some point in the future */
  char request_head[HUGE_STRING_LEN+1];
  char *rh = request_head;
  char *full_request;
  int nb;
  char two_lfs[3];
  char *one_lf = &two_lfs[1];

  two_lfs[2] = '\0';
  two_lfs[0] = two_lfs[1] = LF;

  *rh = '\0';

  sprintf(rh += strlen(rh),"%s %s HTTP/1.0%c",env_request_method, request, LF);
  sprintf(rh += strlen(rh),"User-agent: cache Lagoon/%s%c", cache_version, LF);
  sprintf(rh += strlen(rh),"From: %s (cache server maintainer)%c",
    server_maintainer, LF);
  if (content_length)
    sprintf(rh += strlen(rh),"Content-length: %d%c", content_length,LF);
  if (content_type[0])
    sprintf(rh += strlen(rh),"Content-type: %s%c", content_type,LF);

  full_request = (char *)malloc(strlen(request_head)+2*strlen(http_accept)+
    strlen(input)+5);
  strcpy(full_request,request_head);
  {
    /* fragment http_accept header: write() fails otherwise */
    char *s = http_accept;
    char *d = &full_request[strlen(full_request)];

    while (*s)
    {
      strcat(d,"Accept: ");
      d += 8;
      while (*s &&  (*s==' '||*s==',')) ++s;		/* skip separation */
      while (*s && !(*s==' '||*s==',')) *d++ = *s++;	/* copy attribute */
      *d++ = LF;
    }
    *d = '\0';
  }
  strcat(full_request,one_lf);
  strcat(full_request,input);
  strcat(full_request,*input?two_lfs:"");

  nb = write(fd,full_request,(int)strlen(full_request));
  if (nb != strlen(full_request))
  {
     char err[MAX_STRING_LEN+1];
     sprintf(err,"writing request body: only %d of %d bytes were written",
        nb,strlen(input));
     log_error(err);
     die(DIE_WROUT,"request could not be written to remote server");
  }
  free(full_request);
  return(nb);
}

int is_regular_document_header()
{
  return(http_status_code == 200);
}
