/* noerror.c - error.c replacement for those who don't print HTML */
/*				and/or do not have logfiles	  */

#include <stdio.h>
#include <malloc.h>

#include "util.h"
#include "error.h"

void die(int err,char *reason)
{
  fprintf(stderr,"error rc=%d, argument %s\n",err,reason);
  exit(err);
}

static int cb = 0;
static char *ws = "";

int current_badness()
{
  return(cb);
}

int add_warning(char *w1, char *w2, int badness)
{
  char *old_ws = ws;
  ws = (char *)malloc(strlen(old_ws)+strlen(w1)+strlen(w2)+3);
  sprintf(ws,"%s%s %s\n", old_ws, w1, w2);
  free(old_ws);

  if (badness < cb) cb = badness;
  return(cb);
}

void log_warnings()
/* frees the list, too */
{
  int next_separator;
  char *w = ws;
  while (*w && ((next_separator = ind(w,'\n')) != -1))
  {
    w[next_separator] = '\0';
    fprintf(stderr,"warning: %s\n",w);
    w[next_separator] = '\n';
    w = &w[next_separator+1];
    next_separator = ind(w,'\n');
  }

  if (*w) die(DIE_BUG,"log_warnings() found a strange list of warnings");

  free(ws);
  ws = strdup("");
}
