/* system software stuff; system dependent defines and replacement routines */
/* this is from NCSA httpd 1.1, httpd.h */

/* Define one of these according to your system. */
#if defined(SUNOS4)
#define BSD
#undef NO_KILLPG
#undef NO_SETSID
char *crypt(char *pw, char *salt);

#elif defined(SOLARIS2)
#undef BSD
#define NO_KILLPG
#undef NO_SETSID
#define bzero(a,b) memset(a,0,b)

#elif defined(IRIX)
#undef BSD
#undef NO_KILLPG
#undef NO_SETSID

#elif defined(HPUX)
#undef BSD
#define NO_KILLPG
#undef NO_SETSID
#define _HPUX_SOURCE

#elif defined(AIX)
#undef BSD
#undef NO_KILLPG
#undef NO_SETSID

#elif defined(ULTRIX)
#define BSD
#undef NO_KILLPG
#undef NO_SETSID
#define ULTRIX_BRAIN_DEATH
#define NEED_STRDUP

#elif defined(OSF1)
#define BSD
#undef NO_KILLPG
#undef NO_SETSID

#elif defined(SEQUENT)
#define BSD
#undef NO_KILLPG
#define NO_SETSID
#define NEED_STRDUP
#define tolower(c) (isupper(c) ? tolower(c) : c)

#elif defined(NEXT)
#define BSD
#undef NO_KILLPG
#define NO_SETSID
#define NEED_STRDUP
#undef _POSIX_SOURCE
#ifndef S_ISDIR
#define S_ISDIR(m)      (((m)&(S_IFMT)) == (S_IFDIR))
#endif
#ifndef S_ISREG
#define S_ISREG(m)      (((m)&(S_IFMT)) == (S_IFREG))
#endif
#ifndef S_IXUSR
#define S_IXUSR 00100
#endif
#ifndef S_IXGRP
#define S_IXGRP 00010
#endif
#ifndef S_IXOTH
#define S_IXOTH 00001
#endif
#ifndef S_IRUSR
#define S_IRUSR S_IREAD
#endif
#ifndef S_IWUSR
#define S_IWUSR S_IWRITE
#endif
#define STDIN_FILENO  0
#define STDOUT_FILENO 1
#define STDERR_FILENO 2
#define waitpid(a,b,c) wait4(a,b,c,NULL)
typedef int pid_t;

#elif defined(LINUX)
#undef BSD
#undef NO_KILLPG
#undef NO_SETSID
#undef NEED_STRDUP

#elif defined(SCO)
#undef BSD
#undef NO_KILLPG
#undef NO_SETSID
#define NEED_INITGROUPS

#elif defined(CONVEXOS)
#define BSD
#define NEED_STRDUP

#elif defined(AUX)
#undef BSD
#undef NO_KILLPG
#undef NO_SETSID
#define NEED_STRDUP
#define _POSIX_SOURCE

#elif defined(SVR4)
#define NO_KILLPG
#undef  NO_SETSID
#undef NEED_STRDUP
#define NEED_STRCASECMP
#define NEED_STRNCASECMP
#define bzero(a,b) memset(a,0,b)

/* Unknown system - Edit these to match */
#else
/* BSD is whether your system uses BSD calls or System V calls. */
#define BSD
/* NO_KILLPG is set on systems that don't have killpg */
#undef NO_KILLPG
/* NO_SETSID is set on systems that don't have setsid */
#undef NO_SETSID
/* NEED_STRDUP is set on stupid systems that don't have strdup. */
#undef NEED_STRDUP
#endif

#if defined(SVR4) || defined(SOLARIS2)
/* #define bzero(p,n) memset(p,'\0',n) */
#define bcopy(s,d,n) memcpy(d,s,n)
#else
extern void bzero (void *, int);
extern void bcopy (const void *, void *, int);
#endif

#ifdef USE_NDBM
#ifdef SVR4
#include <../ucbinclude/ndbm.h>
#else
#include <ndbm.h>
#endif
#endif

/*
 * The particular directory style your system supports. If you have dirent.h
 * in /usr/include (POSIX) or /usr/include/sys (SYSV), #include 
 * that file and define DIR_TYPE to be dirent. Otherwise, if you have 
 * /usr/include/sys/dir.h, define DIR_TYPE to be direct and include that
 * file. If you have neither, I'm confused.
 */
#if !defined(NEXT) && !defined(CONVEXOS)
#include <dirent.h>
#define DIR_TYPE dirent
#else
#include <sys/dir.h>
#define DIR_TYPE direct
#endif

/*
 * copied from: Id: proto.h,v 1.2 1993/10/19 11:41:37 devet Exp
 *
 * Additional prototypes for SUNOS 4.1.1
 */

/* prototypes for syscalls */

#include <sys/types.h>
#include <sys/socket.h>
#include <stdio.h>  /* for FILE */

int connect (int, struct sockaddr *, int);
int socket (int, int, int);

/* prototypes for some common functions */

extern int printf (const char *, ...);
extern int fprintf (FILE *, const char *, ...);
extern int fflush (FILE *);
extern int sscanf (const char *, const char *, ...);
extern int close (int);

extern int atoi (const char *);

#if defined(SVR4) || defined(SOLARIS2)
/* #define bzero(p,n) memset(p,'\0',n) */
#define bcopy(s,d,n) memcpy(d,s,n)
#else
extern void bzero (void *, int);
extern void bcopy (const void *, void *, int);
#endif

extern void perror (const char *);

extern time_t time(time_t *);

extern int getpeername(int, struct sockaddr *, int *);

/* system.c header stuff */
#ifdef NEED_STRDUP
extern char *strdup (char *str);
#endif
#ifdef NEED_STRCASECMP
int strcasecmp (const char *a, const char *b)
#endif
