/*
**  HEADER FILE FOR NEWS/MAIL GATEWAY CODE.
**  $Header: gate.h,v 1.10 90/03/12 10:34:29 rsalz Exp $
*/


/*
**  START OF CONFIGURATION SECTION
*/


/* Paths to some parts of your netnews installation.  Required. */
#define INEWS		"/usr/lib/news/inews"
#define ACTIVE		"/usr/lib/news/active"
#define NGDELIM		','


/* In writing Paths into From addresses, we can look at the output
 * of uuname from the L.sys file.  Define both or neither of the next
 * two.  We can also map some UUCP names to their domain names, if
 * the third line is enabled.  The UUCP_INET should match the value
 * in the Makefile.  This violates the "write once" rule, but it's
 * too much of a pain to fix for this one symbol. */
#define UUNAME		"/usr/lib/news/.admin/uuname.out"
#define L_SYS		"/usr/lib/uucp/L.sys"
#define UUCP_INET	"/usr/lib/news/.admin/uucp-2-inet"


/* Where does the control file for talk.foo live?
 *	IN_ONEPLACE:	specified filename
 *	IN_SPOOLDIR:	/usr/spool/news/talk/foo/recnews.cmd
 *	IN_CMDDIR:	/usr/lib/news/.admin/talk.foo
 * One of these is required, but you can set IN_ONEPLACE to /dev/null to
 * disable the newsgroup editing. */
/*efine IN_ONEPLACE	"/dev/null"		/* .. */
/*efine IN_SPOOLDIR	"/usr/spool/news"	/* .. */
#define	IN_CMDDIR	"/usr/lib/news/.admin"	/* .. */


/* What do you want to do with the Path: line?  Put in a fixed string
 * (such as pointing to a mail reflector saying "Don't trust Path:
 * lines as a way to reply").  Put a fixed "fake host" in the Path:,
 * or just put the user's host there.  The latter two can cause the
 * poster's site to never get the article.  Anyhow, pick one.  To pick
 * neither #define is to get the third behavior -- the user's host. */
#define FIXED_PATH	"news-mail-gateway"	/* .. */
/*efine	GATEWAY_NAME	"gateway"		/* .. */


/* The code in hdr.c does lots of work to canonicalize addresses.  You
 * shouldn't disable it, but at least one beta-tester wanted to, sigh. */
#define DO_ADDRESS_CLEANUP			/* .. */


/* Are you running sendmail or MMDF?  Pick one.  If you believe in
 * trusted users (MMDF doesn't?) to lie to your mailer, set the
 * user-ID. */
/*efine SENDMAIL	"/usr/lib/sendmail"	/* .. */
#define	MMDF		"/usr/mmdf/lib/submit"	/* .. */
/*efine TRUSTED		1			/* .. */


/* Does your Sendmail mailer have the M flag on? */
#ifdef	SENDMAIL
#define REQUIRE_MESSAGE_ID			/* .. */
#endif	/* SENDMAIL */


/* I love how we all speak the same language. */
#define CATCHER		int		/* Type of a signal-catcher	*/
/*efine CATCHER		void		/* .. */
#define IDX		index		/* .. */
#define RDX		rindex		/* .. */
/*efine IDX		strchr		/* .. */
/*efine RDX		strrchr		/* .. */
typedef int		*align_t;	/* Worst-case alignment, for lint */
#define CHARSTAR_SPRINTF		/* Need extern char *sprintf();	*/
#define	HAVE_NETDB			/* Have <netdb.h> and friends?	*/
#define HAVE_SYSEXITS			/* Have <sysexits.h>?		*/
#define HAVE_SYSWAIT			/* Have <sys/wait.h>?		*/
#define HAVE_TIMEB			/* Have <sys/timeb.h>?		*/

#define SM_SIZE		512		/* A smallish buffer size	*/
#define LG_SIZE		1024		/* big buffer size		*/

/* Error log (stderr) for news2mail. */
#define ERR_LOG		"/usr/lib/news/.admin/news2mail.out"
#define TEMPFILE	"/tmp/gateXXXXXX" /* Temporary file pattern	*/


/* Enable debugging code? */
#define DEBUG
#define STATIC		static
#ifdef	lint
#undef	RCSID
#else
#define RCSID
#endif	/* lint */

/*
**  END OF CONFIGURATION SECTION.
*/



#include <stdio.h>
#include <ctype.h>
#include <sys/types.h>

#ifdef	HAVE_SYSEXITS
#include <sysexits.h>
#else
#include "sysexits.h"
#endif	/* HAVE_SYSEXITS */


typedef struct {
    char	approved[SM_SIZE];	/* Approved:		*/
    char	ctlmsg[LG_SIZE];	/* Control:		*/
    char	subdate[SM_SIZE];	/* Date: (submission)	*/
    char	distribution[SM_SIZE];	/* Distribution:	*/
    char	expdate[SM_SIZE];	/* Expires:		*/
    char	followto[SM_SIZE];	/* Followup-to:		*/
    char	from[SM_SIZE];		/* From:		*/
    char	followid[SM_SIZE];	/* References:		*/
    char	keywords[SM_SIZE];	/* Keywords:		*/
    char	ident[SM_SIZE];		/* Message-ID:		*/
    char	nbuf[LG_SIZE];		/* Newsgroups:		*/
    char	organization[SM_SIZE];	/* Organization:	*/
    char	title[SM_SIZE];		/* Subject:		*/
    char	replyto[SM_SIZE];	/* Reply-To:		*/
    char	summary[SM_SIZE];	/* Summary:		*/
    char	path[LG_SIZE];		/* Path:		*/
    char	sender[SM_SIZE];	/* Sender:		*/
} HBUF;


/* String and memory manipulators. */
#define APPEND(p, t)	strlen(strcpy((p), (t)))
#define NEW(T, c)	(T *)MyAlloc((c) * sizeof (T))
#define COPY(s)		((s) ? strcpy(NEW(char, strlen((s)) + 1), (s)) : NULL)
#define REALLOC(p, s)	realloc((char *)(p), (unsigned int)(s))


/* Array sizing. */
#define SIZEOF(x)	(sizeof x / sizeof x[0])
#define ENDOF(x)	(&x[SIZEOF(x)])


/* String and character operations. */
#define WHITE(c)	((c) == ' ' || (c) == '\t')
#define EQ(a, b)	((a)[0] == (b)[0] && strcmp((a), (b)) == 0)
#define EQn(a, b, n)	((a)[0] == (b)[0] && strncmp((a), (b), (n)) == 0)
#define NETCHR(c)	((c) == '.' || (c) == '%' || (c) == '@' || (c) == '!')
#define CHREQ(c, d)	((d) == (islower((c)) ? toupper((c)) : (c)))


/* Fundamental constants of the universe. */
#define TRUE		1
#define FALSE		0
#define FAIL		(-1)


/* SHUT UP! */
#ifdef	lint
#undef	putc
#undef	putchar
#endif	/* lint */

#define Close		(void)close
#define Fflush		(void)fflush
#define Fprintf		(void)fprintf
#define Fputs		(void)fputs
#define Signal		(void)signal
#define Sprintf		(void)sprintf
#define Strcpy		(void)strcpy
#define Strcat		(void)strcat
#define Strncpy		(void)strncpy


/*
**  External declarations.
*/

/* Program name; exists once for each main(). */
extern	char	*Pname;

/* Routines we provide. */
extern align_t	MyAlloc();
extern int	Split();
extern int	CrackFrom();
extern void	re_modw();
extern void	SplitFree();
extern void	FreeFile();
extern char	**ReadFile();
extern char	*Estring();
extern char	*MakeLower();
extern char	*re_comp();
extern char	*HackHeader();

/* Variables and routines that Unix(tm) provides. */
extern int	errno;
extern int	sys_nerr;
extern int	optind;
extern char	*sys_errlist[];
extern char	**environ;
extern char	*optarg;

extern FILE	*popen();
extern char	*IDX();
extern char	*RDX();
extern char	*ctime();
extern char	*malloc();
extern char	*mktemp();
extern char	*realloc();
extern char	*strcat();
extern char	*strncat();
extern char	*strcpy();
extern char	*strncpy();
#ifdef	CHARSTAR_SPRINTF
extern char	*sprintf();
#endif	/* CHARSTAR_SPRINTF */
