/*
**  NEWS2MAIL
**  Read a news article on standard input, and send it to the mailing
**  list as directed by the command-line arguments.  It does some
**  parsing and converting of news headers into mail headers.
**
**  This program wants to lie to sendmail, so it should be setuid to
**  one of the "trusted" users as listed in your sendmail.cf file.
**
*/
#include "gate.h"
#include <sys/stat.h>
#ifdef	RCSID
static char RCS[] =
	"$Header: news2mail.c,v 1.9 90/03/12 10:34:56 rsalz Exp $";
#endif	/* RCSID */


/* Offsets into our argument list. */
#define LISTNAME	1
#define CONTACTADDR	2
#define REQUESTNAME	3
#define HOST		4
#define ARTICLE		5

/* Flags for special header lines. */
#define HDR_NORM	0
#define HDR_SUBJ	1
#define HDR_CTRL	2
#define HDR_REFS	3
#define HDR_PATH	4
#define HDR_FROM	5


/* Header-cracking datatype. */
typedef struct {
    int		Flag;
    char	Value[SM_SIZE];
    int		Length;
    char	*Tag;
} HEADER;


/* The headers we care about. */
STATIC HEADER	Table[] = {
    {	HDR_NORM,	"",	  5,	"Date:"		},
    {	HDR_PATH,	"",	  5,	"Path:"		},
    {	HDR_FROM,	"",	  5,	"From:"		},
    {	HDR_SUBJ,	"",	  8,	"Subject:"	},
    {	HDR_CTRL,	"",	  8,	"Control:"	},
    {	HDR_NORM,	"",	  9,	"Reply-To:"	},
    {	HDR_NORM,	"",	 11,	"Message-ID:"	},
    {	HDR_REFS,	"",	 11,	"References:"	},
    {	HDR_NORM,	"",	 13,	"Organization:"	}
};

/* Program name. */
char	*Pname;


/*
**  Figure out the return address, by doing some optimization on the
**  path.  If we find an Internet host or a UUCP neighbor, remove all
**  hosts before that one from the path.
*/
STATIC char *
EditPath(path, Host)
    register char	*path;
    char		*Host;
{
    static char		**Hinet;
    static char		**Huucp;
    static char		**Lsys;
    static char		buff[SM_SIZE];
    register char	*p;
    register char	*q;
    register char	**V;
    register int	ac;
    register int	i;
    register int	uucppal;
    register int	inetpal;
    FILE		*F;
    FILE		*P;
    struct stat		Sb1;
    struct stat		Sb2;
    char		**av;
    char		*Inetsite;

    if ((ac = Split(path, &av, '!')) == 2) {
	/* Simple case:  "site!user" */
	Strcpy(buff, av[1]);
	SplitFree(&av);
	return buff;
    }

    /* Initialize.  This is silly for now, but eventually we might want
     * to be able to handle a batched feed. */
#ifdef	UUNAME
    if (Lsys == NULL) {
	p = UUNAME;
	/* If someone diddled L.sys, rebuild uuname output. */
	if (stat(L_SYS, &Sb1) < 0 || stat(p, &Sb2) < 0
	  || Sb1.st_mtime >= Sb2.st_mtime)
	    if ((F = fopen(p, "w"))  == NULL)
		Fprintf(stderr, "%s:  Can't create %s, %s.\n",
			Pname, p, Estring());
	    else {
		if ((P = popen("exec uuname", "r")) == NULL)
		    Fprintf(stderr, "%s:  popen failed, %s.\n",
			    Pname, Estring());
		else {
		    while (fgets(buff, sizeof buff, P))
			Fputs(buff, F);
		    if (pclose(P))
			Fprintf(stderr, "%s:  pclose failed, %s.\n",
				Pname, Estring());
		}
		if (fclose(F) == EOF)
		    Fprintf(stderr, "%s:  Error closing %s, %s.\n",
			    Pname, p, Estring());
	    }

	/* Slurp up names of UUCP hosts we talk to. */
	Lsys = ReadFile(p);

#ifdef	UUCP_INET
	/* Slurp up the UUCP->Internet name mappings. */
	for (Huucp = ReadFile(UUCP_INET), i = 1; Huucp[i]; i++)
	    ;
	for (Hinet = NEW(char*, i), i = 0; p = Huucp[i]; i++) {
	    while (*p && !WHITE(*p))
		p++;
	    if (*p)
		for (*p++ = '\0'; *p && WHITE(*p); p++)
		    ;
	    Hinet[i] = p;
	}
#endif	/* UUCP_INET */
    }
#endif	/* UUNAME */

    /* Scan the path, noting if we find a UUCP or Internet neighbor. */
    for (uucppal = 1, inetpal = 0, i = 0; i < ac; i++) {
	for (V = Lsys; *V; V++)
	    if (EQ(av[i], *V))
		uucppal = i;
	for (V = Huucp; *V; V++)
	    if (EQ(av[i], *V)) {
		inetpal = i;
		Inetsite = Hinet[V - Huucp];
	    }
    }

    if (inetpal < uucppal) {
	/* No Internet site found, turn a!b!c into a!b!c@this-host */
	for (p = buff + APPEND(buff, av[uucppal]); ++uucppal < ac; ) {
	    *p++ = '!';
	    p += APPEND(p, av[uucppal]);
	}
	*p++ = '@';
	Strcpy(p, Host);
    }
    else if (inetpal == ac - 1)
	/* Turn a!b!inet!user into user@inet.domain.name */
	Sprintf(buff, "%s@%s", av[ac], Inetsite);
    else {
	/* Turn a!inet!b!user into b!user@inet.domain.name */
	for (p = buff + APPEND(buff, av[++inetpal]); ++inetpal < ac; ) {
	    *p++ = '!';
	    p += APPEND(p, av[inetpal]);
	}
	*p++ = '@';
	Strcpy(p, Inetsite);
    }

    /* Convert all but the last "@" to "%" (fie on decwrl and psuecl!). */
    if (p = IDX(buff, '@'))
	for ( ; q = IDX(p + 1, '@'); p = q)
	    *p = '%';

    SplitFree(&av);
    return buff;
}


/*
**  Hack up the references, taking only the last three.
*/
STATIC char *
TrimReferences(refs)
    char		 *refs;
{
    static char		buff[SM_SIZE];
    register char	*p;
    register int	i;
    register int	ac;
    char		**av;

    if (ac = Split(refs, &av, '\0')) {
	/* Tricky.  If there are five references, we want subscripts 2,3,4. */
	i = ac < 3 ? 0 : ac - 3;
	for (p = buff + APPEND(buff, av[i]); ++i < ac; ) {
	    *p++ = ',';
	    *p++ = ' ';
	    p += APPEND(p, av[i]);
	}
	SplitFree(&av);
    }
    else
	buff[0] = '\0';
    return buff;
}


main(ac, av)
    int			ac;
    register char	*av[];
{
    static char		tmp[sizeof TEMPFILE];
    register FILE	*F;
    register HEADER	*hp;
    register char	*p;
    char		*sv[10];
    char		buff[BUFSIZ];
    char		Host[SM_SIZE];
    char		Fullname[SM_SIZE];

    /* Arrange for logging. */
    if (freopen(ERR_LOG, "a", stderr) == NULL)
	/* Sigh; error in error handler.... */
	(void)freopen("/dev/console", "w", stderr);

    /* Check and parse JCL. */
    Pname = (Pname = RDX(av[0], '/')) ? Pname + 1 : av[0];
    if (ac != 5 && ac != 6) {
	Fprintf(stderr, "%s:  Bad calling sequence.\n", Pname);
	exit(EX_USAGE);
    }
    if (ac == 6 && freopen(av[ARTICLE], "r", stdin) == NULL) {
	Fprintf(stderr, "%s:  Can't open %s, %s.\n",
		Pname, av[ARTICLE], Estring());
	exit(EX_NOINPUT);
    }

    /* Who are we? */
    if (gethostname(Host, sizeof Host) < 0) {
	Fprintf(stderr, "%s:  Can't get hostname, %s.\n", Pname, Estring());
	exit(EX_TEMPFAIL);
    }

    /* Read headers, storing the ones we want. */
    while (fgets(buff, sizeof buff, stdin)) {
	if (p = IDX(buff, '\n'))
	    *p = '\0';
	else
	    Fprintf(stderr, "%s:  Header line too long for me:\n\t%s\n",
		    Pname, buff);
	if (p == buff)
	    /* Blank line means end of headers. */
	    break;

	for (hp = Table; hp < ENDOF(Table); hp++)
	    if (EQn(hp->Tag, buff, hp->Length)) {
		/* Skip whitespace. */
		for (p = &buff[hp->Length]; *p && WHITE(*p); p++)
		    ;
		switch (hp->Flag) {
		case HDR_SUBJ:
		    if (!EQn(p, "cmsg", 4)) {
			Strcpy(hp->Value, p);
			break;
		    }
		    /* FALLTHROUGH */
		case HDR_CTRL:
		    /* Eat rest of message. */
		    while (fgets(buff, sizeof buff, stdin))
			;
		    exit(EX_OK);
		    /* NOTREACHED */
		case HDR_NORM:
		    Strcpy(hp->Value, p);
		    break;
		case HDR_FROM:
		    /* Turn "joe@site.uucp (My Name)" into "(My Name)" */
		    if (p = IDX(p, ' '))
			Strcpy(Fullname, ++p);
		    else
			Fullname[0] = '\0';
		    break;
		case HDR_REFS:
		    Strcpy(hp->Value, TrimReferences(p));
		    break;
		case HDR_PATH:
		    Strcpy(hp->Value, EditPath(p, Host));
		    break;
		}
	}
    }

    /* Set up temp output. */
    if ((F = fopen(mktemp(strcpy(tmp, TEMPFILE)), "w")) == NULL) {
	Fprintf(stderr, "%s:  Can't create %s, %s.\n", tmp, Estring());
	exit(EX_CANTCREAT);
    }

    /* Print out a sanitized header for mail. */
    Fprintf(F, "Received: from USENET by %s with netnews\n", Host);
    Fprintf(F, "\tfor %s@%s (%s@%s);\n",
	    av[CONTACTADDR], av[HOST], av[LISTNAME], av[HOST]);
    Fprintf(F, "\tcontact usenet@%s if you have questions.\n", Host);
    Fprintf(F, "To: %s@%s\n", av[LISTNAME], av[HOST]);
    for (hp = Table; hp < ENDOF(Table); hp++)
	if (hp->Flag == HDR_PATH) {
	    Fprintf(F, "From: %s %s\n", hp->Value, Fullname);
	    Fprintf(F, "Sender: %s@%s\n", av[REQUESTNAME], av[HOST]);
	}
	else if (hp->Value[0])
	    Fprintf(F, "%s %s\n", hp->Tag, hp->Value);
    Fprintf(F, "\n");

    /* Dump the body of the message. */
    while (fgets(buff, sizeof buff, stdin))
	Fputs(buff, F);
    if (fclose(F) == EOF)
	Fprintf(stderr, "%s:  Error closing %s, %s.\n",
		Pname, tmp, Estring());

    /* Set I/O correctly.  Stderr is going to the log, stdin should be the
     * message we created.  Easiest thing is to unlink an open file. */
    if (freopen(tmp, "r", stdin) == NULL) {
	Fprintf(stderr, "%s:  Can't open %s for reading, %s.\n",
		Pname, tmp, Estring());
	exit(EX_OSERR);
    }
    if (unlink(tmp) < 0)
	Fprintf(stderr, "%s:  Can't unlink %s, %s.\n",
		Pname, tmp, Estring());

#ifdef	SENDMAIL
    /* Build of the SENDMAIL argument vector. */
    sv[0] = SENDMAIL;
    /* Ignore periods as message terminator (same as -oi). */
    sv[1] = "-i";
    /* Queued delivery. */
    sv[2] = "-odq";
    /* Set the "From:" address. */
    sv[3] = "-f";
    Sprintf(sv[4] = buff, "%s@%s", av[REQUESTNAME], av[HOST]);
    /* Set the recipient. */
    Sprintf(sv[5] = Host, "%s@%s", av[CONTACTADDR], av[HOST]);
    sv[6] = NULL;
#endif	/* SENDMAIL */

#ifdef	MMDF
    /* Build of the MMDF argument vector. */
    sv[0] = MMDF;
    /* Deliver to mailbox (m), deliver all mail now (ln), trust me (t), send
     * no warnings (z), return to "Sender:" (s), get recipients from the
     * "To:" address (xto*). */
    sv[1] = "-mlntzsxto*";
    /* Set the recipient. */
    Sprintf(sv[2] = buff, "%s@%s", av[CONTACTADDR], av[HOST]);
    sv[3] = NULL;
#endif	/* MMDF */

    /* Try to setuid, if desired.  Could "factor out" the execv from the
     * #ifdef, but I hate the way the resultant "dangling else" looks. */
#ifdef	TRUSTED
    if (setuid(TRUSTED) < 0)
	Fprintf(stderr, "%s:  Can't setuid to %d, %s.\n",
		Pname, TRUSTED, Estring());
    else
	(void)execv(sv[0], sv);
#else
    (void)execv(sv[0], sv);
#endif	/* TRUSTED */

    /* Something failed; dump the message and quit */
    Fprintf(stderr, "%s:  Can't execv %s, %s.\n", Pname, sv[0], Estring());
    while (fgets(buff, sizeof buff, stdin))
	Fputs(buff, stdout);
    exit(EX_OSERR);
}
