
package Paws::SES::GetIdentityMailFromDomainAttributes;
  use Moose;
  has Identities => (is => 'ro', isa => 'ArrayRef[Str|Undef]', required => 1);

  use MooseX::ClassAttribute;

  class_has _api_call => (isa => 'Str', is => 'ro', default => 'GetIdentityMailFromDomainAttributes');
  class_has _returns => (isa => 'Str', is => 'ro', default => 'Paws::SES::GetIdentityMailFromDomainAttributesResponse');
  class_has _result_key => (isa => 'Str', is => 'ro', default => 'GetIdentityMailFromDomainAttributesResult');
1;

### main pod documentation begin ###

=head1 NAME

Paws::SES::GetIdentityMailFromDomainAttributes - Arguments for method GetIdentityMailFromDomainAttributes on L<Paws::SES>

=head1 DESCRIPTION

This class represents the parameters used for calling the method GetIdentityMailFromDomainAttributes on the
L<Amazon Simple Email Service|Paws::SES> service. Use the attributes of this class
as arguments to method GetIdentityMailFromDomainAttributes.

You shouldn't make instances of this class. Each attribute should be used as a named argument in the call to GetIdentityMailFromDomainAttributes.

=head1 SYNOPSIS

    my $email = Paws->service('SES');
    # GetIdentityMailFromDomainAttributes
    # The following example returns the custom MAIL FROM attributes for an
    # identity:
    my $GetIdentityMailFromDomainAttributesResponse =
      $email->GetIdentityMailFromDomainAttributes(
      'Identities' => ['example.com'] );

    # Results:
    my $MailFromDomainAttributes =
      $GetIdentityMailFromDomainAttributesResponse->MailFromDomainAttributes;

   # Returns a L<Paws::SES::GetIdentityMailFromDomainAttributesResponse> object.

Values for attributes that are native types (Int, String, Float, etc) can passed as-is (scalar values). Values for complex Types (objects) can be passed as a HashRef. The keys and values of the hashref will be used to instance the underlying object.
For the AWS API documentation, see L<https://docs.aws.amazon.com/goto/WebAPI/email/GetIdentityMailFromDomainAttributes>

=head1 ATTRIBUTES


=head2 B<REQUIRED> Identities => ArrayRef[Str|Undef]

A list of one or more identities.




=head1 SEE ALSO

This class forms part of L<Paws>, documenting arguments for method GetIdentityMailFromDomainAttributes in L<Paws::SES>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

