# Generated by default/object.tt
package Paws::IoT::AuditSuppression;
  use Moose;
  has CheckName => (is => 'ro', isa => 'Str', request_name => 'checkName', traits => ['NameInRequest'], required => 1);
  has Description => (is => 'ro', isa => 'Str', request_name => 'description', traits => ['NameInRequest']);
  has ExpirationDate => (is => 'ro', isa => 'Str', request_name => 'expirationDate', traits => ['NameInRequest']);
  has ResourceIdentifier => (is => 'ro', isa => 'Paws::IoT::ResourceIdentifier', request_name => 'resourceIdentifier', traits => ['NameInRequest'], required => 1);
  has SuppressIndefinitely => (is => 'ro', isa => 'Bool', request_name => 'suppressIndefinitely', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::IoT::AuditSuppression

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::IoT::AuditSuppression object:

  $service_obj->Method(Att1 => { CheckName => $value, ..., SuppressIndefinitely => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::IoT::AuditSuppression object:

  $result = $service_obj->Method(...);
  $result->Att1->CheckName

=head1 DESCRIPTION

Filters out specific findings of a Device Defender audit.

=head1 ATTRIBUTES


=head2 B<REQUIRED> CheckName => Str




=head2 Description => Str

The description of the audit suppression.


=head2 ExpirationDate => Str

The expiration date (epoch timestamp in seconds) that you want the
suppression to adhere to.


=head2 B<REQUIRED> ResourceIdentifier => L<Paws::IoT::ResourceIdentifier>




=head2 SuppressIndefinitely => Bool

Indicates whether a suppression should exist indefinitely or not.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::IoT>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

