use strict;
use warnings;
use Test::More tests => 68;
use Digest::Fugue qw(fugue_384 fugue_384_hex);

my $len = 0;

while (my $line = <DATA>) {
    chomp $line;
    my ($msg, $digest) = split '\|', $line, 2;
    my $data = pack 'H*', $msg;
    $digest = lc $digest;

    if ($len and not $len % 8) {
        my $md = Digest::Fugue->new(384)->add($data)->hexdigest;
        is($md, $digest, "new/add/hexdigest: $len bits of $msg");
        is(
            fugue_384_hex($data), $digest,
            "fugue_384_hex: $len bits of $msg"
        );
        ok(
            fugue_384($data) eq pack('H*', $digest),
            "fugue_384: $len bits of $msg"
        );
    }

    my $md = Digest::Fugue->new(384)->add_bits($data, $len)->hexdigest;
    is($md, $digest, "new/add_bits/hexdigest: $msg");
}
continue { $len++ }

__DATA__
00|466D05F6812B58B8628E53816B2A99D173B804A964DE971829159C3791AC8B524EEBBF5FC73BA40EA8EEA446D5424A30
00|69F95F9F2A5EDD33D061022040873AA1FF0D6CADF0F11B7A40A6D819329E515DEE008528EA2F94084A8863901F075703
C0|FD0F0B76D749F7714ACE932A43E61EB636DA2EFCCC32F66F6E0C021BF3D1291AA39FF295F64CC93C7A7229C72B527B44
C0|D15CC44D45EB4EAD49A3454EB7BC18D9EBD654D7A6F5CBD85C5943728EF62019D8E600E317B0CA384AF0EDE89170AAF6
80|86011B99004287ED3E46F67ACDE8E276A56E05F51EA4F156E7DFA3EABC30404DDCF1769EB7AA5DCDF32CB3472558E205
48|0CAE02E956303B78008F9C034FA3D88856122E11DA1F95D4E79594E00EDC0127869D19A45D75BB8CECE352898B9D7CE2
50|7B8854BF670F5EEB0190A228D1A009AFAB4522472E96A06220FFE7168BFD1DF9639605BE9A6C9BC36A34AE8F93A53FEE
98|2A25A0B40565BED6A8F8B9932E1CE2B0941EF3F9171C2BB401CEDE6597C1C35CCDF837D60863707C3AA0B8A385DE017F
CC|436868CD6804B803DAC432ED561BB40F91F624A10F2A368702359841CFDA6909115628CA4977B3F8063A3B87FC7A0984
9800|A22F6BB2A1F221B5E8CB1C11523FD6E92A622ACDA5A474940C3D171E7FD4133209346A8C38FA883D200DEF1CDE20BCD1
9D40|1EA5F2FC2994675333CE72C25F51B21143893E78821F9A43CC7916102CE9E6D41A2BE157979DA5E4839E1E8747AFEF54
AA80|ABDB07F20F451E03904BE71DF18CF2DABC27EE3C44099AF2B3CB06F25244AF10C0C222831A94D512492328D39DCFC398
9830|BBC2B0B1B8DA9AC8A862EC6045485936FBA54C28F41144B290E05E2705A43C99FA4D59E3E2D40DD4E8917F8BC512CD70
5030|33B3BC58FEE14A3DA5682FFA5BF06F6EAE66726FEED5CEB6DB1603AB2AFAAFED2C292C7F476BBBDBE152E950407979CA
4D24|34CD85BA88FBC90F700D4A991F9CB806641515AFE92CD93732F7C9E8B51D220D9088A367ECEC477729E24B7AA5DC28DC
CBDE|A757A7DCE0E758B4A6977A0DDA8D6E00BFEF3EC08ED5AB18B4D0805380FB1B981FCA433439D03300DB414DCC0B3C73B3
41FB|FAF69841CA96EC8F96657F2871C1DDF9A060E5D55CD7E196078AA920171F73E5373ECDA45B4552590124D280E22D9BE6
4FF400|5262F3DB05B8D01A59DEE2B1E430093B83451BC2B04D8D06D11CA0D010F6C8CF980317F4DEB51BF6B82564519B5E78D1
FD0440|CF2E11E5881E912445563C004AB4472412F8A429422B87BE27B05DEDC17814D6DE2A5D92C151C7EDA9E3AD57F6C4E305
424D00|981B30FBB39496379ED1B8554496193DFC141CB67533391DAD3810915225210BF7DB4400F88BF5A7A8B4AB6FBF675E26
3FDEE0|DB0E8FBCA78B23F451558143B0969E61785A01B8A278851960690CFBC667A6218BFE00D0DEC4CF7344ABDE070B0CA091
335768|D8CE670780BAB77265EC28F3A0D66BA98DEE50E90A620CDB6306D3E968737B9EED1219900B51E5C07CB61A9ECA1901AD
051E7C|40F28E40676372F480A961E8D1E3DC8F1A9607095510D8DE964C92A1352B130A8ED80C8FF05A8BD5DE2FFF6E13A52FC3
717F8C|5A8765AE16D757CC153BAA3812D36EFA6108BC363DE628E51EC9A3E5E8E3ED610F90F3A8AABD4364CA27C85148781273
1F877C|47FC7C9DF32D8FFAD51D840DE2DA1908DD0993340E965B425F8BBBA468239973E349394BCFE288B4EE467772BFD26939
EB35CF80|FEC91AA8D22AC9ADE7FFEAD6F38114127450B7DCE9B5D36024CCCDE00DEADA4140297B949A5A2D46D814F7DCF7B8D2C6
B406C480|B71E6EA5B10037217544F2C203E18723978CF0333EE9EFA5F9B06EAF20B60448133E9AF444EAB03AAD56A81CF5CB4D05
CEE88040|EE67A83695F7F6B898C6186BA335450D351B0ACA0E688034485832E40322BDD7B0C6D07BC12BF4D5BE80FF7C017CCC88
C584DB70|44AFDE3213A1E6DE6511712916AABDC841FEA13B3079B8A9C76C89F92B02AD07BAC851ECA0C8AD0DA8B924009F1F2125
53587BC8|2FE07F20CE789FD7CE90264BC11E9238C9D54546B7A318F848AA28E8DA9165B18A21C37B7E33FF8B559836BE87FE334E
69A305B0|B09201A1BC3A51A59387B3D68A6FC7A2783D3FC7432F08B662601ADA074BED0D3D0AD6C97E72E275A0511F7B77184CD2
C9375ECE|FB9CF85A287F56693684775D8590596638644D379C5F407CAC93C79ECA050DF8C9966F7524E0220670D3F9452D5E29AF
C1ECFDFC|7092B797E08636119EA45A145C83CCE0D1155B00C82306B471A90F9CA1BFA6539EA0CE3E430AAEAEFD84655C7AEC657A
8D73E8A280|529984516CB9A3B4EF27EE093E6E351AB697B33ADF4F590949D30FE466A713D6683F014F15B511405C6651B76DF0216A
06F2522080|871A41F3CDA8B1EB3DB6B5FEC07277D549FADDBEEAA991CD782EAEC449F68B1E4DB7F6A6CE13BF2A80A89E109145EB07
3EF6C36F20|0050D36163C830F488F75A7C70B76E5DC828267CCEFEDC9926F338CC6DCF6EE3B9A6787D7173E66763501EFF1DC4C605
0127A1D340|05D334A9CA57668CD4DB0EFA6A3F16E6638C4B32213A847F630FEF99205CE75B478C91C4D74AC86B05062B0C1EE84860
6A6AB6C210|2B1759500EB8183387B5C928BAAB66C813CF3B5331BC84676F0C05EB9D9ABE09E5F87732712213B449CFFC36EA4E3C41
AF3175E160|6016E4A658FE629539BA4BAA116C0F61D3AF2A720A9AF2FE2B71E19A6BCCB248A54077965FBEF5DC3D5EC5BD43FF67AF
B66609ED86|5BCF267354C810AA7F8F8804D473ED95266C6620F395D45BDC59B2C7AD8C22BD974EB7C29B933C88DE155B318BD59334
21F134AC57|BE4194A2B73651814631CBDD73B97719F863ABEE2F3E71AE4AEEE348843CE2F068FB08B49FCCAAF8EC917C75C39B6202
3DC2AADFFC80|9455D7EDE6CA0226976B57D987F8733FCCC2CF69AF60F75815B946799DF70187E9264140B86F72863C45B5E9C86A28CF
9202736D2240|C68E9C028D6D66D7A014620EC11ED9F046F9586DA72FF008BE741B2754ED1F54C749F633DD143B5508DE0331CD364F54
F219BD629820|5E121AAA9AA1997CD7E51C314229C39D85D1DCDA4B658F54FDC986885B1B3597896E6637DCE4913ED18016BC56F18EE9
F3511EE2C4B0|DC18B07236A493EBD841C766E5D27DBDFBF13AB29B26AB472E96498276402F78DE39B87F750F6F1F39EC6085E4688694
3ECAB6BF7720|17ED36B02C1CD1FC0499FCC8E020E6AB50240B13FE65F0B40E4AF650C78A1D360BF6DEC207233B6CC36F3B8C765926FC
CD62F688F498|968C22AD413F1E350F524A7E05187DF61052A00E31D155E02240E6944C2733C8F170E036B5D1B0E4121392370432C797
C2CBAA33A9F8|362C76402D98A891402D967B46CEA97C29EFC7287909B75BA9774BBD6665FD51CD499AE4F48BEBBE78B9F2C6A1F513F7
C6F50BB74E29|AD340157DD68E0C8AF60D8E926B0E3A721D93627DA58FA77C4DF14DF56C324E4F711E64C0AD6346A949ECF0185AB6E1F
79F1B4CCC62A00|DBEFB9B78C59D11C81AC23A02C5EBE816F81E4275C3FDB0B63E82A6D0444535BA9B84F3A9BE3A557308A92BEEBE5BF3B
