use strict;
use Digest::SHA3;

my $TAGS = join('|', qw(Len Msg Squeezed));
my @vecs = ();
while (<DATA>) {
	next unless /^\s*($TAGS)\s*=\s*([\dA-F]+)/o;
	push(@vecs, $2);
}

my $numtests = scalar(@vecs) / 3;
print "1..$numtests\n";

for (1 .. $numtests) {
	my $sha3 = Digest::SHA3->new(256000);
	my $Len = shift @vecs;
	my $Msg = pack("H*", shift @vecs);
	if ($Len % 8) {
		my @a = unpack("C*", $Msg);
		my $b = pop(@a);
		$b <<= (8 - $Len % 8);
		push(@a, $b);
		$Msg = pack("C*", @a);
	}
	$sha3->add_bits($Msg, $Len);
	my $MD = shift @vecs;
	my $computed = "";
	while (length($computed) < 512) {
		$computed .= $sha3->squeeze;
	}
	$computed = unpack("H*", substr($computed, 0, 512));
	print "not " unless $computed eq lc($MD);
	print "ok ", $_, "\n";
}

__DATA__
# Keccak(SakuraSequential|11)[r=1088, c=512], or SHAKE256 as in FIPS 202 draft

Len = 7
Msg = 4C
Squeezed = 8DE08ECF3885D613C0F3AE2987F94495678334B7880E48234785925A72D4567B8B8CD6D35B580151928A61BB4F55537B03CEB1AAC592AF5B2372E063001C23ED35CF03710524CBFB3A9A66004BA12C811E3881203F1117932D024954420156DD13418DA78C463902ABEEED04C6EEC60613C1FEDD492A9C0C3A1B265C9C67BE587CBF5F84EB78C65A166A1E49476C5D39EBF256CDBF3AC53ED68E46370D2E9A9A916E2A481A35E330FF122EB3CC87F313E2766A6818E34EEC24C149494FEBF2DCF57254CE25414BAFD9BBB4B86457847F3243933240D7F3576CC136D777F89AFE203E37A4F28F98BA844409E7A2E44873F801A954C1762174440644E5FF1051794761BA23914426E94D7B1047658DCA7E9540B0DD844ECB0758716E188CCDE3C61D590477EC4E187E742FFACDB509D47D931A128552979650353FFC50A6C35E19947015103483B86156EC9E956897C4DEFFB86E8128A1FF83AD473DD0B77BA68033A716102BC32C661305214B399F5D3CA92E3B856D8A6D1E9808FF6A12FAF6BBF0D3E9B69D87EA098FED112F8B039F8B128B7F370118667A3DEEAAEC296056EB92557129886DA1A4FF34EC773CC678B8CFCF50412EC59F9D4D5A9C6D63EBA66F49C8CAF3C1CF274FB9A70C28ADAFC8205A788943935F8E2F1C11E7B274B23C8AE52A9DF1C8157924DCCE2D4136E0363289D4121F5795C82E6471CC5A65857E8F

Len = 2047
Msg = 1F42ADD25C0A80A4C82AAE3A0E302ABF9261DCA7E7884FD869D96ED4CE88AAAA25304D2D79E1FA5CC1FA2C95899229BC87431AD06DA524F2140E70BD0536E9685EE7808F598D8A9FE15D40A72AEFF431239292C5F64BDB7F620E5D160B329DEB58CF6D5C0665A3DED61AE4ADBCA94DC2B7B02CDF3992FDF79B3D93E546D5823C3A630923064ED24C3D974C4602A49DF75E49CF7BD51EDC7382214CBA850C4D3D11B40A70B1D926E3755EC79693620C242AB0F23EA206BA337A7EDC5421D63126CB6C7094F6BC1CF9943796BE2A0D9EB74FC726AA0C0D3B3D39039DEAD39A7169F8C3E2365DD349E358BF08C717D2E436D65172A76ED5E1F1E694A75C19280B15
Squeezed = E826B639644A82131550584399CD05C5337311AACD629EACD7D21E50434109DF7125514D6A5FFA7268BC9AD15688EC40C00A665BE5BE021ACF2E066CB596CD7C0EB7D7FFDDD06888A4B8A37625B9C6D60C84E3538D5ACFD6F87C175606ECA438057F00F383DEAFB9A4D309D190A690E355A803811A66C309624C3163BD50FEE00D42381A4B17B015072E8B95BFE3ED0CC6EC297C38B87E54C8C57B61EBAA5F3CA393E5B68BAEDC9DF85155C79217BBC0D5240A834D90083D8C2694D2B9A244C7C4C06250F12F722935BC59C1C24FB88D1154EB81AA6C09E9C47E5C36EFD2577967AECD9B5FCE0AEF8203D632AF51CD523211B5807DF5CD9E300DA6CF13AA606E8F523E6CDF5353267862E059F697235A897DEF41CE048DE0548A8AE1688A73A1B95A68BF14BBBD7A9DFDC209A02ADA313326CCA97BCC5EC257A59DF263A7246E69FA88325813F594C8049277292D005507DF029C05F7B823C4D8E71CD9D380B87C786110E77DABBD242DE22AC55933CC01537FB56D51F0337FA6B295EC5B5FC1C0DE44983F44666B5352023F9AA1CD4FB7A79A02465EEFD2D89D416F125472DBE2A3B9DEED4E513D0A2B60D3C149E15754E40236BA470FF8A65C5575E9F8FA623FCCCD165BEE4B6E100E3E0013DF966BA39D3FB306DE789271B201C52CBF9D0093AF70C6DDAFAA9951B6E3FCFF6A833243CB333E708595F228C22609D5FC1EBF
