#============================================================= -*-Perl-*-
#
# Template::Grammar
#
# DESCRIPTION
#   Grammar file for the Template Toolkit language containing token
#   definitions and parser state/rules tables generated by Parse::Yapp.
#
# AUTHOR
#   Andy Wardley   <abw@wardley.org>
#
# COPYRIGHT
#   Copyright (C) 1996-2020 Andy Wardley.  All Rights Reserved.
#   Copyright (C) 1998-2000 Canon Research Centre Europe Ltd.
#
#   This module is free software; you can redistribute it and/or
#   modify it under the same terms as Perl itself.
#
# IMPORTANT NOTE
#   This module is constructed from the parser/Grammar.pm.skel file by
#   running the parser/yc script.  You only need to do this if # you
#   have modified the grammar in the parser/Parser.yp file and need #
#   to-recompile it.  See the README in the 'parser' directory for
#   more information (sub-directory of the Template distribution).
#
#========================================================================

package Template::Grammar;

use strict;
use warnings;

our $VERSION  = '3.008';

my (@RESERVED, %CMPOP, $LEXTABLE, $RULES, $STATES);
my ($factory, $rawstart);


#========================================================================

# Reserved words, comparison and binary operators
#========================================================================

BEGIN {
@RESERVED = qw(
	GET CALL SET DEFAULT INSERT INCLUDE PROCESS WRAPPER BLOCK END
	USE PLUGIN FILTER MACRO PERL RAWPERL TO STEP AND OR NOT DIV MOD
	IF UNLESS ELSE ELSIF FOR NEXT WHILE SWITCH CASE META IN
	TRY THROW CATCH FINAL LAST RETURN STOP CLEAR VIEW DEBUG
    );

# for historical reasons, != and == are converted to ne and eq to perform
# stringwise comparison (mainly because it doesn't generate "non-numerical
# comparison" warnings which != and == can) but the others (e.g. < > <= >=)
# are not converted to their stringwise equivalents.  I added 'gt' et al,
# briefly for v2.04d and then took them out again in 2.04e.


%CMPOP = qw(
    != ne
    == eq
    <  <
    >  >
    >= >=
    <= <=
);

#    eq eq  # add these lines to the above to
#    lt lt  # enable the eq, lt and gt operators
#    gt gt

#========================================================================
# Lexer Token Table
#========================================================================

# lookup table used by lexer is initialised with special-cases
$LEXTABLE = {
    'FOREACH' => 'FOR',
    'BREAK'   => 'LAST',
    '&&'      => 'AND',
    '||'      => 'OR',
    '!'       => 'NOT',
    '|'	      => 'FILTER',
    '.'       => 'DOT',
    '_'       => 'CAT',
    '..'      => 'TO',
#    ':'       => 'MACRO',
    '='       => 'ASSIGN',
    '=>'      => 'ASSIGN',
#    '->'      => 'ARROW',
    ','       => 'COMMA',
    '\\'      => 'REF',
    'and'     => 'AND',		# explicitly specified so that qw( and or
    'or'      => 'OR',		# not ) can always be used in lower case,
    'not'     => 'NOT',		# regardless of ANYCASE flag
    'mod'     => 'MOD',
    'div'     => 'DIV',
};

# localise the temporary variables needed to complete lexer table
{
    my @tokens = qw< ( ) [ ] { } ${ $ + / ; : ? >;
    my @cmpop  = keys %CMPOP;
    my @binop  = qw( - * % );              # '+' and '/' above, in @tokens

    # fill lexer table, slice by slice, with reserved words and operators
    @$LEXTABLE{ @RESERVED, @cmpop, @binop, @tokens }
			= ( @RESERVED, ('CMPOP') x @cmpop, ('BINOP') x @binop, @tokens );
}

} # --- END BEGIN

#========================================================================
# CLASS METHODS
#========================================================================

sub new {
    my $class = shift;
    bless {
		LEXTABLE => $LEXTABLE,
		STATES   => $STATES,
		RULES    => $RULES,
    }, $class;
}

# update method to set package-scoped $factory lexical
sub install_factory {
    my ($self, $new_factory) = @_;
    $factory = $new_factory;
}


BEGIN {
#========================================================================
# States
#========================================================================

$STATES = [
	{#State 0
		ACTIONS => {
			'BLOCK' => 49,
			'PROCESS' => 48,
			'LITERAL' => 51,
			'NOT' => 43,
			"{" => 45,
			'SET' => 37,
			'META' => 38,
			'CLEAR' => 39,
			'RETURN' => 42,
			'WRAPPER' => 41,
			"\${" => 33,
			'VIEW' => 67,
			'INSERT' => 68,
			'SWITCH' => 62,
			'STOP' => 64,
			'DEBUG' => 66,
			'WHILE' => 59,
			'DEFAULT' => 60,
			'NEXT' => 53,
			'TEXT' => 56,
			'IF' => 57,
			'USE' => 12,
			"(" => 14,
			'REF' => 15,
			"[" => 16,
			'LAST' => 9,
			'THROW' => 10,
			"\"" => 11,
			'PERL' => 4,
			'INCLUDE' => 5,
			'FILTER' => 6,
			";" => -18,
			'NUMBER' => 1,
			'MACRO' => 25,
			'UNLESS' => 27,
			'TRY' => 28,
			'RAWPERL' => 20,
			'GET' => 22,
			'IDENT' => 24,
			'FOR' => 23,
			"\$" => 17,
			'CALL' => 18
		},
		DEFAULT => -3,
		GOTOS => {
			'expr' => 44,
			'node' => 46,
			'lterm' => 47,
			'setlist' => 13,
			'directive' => 52,
			'filter' => 50,
			'use' => 32,
			'condition' => 31,
			'capture' => 2,
			'ident' => 34,
			'anonblock' => 35,
			'atomdir' => 36,
			'switch' => 3,
			'defblock' => 7,
			'chunks' => 8,
			'wrapper' => 40,
			'loop' => 63,
			'rawperl' => 26,
			'view' => 65,
			'assign' => 69,
			'macro' => 70,
			'block' => 29,
			'atomexpr' => 73,
			'template' => 71,
			'item' => 72,
			'try' => 30,
			'chunk' => 58,
			'defblockname' => 19,
			'term' => 55,
			'sterm' => 54,
			'statement' => 21,
			'perl' => 61
		}
	},
	{#State 1
		DEFAULT => -114
	},
	{#State 2
		DEFAULT => -11
	},
	{#State 3
		DEFAULT => -22
	},
	{#State 4
		ACTIONS => {
			";" => 74
		}
	},
	{#State 5
		ACTIONS => {
			'LITERAL' => 77,
			'IDENT' => 84,
			'FILENAME' => 83,
			"\$" => 82,
			"\"" => 81,
			'NUMBER' => 79
		},
		GOTOS => {
			'filename' => 80,
			'filepart' => 78,
			'nameargs' => 76,
			'name' => 85,
			'names' => 75
		}
	},
	{#State 6
		ACTIONS => {
			"\"" => 91,
			"\${" => 33,
			'NUMBER' => 79,
			"\$" => 93,
			'IDENT' => 92,
			'FILENAME' => 83,
			'LITERAL' => 86
		},
		GOTOS => {
			'nameargs' => 87,
			'lvalue' => 88,
			'filename' => 80,
			'item' => 89,
			'filepart' => 78,
			'names' => 75,
			'lnameargs' => 90,
			'name' => 85
		}
	},
	{#State 7
		DEFAULT => -9
	},
	{#State 8
		ACTIONS => {
			'LAST' => 9,
			'THROW' => 10,
			"\"" => 11,
			"[" => 16,
			"(" => 14,
			'USE' => 12,
			'REF' => 15,
			";" => -18,
			'NUMBER' => 1,
			'FILTER' => 6,
			'INCLUDE' => 5,
			'PERL' => 4,
			'MACRO' => 25,
			'TRY' => 28,
			'UNLESS' => 27,
			'CALL' => 18,
			"\$" => 17,
			'GET' => 22,
			'IDENT' => 24,
			'FOR' => 23,
			'RAWPERL' => 20,
			'NOT' => 43,
			"{" => 45,
			'LITERAL' => 51,
			'PROCESS' => 48,
			'BLOCK' => 49,
			"\${" => 33,
			'CLEAR' => 39,
			'META' => 38,
			'RETURN' => 42,
			'WRAPPER' => 41,
			'SET' => 37,
			'DEBUG' => 66,
			'SWITCH' => 62,
			'STOP' => 64,
			'INSERT' => 68,
			'VIEW' => 67,
			'TEXT' => 56,
			'IF' => 57,
			'NEXT' => 53,
			'DEFAULT' => 60,
			'WHILE' => 59
		},
		DEFAULT => -2,
		GOTOS => {
			'rawperl' => 26,
			'view' => 65,
			'loop' => 63,
			'try' => 30,
			'item' => 72,
			'atomexpr' => 73,
			'assign' => 69,
			'macro' => 70,
			'term' => 55,
			'sterm' => 54,
			'chunk' => 94,
			'defblockname' => 19,
			'perl' => 61,
			'statement' => 21,
			'expr' => 44,
			'filter' => 50,
			'directive' => 52,
			'setlist' => 13,
			'lterm' => 47,
			'node' => 46,
			'ident' => 34,
			'capture' => 2,
			'condition' => 31,
			'use' => 32,
			'wrapper' => 40,
			'defblock' => 7,
			'switch' => 3,
			'anonblock' => 35,
			'atomdir' => 36
		}
	},
	{#State 9
		DEFAULT => -39
	},
	{#State 10
		ACTIONS => {
			"\$" => 82,
			"\"" => 81,
			'NUMBER' => 79,
			'LITERAL' => 77,
			'IDENT' => 84,
			'FILENAME' => 83
		},
		GOTOS => {
			'nameargs' => 95,
			'filename' => 80,
			'filepart' => 78,
			'name' => 85,
			'names' => 75
		}
	},
	{#State 11
		DEFAULT => -177,
		GOTOS => {
			'quoted' => 96
		}
	},
	{#State 12
		ACTIONS => {
			'LITERAL' => 86,
			'IDENT' => 92,
			"\$" => 93,
			'NUMBER' => 79,
			"\${" => 33,
			"\"" => 91,
			'FILENAME' => 83
		},
		GOTOS => {
			'item' => 89,
			'filename' => 80,
			'lvalue' => 88,
			'nameargs' => 87,
			'name' => 85,
			'lnameargs' => 97,
			'names' => 75,
			'filepart' => 78
		}
	},
	{#State 13
		ACTIONS => {
			'LITERAL' => 100,
			'IDENT' => 24,
			"\$" => 17,
			"\${" => 33,
			'COMMA' => 101
		},
		DEFAULT => -19,
		GOTOS => {
			'assign' => 98,
			'node' => 46,
			'item' => 72,
			'ident' => 99
		}
	},
	{#State 14
		ACTIONS => {
			'NUMBER' => 1,
			"\${" => 33,
			"\$" => 17,
			'IDENT' => 24,
			"\"" => 11,
			"{" => 45,
			'NOT' => 43,
			'REF' => 15,
			"(" => 14,
			"[" => 16,
			'LITERAL' => 51
		},
		GOTOS => {
			'item' => 72,
			'node' => 46,
			'lterm' => 47,
			'assign' => 102,
			'ident' => 104,
			'term' => 55,
			'sterm' => 54,
			'expr' => 103
		}
	},
	{#State 15
		ACTIONS => {
			'IDENT' => 24,
			"\${" => 33,
			"\$" => 17
		},
		GOTOS => {
			'item' => 72,
			'ident' => 105,
			'node' => 46
		}
	},
	{#State 16
		ACTIONS => {
			"]" => 106,
			'REF' => 15,
			"[" => 16,
			'LITERAL' => 109,
			'IDENT' => 24,
			"\$" => 17,
			'NUMBER' => 1,
			"\${" => 33,
			"\"" => 11,
			"{" => 45
		},
		GOTOS => {
			'sterm' => 112,
			'term' => 111,
			'ident' => 108,
			'range' => 110,
			'item' => 72,
			'list' => 107,
			'node' => 46,
			'lterm' => 47
		}
	},
	{#State 17
		ACTIONS => {
			'IDENT' => 113
		}
	},
	{#State 18
		ACTIONS => {
			'LITERAL' => 109,
			"[" => 16,
			'REF' => 15,
			"(" => 14,
			'NOT' => 43,
			"{" => 45,
			"\"" => 11,
			'IDENT' => 24,
			"\${" => 33,
			'NUMBER' => 1,
			"\$" => 17
		},
		GOTOS => {
			'node' => 46,
			'lterm' => 47,
			'item' => 72,
			'sterm' => 54,
			'ident' => 108,
			'term' => 55,
			'expr' => 114
		}
	},
	{#State 19
		ACTIONS => {
			'IDENT' => 116
		},
		DEFAULT => -87,
		GOTOS => {
			'blockargs' => 115,
			'metadata' => 117,
			'meta' => 118
		}
	},
	{#State 20
		DEFAULT => -78,
		GOTOS => {
			'@5-1' => 119
		}
	},
	{#State 21
		ACTIONS => {
			";" => 120
		}
	},
	{#State 22
		ACTIONS => {
			'REF' => 15,
			"(" => 14,
			'IDENT' => 24,
			"[" => 16,
			'LITERAL' => 109,
			"\${" => 33,
			'NUMBER' => 1,
			"\"" => 11,
			"\$" => 17,
			'NOT' => 43,
			"{" => 45
		},
		GOTOS => {
			'node' => 46,
			'lterm' => 47,
			'item' => 72,
			'sterm' => 54,
			'ident' => 108,
			'term' => 55,
			'expr' => 121
		}
	},
	{#State 23
		ACTIONS => {
			"{" => 45,
			"\$" => 17,
			"\"" => 11,
			'NUMBER' => 1,
			"\${" => 33,
			'LITERAL' => 109,
			"[" => 16,
			'IDENT' => 123,
			'REF' => 15
		},
		GOTOS => {
			'ident' => 108,
			'sterm' => 54,
			'term' => 124,
			'loopvar' => 122,
			'item' => 72,
			'lterm' => 47,
			'node' => 46
		}
	},
	{#State 24
		DEFAULT => -131
	},
	{#State 25
		ACTIONS => {
			'IDENT' => 125
		}
	},
	{#State 26
		DEFAULT => -15
	},
	{#State 27
		ACTIONS => {
			"(" => 14,
			'REF' => 15,
			'LITERAL' => 109,
			"[" => 16,
			'IDENT' => 24,
			"\$" => 17,
			'NUMBER' => 1,
			"\${" => 33,
			"\"" => 11,
			'NOT' => 43,
			"{" => 45
		},
		GOTOS => {
			'sterm' => 54,
			'ident' => 108,
			'term' => 55,
			'expr' => 126,
			'item' => 72,
			'node' => 46,
			'lterm' => 47
		}
	},
	{#State 28
		ACTIONS => {
			";" => 127
		}
	},
	{#State 29
		DEFAULT => -1
	},
	{#State 30
		DEFAULT => -24
	},
	{#State 31
		DEFAULT => -21
	},
	{#State 32
		DEFAULT => -13
	},
	{#State 33
		ACTIONS => {
			"\$" => 17,
			"\"" => 11,
			'NUMBER' => 1,
			"\${" => 33,
			'LITERAL' => 109,
			'IDENT' => 24,
			'REF' => 15
		},
		GOTOS => {
			'ident' => 108,
			'sterm' => 128,
			'item' => 72,
			'node' => 46
		}
	},
	{#State 34
		ACTIONS => {
			'DOT' => 129,
			'ASSIGN' => 130
		},
		DEFAULT => -110
	},
	{#State 35
		DEFAULT => -10
	},
	{#State 36
		ACTIONS => {
			";" => -20
		},
		DEFAULT => -27
	},
	{#State 37
		ACTIONS => {
			"\$" => 17,
			"\${" => 33,
			'LITERAL' => 100,
			'IDENT' => 24
		},
		GOTOS => {
			'item' => 72,
			'ident' => 132,
			'assign' => 69,
			'node' => 46,
			'setlist' => 131
		}
	},
	{#State 38
		ACTIONS => {
			'IDENT' => 116
		},
		GOTOS => {
			'meta' => 118,
			'metadata' => 133
		}
	},
	{#State 39
		DEFAULT => -38
	},
	{#State 40
		DEFAULT => -42
	},
	{#State 41
		ACTIONS => {
			'NUMBER' => 79,
			"\"" => 81,
			"\$" => 82,
			'FILENAME' => 83,
			'IDENT' => 84,
			'LITERAL' => 77
		},
		GOTOS => {
			'names' => 75,
			'name' => 85,
			'nameargs' => 134,
			'filepart' => 78,
			'filename' => 80
		}
	},
	{#State 42
		DEFAULT => -36
	},
	{#State 43
		ACTIONS => {
			"\$" => 17,
			'NUMBER' => 1,
			"\${" => 33,
			'IDENT' => 24,
			"\"" => 11,
			"{" => 45,
			'NOT' => 43,
			"(" => 14,
			'REF' => 15,
			"[" => 16,
			'LITERAL' => 109
		},
		GOTOS => {
			'expr' => 135,
			'ident' => 108,
			'term' => 55,
			'sterm' => 54,
			'lterm' => 47,
			'node' => 46,
			'item' => 72
		}
	},
	{#State 44
		ACTIONS => {
			'CAT' => 145,
			'BINOP' => 139,
			'CMPOP' => 143,
			"?" => 141,
			'AND' => 138,
			'OR' => 140,
			"+" => 142,
			"/" => 136,
			'MOD' => 137,
			";" => -16,
			'DIV' => 144
		},
		DEFAULT => -26
	},
	{#State 45
		ACTIONS => {
			"\$" => 17,
			"\${" => 33,
			'LITERAL' => 149,
			'IDENT' => 24
		},
		DEFAULT => -120,
		GOTOS => {
			'param' => 146,
			'params' => 150,
			'item' => 148,
			'hash' => 147
		}
	},
	{#State 46
		DEFAULT => -128
	},
	{#State 47
		DEFAULT => -104
	},
	{#State 48
		ACTIONS => {
			'LITERAL' => 77,
			'FILENAME' => 83,
			'IDENT' => 84,
			"\$" => 82,
			'NUMBER' => 79,
			"\"" => 81
		},
		GOTOS => {
			'name' => 85,
			'names' => 75,
			'filename' => 80,
			'filepart' => 78,
			'nameargs' => 151
		}
	},
	{#State 49
		ACTIONS => {
			'IDENT' => 152,
			'FILENAME' => 83,
			'LITERAL' => 156,
			'NUMBER' => 79
		},
		DEFAULT => -87,
		GOTOS => {
			'metadata' => 117,
			'filepart' => 78,
			'meta' => 118,
			'blockname' => 155,
			'blockargs' => 153,
			'filename' => 154
		}
	},
	{#State 50
		DEFAULT => -43
	},
	{#State 51
		ACTIONS => {
			'ASSIGN' => 157
		},
		DEFAULT => -113
	},
	{#State 52
		DEFAULT => -8
	},
	{#State 53
		DEFAULT => -40
	},
	{#State 54
		DEFAULT => -105
	},
	{#State 55
		DEFAULT => -147
	},
	{#State 56
		DEFAULT => -6
	},
	{#State 57
		ACTIONS => {
			'NOT' => 43,
			"{" => 45,
			"\$" => 17,
			"\"" => 11,
			'NUMBER' => 1,
			"\${" => 33,
			"[" => 16,
			'LITERAL' => 109,
			'IDENT' => 24,
			"(" => 14,
			'REF' => 15
		},
		GOTOS => {
			'item' => 72,
			'lterm' => 47,
			'node' => 46,
			'term' => 55,
			'sterm' => 54,
			'ident' => 108,
			'expr' => 158
		}
	},
	{#State 58
		DEFAULT => -5
	},
	{#State 59
		ACTIONS => {
			"[" => 16,
			'LITERAL' => 109,
			'IDENT' => 24,
			"(" => 14,
			'REF' => 15,
			'NOT' => 43,
			"{" => 45,
			"\$" => 17,
			"\"" => 11,
			'NUMBER' => 1,
			"\${" => 33
		},
		GOTOS => {
			'item' => 72,
			'lterm' => 47,
			'node' => 46,
			'term' => 55,
			'ident' => 108,
			'sterm' => 54,
			'expr' => 159
		}
	},
	{#State 60
		ACTIONS => {
			'IDENT' => 24,
			'LITERAL' => 100,
			"\${" => 33,
			"\$" => 17
		},
		GOTOS => {
			'item' => 72,
			'ident' => 99,
			'setlist' => 160,
			'assign' => 69,
			'node' => 46
		}
	},
	{#State 61
		DEFAULT => -25
	},
	{#State 62
		ACTIONS => {
			"\"" => 11,
			'NUMBER' => 1,
			"\${" => 33,
			"\$" => 17,
			'NOT' => 43,
			"{" => 45,
			'REF' => 15,
			"(" => 14,
			'IDENT' => 24,
			"[" => 16,
			'LITERAL' => 109
		},
		GOTOS => {
			'term' => 55,
			'sterm' => 54,
			'ident' => 108,
			'expr' => 161,
			'lterm' => 47,
			'node' => 46,
			'item' => 72
		}
	},
	{#State 63
		DEFAULT => -23
	},
	{#State 64
		DEFAULT => -37
	},
	{#State 65
		DEFAULT => -14
	},
	{#State 66
		ACTIONS => {
			'NUMBER' => 79,
			"\"" => 81,
			"\$" => 82,
			'FILENAME' => 83,
			'IDENT' => 84,
			'LITERAL' => 77
		},
		GOTOS => {
			'names' => 75,
			'name' => 85,
			'nameargs' => 162,
			'filepart' => 78,
			'filename' => 80
		}
	},
	{#State 67
		ACTIONS => {
			'LITERAL' => 77,
			'FILENAME' => 83,
			'IDENT' => 84,
			"\$" => 82,
			'NUMBER' => 79,
			"\"" => 81
		},
		GOTOS => {
			'nameargs' => 163,
			'filename' => 80,
			'filepart' => 78,
			'name' => 85,
			'names' => 75
		}
	},
	{#State 68
		ACTIONS => {
			'NUMBER' => 79,
			"\"" => 81,
			"\$" => 82,
			'FILENAME' => 83,
			'IDENT' => 84,
			'LITERAL' => 77
		},
		GOTOS => {
			'nameargs' => 164,
			'filename' => 80,
			'filepart' => 78,
			'name' => 85,
			'names' => 75
		}
	},
	{#State 69
		DEFAULT => -150
	},
	{#State 70
		DEFAULT => -12
	},
	{#State 71
		ACTIONS => {
			'' => 165
		}
	},
	{#State 72
		ACTIONS => {
			"(" => 166
		},
		DEFAULT => -129
	},
	{#State 73
		ACTIONS => {
			'WRAPPER' => 172,
			'IF' => 170,
			'FOR' => 167,
			'FILTER' => 169,
			'UNLESS' => 168,
			'WHILE' => 171
		}
	},
	{#State 74
		DEFAULT => -76,
		GOTOS => {
			'@4-2' => 173
		}
	},
	{#State 75
		ACTIONS => {
			"+" => 176,
			"(" => 175
		},
		DEFAULT => -157,
		GOTOS => {
			'args' => 174
		}
	},
	{#State 76
		DEFAULT => -33
	},
	{#State 77
		DEFAULT => -170
	},
	{#State 78
		DEFAULT => -172
	},
	{#State 79
		DEFAULT => -175
	},
	{#State 80
		ACTIONS => {
			'DOT' => 177
		},
		DEFAULT => -169
	},
	{#State 81
		DEFAULT => -177,
		GOTOS => {
			'quoted' => 178
		}
	},
	{#State 82
		ACTIONS => {
			'IDENT' => 24,
			"\$" => 17,
			"\${" => 33
		},
		GOTOS => {
			'item' => 72,
			'ident' => 179,
			'node' => 46
		}
	},
	{#State 83
		DEFAULT => -173
	},
	{#State 84
		DEFAULT => -174
	},
	{#State 85
		DEFAULT => -167
	},
	{#State 86
		ACTIONS => {
			'ASSIGN' => -162
		},
		DEFAULT => -170
	},
	{#State 87
		DEFAULT => -159
	},
	{#State 88
		ACTIONS => {
			'ASSIGN' => 180
		}
	},
	{#State 89
		DEFAULT => -160
	},
	{#State 90
		ACTIONS => {
			";" => 181
		}
	},
	{#State 91
		DEFAULT => -177,
		GOTOS => {
			'quoted' => 182
		}
	},
	{#State 92
		ACTIONS => {
			'ASSIGN' => -131
		},
		DEFAULT => -174
	},
	{#State 93
		ACTIONS => {
			'IDENT' => 183,
			"\$" => 17,
			"\${" => 33
		},
		GOTOS => {
			'node' => 46,
			'ident' => 179,
			'item' => 72
		}
	},
	{#State 94
		DEFAULT => -4
	},
	{#State 95
		DEFAULT => -35
	},
	{#State 96
		ACTIONS => {
			'IDENT' => 24,
			'TEXT' => 185,
			"\"" => 188,
			"\${" => 33,
			"\$" => 17,
			";" => 186
		},
		GOTOS => {
			'node' => 46,
			'quotable' => 187,
			'ident' => 184,
			'item' => 72
		}
	},
	{#State 97
		DEFAULT => -73
	},
	{#State 98
		DEFAULT => -148
	},
	{#State 99
		ACTIONS => {
			'DOT' => 129,
			'ASSIGN' => 189
		}
	},
	{#State 100
		ACTIONS => {
			'ASSIGN' => 157
		}
	},
	{#State 101
		DEFAULT => -149
	},
	{#State 102
		ACTIONS => {
			")" => 190
		}
	},
	{#State 103
		ACTIONS => {
			'AND' => 138,
			"?" => 141,
			'DIV' => 144,
			'BINOP' => 139,
			")" => 191,
			'CAT' => 145,
			'MOD' => 137,
			'CMPOP' => 143,
			"+" => 142,
			"/" => 136,
			'OR' => 140
		}
	},
	{#State 104
		ACTIONS => {
			'DOT' => 129,
			'ASSIGN' => 189
		},
		DEFAULT => -110
	},
	{#State 105
		ACTIONS => {
			'DOT' => 129
		},
		DEFAULT => -111
	},
	{#State 106
		DEFAULT => -108
	},
	{#State 107
		ACTIONS => {
			"\$" => 17,
			'COMMA' => 193,
			"\${" => 33,
			'NUMBER' => 1,
			'IDENT' => 24,
			"\"" => 11,
			"{" => 45,
			"]" => 194,
			'REF' => 15,
			"[" => 16,
			'LITERAL' => 109
		},
		GOTOS => {
			'item' => 72,
			'lterm' => 47,
			'node' => 46,
			'term' => 192,
			'ident' => 108,
			'sterm' => 54
		}
	},
	{#State 108
		ACTIONS => {
			'DOT' => 129
		},
		DEFAULT => -110
	},
	{#State 109
		DEFAULT => -113
	},
	{#State 110
		ACTIONS => {
			"]" => 195
		}
	},
	{#State 111
		DEFAULT => -117
	},
	{#State 112
		ACTIONS => {
			'TO' => 196
		},
		DEFAULT => -105
	},
	{#State 113
		DEFAULT => -133
	},
	{#State 114
		ACTIONS => {
			"/" => 136,
			"+" => 142,
			'OR' => 140,
			'DIV' => 144,
			'MOD' => 137,
			'AND' => 138,
			"?" => 141,
			'CMPOP' => 143,
			'BINOP' => 139,
			'CAT' => 145
		},
		DEFAULT => -29
	},
	{#State 115
		ACTIONS => {
			";" => 197
		}
	},
	{#State 116
		ACTIONS => {
			'ASSIGN' => 198
		}
	},
	{#State 117
		ACTIONS => {
			'IDENT' => 116,
			'COMMA' => 199
		},
		DEFAULT => -86,
		GOTOS => {
			'meta' => 200
		}
	},
	{#State 118
		DEFAULT => -100
	},
	{#State 119
		ACTIONS => {
			";" => 201
		}
	},
	{#State 120
		DEFAULT => -7
	},
	{#State 121
		ACTIONS => {
			'OR' => 140,
			"+" => 142,
			"/" => 136,
			'MOD' => 137,
			'DIV' => 144,
			'BINOP' => 139,
			'CAT' => 145,
			'CMPOP' => 143,
			'AND' => 138,
			"?" => 141
		},
		DEFAULT => -28
	},
	{#State 122
		ACTIONS => {
			";" => 202
		}
	},
	{#State 123
		ACTIONS => {
			'ASSIGN' => 203,
			'IN' => 204
		},
		DEFAULT => -131
	},
	{#State 124
		DEFAULT => -157,
		GOTOS => {
			'args' => 205
		}
	},
	{#State 125
		ACTIONS => {
			"{" => 45,
			'NOT' => 43,
			"\"" => 11,
			'THROW' => 10,
			'LAST' => 9,
			'LITERAL' => 51,
			"[" => 16,
			'BLOCK' => 210,
			'PROCESS' => 48,
			'REF' => 15,
			"(" => 206,
			"\${" => 33,
			'NUMBER' => 1,
			'FILTER' => 6,
			'WRAPPER' => 41,
			'RETURN' => 42,
			'CLEAR' => 39,
			'PERL' => 4,
			'SET' => 208,
			'INCLUDE' => 5,
			'UNLESS' => 27,
			'TRY' => 28,
			'DEBUG' => 66,
			'STOP' => 64,
			'SWITCH' => 62,
			'INSERT' => 68,
			'IF' => 57,
			'CALL' => 18,
			'NEXT' => 53,
			"\$" => 17,
			'FOR' => 23,
			'IDENT' => 24,
			'DEFAULT' => 60,
			'GET' => 22,
			'WHILE' => 59
		},
		GOTOS => {
			'directive' => 211,
			'atomexpr' => 73,
			'item' => 72,
			'try' => 30,
			'filter' => 50,
			'assign' => 69,
			'lterm' => 47,
			'node' => 46,
			'setlist' => 13,
			'expr' => 209,
			'loop' => 63,
			'perl' => 61,
			'wrapper' => 40,
			'atomdir' => 36,
			'switch' => 3,
			'mdir' => 207,
			'term' => 55,
			'ident' => 104,
			'sterm' => 54,
			'condition' => 31
		}
	},
	{#State 126
		ACTIONS => {
			'OR' => 140,
			"/" => 136,
			"+" => 142,
			'CMPOP' => 143,
			'MOD' => 137,
			'CAT' => 145,
			'BINOP' => 139,
			'DIV' => 144,
			"?" => 141,
			'AND' => 138,
			";" => 212
		}
	},
	{#State 127
		ACTIONS => {
			'WHILE' => 59,
			'DEFAULT' => 60,
			'NEXT' => 53,
			'IF' => 57,
			'TEXT' => 56,
			'VIEW' => 67,
			'INSERT' => 68,
			'STOP' => 64,
			'SWITCH' => 62,
			'DEBUG' => 66,
			'SET' => 37,
			'WRAPPER' => 41,
			'RETURN' => 42,
			'META' => 38,
			'CLEAR' => 39,
			"\${" => 33,
			'PROCESS' => 48,
			'BLOCK' => 49,
			'LITERAL' => 51,
			'NOT' => 43,
			"{" => 45,
			'RAWPERL' => 20,
			'IDENT' => 24,
			'FOR' => 23,
			'GET' => 22,
			"\$" => 17,
			'CALL' => 18,
			'UNLESS' => 27,
			'TRY' => 28,
			'MACRO' => 25,
			'PERL' => 4,
			'INCLUDE' => 5,
			'FILTER' => 6,
			'NUMBER' => 1,
			";" => -18,
			'REF' => 15,
			'USE' => 12,
			"(" => 14,
			"[" => 16,
			"\"" => 11,
			'THROW' => 10,
			'LAST' => 9
		},
		DEFAULT => -3,
		GOTOS => {
			'expr' => 44,
			'directive' => 52,
			'filter' => 50,
			'lterm' => 47,
			'node' => 46,
			'setlist' => 13,
			'capture' => 2,
			'ident' => 34,
			'use' => 32,
			'condition' => 31,
			'chunks' => 8,
			'defblock' => 7,
			'wrapper' => 40,
			'atomdir' => 36,
			'anonblock' => 35,
			'switch' => 3,
			'view' => 65,
			'rawperl' => 26,
			'loop' => 63,
			'atomexpr' => 73,
			'item' => 72,
			'try' => 30,
			'assign' => 69,
			'macro' => 70,
			'block' => 213,
			'defblockname' => 19,
			'chunk' => 58,
			'sterm' => 54,
			'term' => 55,
			'perl' => 61,
			'statement' => 21
		}
	},
	{#State 128
		ACTIONS => {
			"}" => 214
		}
	},
	{#State 129
		ACTIONS => {
			'IDENT' => 24,
			"\$" => 17,
			"\${" => 33,
			'NUMBER' => 216
		},
		GOTOS => {
			'item' => 72,
			'node' => 215
		}
	},
	{#State 130
		ACTIONS => {
			'SWITCH' => 62,
			'STOP' => 64,
			'TRY' => 28,
			'DEBUG' => 66,
			'UNLESS' => 27,
			'INSERT' => 68,
			"\$" => 17,
			'NEXT' => 53,
			'CALL' => 18,
			'IF' => 57,
			'WHILE' => 59,
			'GET' => 22,
			'DEFAULT' => 60,
			'FOR' => 23,
			'IDENT' => 24,
			'LAST' => 9,
			'THROW' => 10,
			"\"" => 11,
			'NOT' => 43,
			"{" => 45,
			"(" => 14,
			'PROCESS' => 48,
			'BLOCK' => 210,
			'REF' => 15,
			"[" => 16,
			'LITERAL' => 51,
			"\${" => 33,
			'NUMBER' => 1,
			'SET' => 208,
			'INCLUDE' => 5,
			'PERL' => 4,
			'CLEAR' => 39,
			'RETURN' => 42,
			'WRAPPER' => 41,
			'FILTER' => 6
		},
		GOTOS => {
			'assign' => 69,
			'lterm' => 47,
			'node' => 46,
			'setlist' => 13,
			'directive' => 211,
			'atomexpr' => 73,
			'item' => 72,
			'try' => 30,
			'filter' => 50,
			'loop' => 63,
			'expr' => 217,
			'atomdir' => 36,
			'switch' => 3,
			'mdir' => 218,
			'perl' => 61,
			'wrapper' => 40,
			'condition' => 31,
			'sterm' => 54,
			'term' => 55,
			'ident' => 104
		}
	},
	{#State 131
		ACTIONS => {
			'IDENT' => 24,
			"\$" => 17,
			"\${" => 33,
			'COMMA' => 101,
			'LITERAL' => 100
		},
		DEFAULT => -30,
		GOTOS => {
			'node' => 46,
			'assign' => 98,
			'ident' => 99,
			'item' => 72
		}
	},
	{#State 132
		ACTIONS => {
			'DOT' => 129,
			'ASSIGN' => 219
		}
	},
	{#State 133
		ACTIONS => {
			'IDENT' => 116,
			'COMMA' => 199
		},
		DEFAULT => -17,
		GOTOS => {
			'meta' => 200
		}
	},
	{#State 134
		ACTIONS => {
			";" => 220
		}
	},
	{#State 135
		ACTIONS => {
			'BINOP' => 139,
			'CMPOP' => 143,
			"+" => 142,
			"/" => 136,
			'MOD' => 137,
			'CAT' => 145,
			'DIV' => 144
		},
		DEFAULT => -143
	},
	{#State 136
		ACTIONS => {
			"[" => 16,
			'LITERAL' => 109,
			'REF' => 15,
			"(" => 14,
			"{" => 45,
			'NOT' => 43,
			"\"" => 11,
			'IDENT' => 24,
			"\${" => 33,
			'NUMBER' => 1,
			"\$" => 17
		},
		GOTOS => {
			'item' => 72,
			'lterm' => 47,
			'node' => 46,
			'expr' => 221,
			'ident' => 108,
			'sterm' => 54,
			'term' => 55
		}
	},
	{#State 137
		ACTIONS => {
			"[" => 16,
			'LITERAL' => 109,
			'IDENT' => 24,
			"(" => 14,
			'REF' => 15,
			"{" => 45,
			'NOT' => 43,
			"\$" => 17,
			"\"" => 11,
			'NUMBER' => 1,
			"\${" => 33
		},
		GOTOS => {
			'node' => 46,
			'lterm' => 47,
			'item' => 72,
			'expr' => 222,
			'sterm' => 54,
			'ident' => 108,
			'term' => 55
		}
	},
	{#State 138
		ACTIONS => {
			"(" => 14,
			'REF' => 15,
			'LITERAL' => 109,
			"[" => 16,
			"\"" => 11,
			'NOT' => 43,
			"{" => 45,
			'IDENT' => 24,
			"\$" => 17,
			'NUMBER' => 1,
			"\${" => 33
		},
		GOTOS => {
			'node' => 46,
			'lterm' => 47,
			'item' => 72,
			'expr' => 223,
			'sterm' => 54,
			'ident' => 108,
			'term' => 55
		}
	},
	{#State 139
		ACTIONS => {
			'IDENT' => 24,
			"\$" => 17,
			"\${" => 33,
			'NUMBER' => 1,
			"[" => 16,
			'LITERAL' => 109,
			"(" => 14,
			'REF' => 15,
			'NOT' => 43,
			"{" => 45,
			"\"" => 11
		},
		GOTOS => {
			'expr' => 224,
			'ident' => 108,
			'term' => 55,
			'sterm' => 54,
			'item' => 72,
			'node' => 46,
			'lterm' => 47
		}
	},
	{#State 140
		ACTIONS => {
			"(" => 14,
			'REF' => 15,
			"[" => 16,
			'LITERAL' => 109,
			'IDENT' => 24,
			"\$" => 17,
			'NUMBER' => 1,
			"\${" => 33,
			"\"" => 11,
			'NOT' => 43,
			"{" => 45
		},
		GOTOS => {
			'expr' => 225,
			'term' => 55,
			'sterm' => 54,
			'ident' => 108,
			'item' => 72,
			'node' => 46,
			'lterm' => 47
		}
	},
	{#State 141
		ACTIONS => {
			'IDENT' => 24,
			"\$" => 17,
			"\${" => 33,
			'NUMBER' => 1,
			'LITERAL' => 109,
			"[" => 16,
			"(" => 14,
			'REF' => 15,
			'NOT' => 43,
			"{" => 45,
			"\"" => 11
		},
		GOTOS => {
			'item' => 72,
			'lterm' => 47,
			'node' => 46,
			'term' => 55,
			'ident' => 108,
			'sterm' => 54,
			'expr' => 226
		}
	},
	{#State 142
		ACTIONS => {
			'REF' => 15,
			"(" => 14,
			'IDENT' => 24,
			'LITERAL' => 109,
			"[" => 16,
			"\"" => 11,
			'NUMBER' => 1,
			"\${" => 33,
			"\$" => 17,
			"{" => 45,
			'NOT' => 43
		},
		GOTOS => {
			'node' => 46,
			'lterm' => 47,
			'item' => 72,
			'term' => 55,
			'sterm' => 54,
			'ident' => 108,
			'expr' => 227
		}
	},
	{#State 143
		ACTIONS => {
			'NUMBER' => 1,
			"\${" => 33,
			"\$" => 17,
			'IDENT' => 24,
			"\"" => 11,
			"{" => 45,
			'NOT' => 43,
			'REF' => 15,
			"(" => 14,
			'LITERAL' => 109,
			"[" => 16
		},
		GOTOS => {
			'item' => 72,
			'lterm' => 47,
			'node' => 46,
			'term' => 55,
			'ident' => 108,
			'sterm' => 54,
			'expr' => 228
		}
	},
	{#State 144
		ACTIONS => {
			'IDENT' => 24,
			'NUMBER' => 1,
			"\${" => 33,
			"\$" => 17,
			"[" => 16,
			'LITERAL' => 109,
			'REF' => 15,
			"(" => 14,
			'NOT' => 43,
			"{" => 45,
			"\"" => 11
		},
		GOTOS => {
			'expr' => 229,
			'ident' => 108,
			'term' => 55,
			'sterm' => 54,
			'item' => 72,
			'node' => 46,
			'lterm' => 47
		}
	},
	{#State 145
		ACTIONS => {
			'NOT' => 43,
			"{" => 45,
			"\"" => 11,
			"\${" => 33,
			'NUMBER' => 1,
			"\$" => 17,
			'IDENT' => 24,
			"[" => 16,
			'LITERAL' => 109,
			'REF' => 15,
			"(" => 14
		},
		GOTOS => {
			'term' => 55,
			'sterm' => 54,
			'ident' => 108,
			'expr' => 230,
			'item' => 72,
			'lterm' => 47,
			'node' => 46
		}
	},
	{#State 146
		DEFAULT => -123
	},
	{#State 147
		ACTIONS => {
			"}" => 231
		}
	},
	{#State 148
		ACTIONS => {
			'ASSIGN' => 232
		}
	},
	{#State 149
		ACTIONS => {
			'ASSIGN' => 233
		}
	},
	{#State 150
		ACTIONS => {
			'IDENT' => 24,
			'LITERAL' => 149,
			'COMMA' => 234,
			"\${" => 33,
			"\$" => 17
		},
		DEFAULT => -119,
		GOTOS => {
			'item' => 148,
			'param' => 235
		}
	},
	{#State 151
		DEFAULT => -34
	},
	{#State 152
		ACTIONS => {
			'ASSIGN' => 198
		},
		DEFAULT => -174
	},
	{#State 153
		ACTIONS => {
			";" => 236
		}
	},
	{#State 154
		ACTIONS => {
			'DOT' => 177
		},
		DEFAULT => -84
	},
	{#State 155
		DEFAULT => -83
	},
	{#State 156
		DEFAULT => -85
	},
	{#State 157
		ACTIONS => {
			"\"" => 11,
			'NOT' => 43,
			"{" => 45,
			'REF' => 15,
			"(" => 14,
			'LITERAL' => 109,
			"[" => 16,
			'NUMBER' => 1,
			"\${" => 33,
			"\$" => 17,
			'IDENT' => 24
		},
		GOTOS => {
			'expr' => 237,
			'sterm' => 54,
			'term' => 55,
			'ident' => 108,
			'node' => 46,
			'lterm' => 47,
			'item' => 72
		}
	},
	{#State 158
		ACTIONS => {
			'MOD' => 137,
			";" => 238,
			'DIV' => 144,
			'OR' => 140,
			"+" => 142,
			"/" => 136,
			'BINOP' => 139,
			'CAT' => 145,
			'CMPOP' => 143,
			'AND' => 138,
			"?" => 141
		}
	},
	{#State 159
		ACTIONS => {
			'BINOP' => 139,
			'CAT' => 145,
			'MOD' => 137,
			'CMPOP' => 143,
			";" => 239,
			"?" => 141,
			'AND' => 138,
			'DIV' => 144,
			'OR' => 140,
			"+" => 142,
			"/" => 136
		}
	},
	{#State 160
		ACTIONS => {
			'COMMA' => 101,
			"\${" => 33,
			"\$" => 17,
			'IDENT' => 24,
			'LITERAL' => 100
		},
		DEFAULT => -31,
		GOTOS => {
			'item' => 72,
			'ident' => 99,
			'assign' => 98,
			'node' => 46
		}
	},
	{#State 161
		ACTIONS => {
			";" => 240,
			"?" => 141,
			'AND' => 138,
			'DIV' => 144,
			'BINOP' => 139,
			'CAT' => 145,
			'MOD' => 137,
			'CMPOP' => 143,
			"+" => 142,
			"/" => 136,
			'OR' => 140
		}
	},
	{#State 162
		DEFAULT => -41
	},
	{#State 163
		ACTIONS => {
			";" => 241
		}
	},
	{#State 164
		DEFAULT => -32
	},
	{#State 165
		DEFAULT => 0
	},
	{#State 166
		DEFAULT => -157,
		GOTOS => {
			'args' => 242
		}
	},
	{#State 167
		ACTIONS => {
			'IDENT' => 123,
			"[" => 16,
			'LITERAL' => 109,
			'REF' => 15,
			"{" => 45,
			"\${" => 33,
			'NUMBER' => 1,
			"\"" => 11,
			"\$" => 17
		},
		GOTOS => {
			'term' => 124,
			'sterm' => 54,
			'ident' => 108,
			'item' => 72,
			'lterm' => 47,
			'node' => 46,
			'loopvar' => 243
		}
	},
	{#State 168
		ACTIONS => {
			"\$" => 17,
			"\${" => 33,
			'NUMBER' => 1,
			'IDENT' => 24,
			'NOT' => 43,
			"{" => 45,
			"\"" => 11,
			"[" => 16,
			'LITERAL' => 109,
			"(" => 14,
			'REF' => 15
		},
		GOTOS => {
			'item' => 72,
			'lterm' => 47,
			'node' => 46,
			'sterm' => 54,
			'ident' => 108,
			'term' => 55,
			'expr' => 244
		}
	},
	{#State 169
		ACTIONS => {
			'IDENT' => 92,
			'LITERAL' => 86,
			"\"" => 91,
			'NUMBER' => 79,
			"\${" => 33,
			"\$" => 93,
			'FILENAME' => 83
		},
		GOTOS => {
			'filename' => 80,
			'nameargs' => 87,
			'lvalue' => 88,
			'item' => 89,
			'filepart' => 78,
			'lnameargs' => 245,
			'names' => 75,
			'name' => 85
		}
	},
	{#State 170
		ACTIONS => {
			"\$" => 17,
			'NUMBER' => 1,
			"\${" => 33,
			'IDENT' => 24,
			"\"" => 11,
			"{" => 45,
			'NOT' => 43,
			"(" => 14,
			'REF' => 15,
			"[" => 16,
			'LITERAL' => 109
		},
		GOTOS => {
			'term' => 55,
			'ident' => 108,
			'sterm' => 54,
			'expr' => 246,
			'item' => 72,
			'lterm' => 47,
			'node' => 46
		}
	},
	{#State 171
		ACTIONS => {
			'NOT' => 43,
			"{" => 45,
			"\$" => 17,
			"\"" => 11,
			"\${" => 33,
			'NUMBER' => 1,
			'LITERAL' => 109,
			"[" => 16,
			'IDENT' => 24,
			"(" => 14,
			'REF' => 15
		},
		GOTOS => {
			'expr' => 247,
			'ident' => 108,
			'term' => 55,
			'sterm' => 54,
			'item' => 72,
			'lterm' => 47,
			'node' => 46
		}
	},
	{#State 172
		ACTIONS => {
			'IDENT' => 84,
			'FILENAME' => 83,
			'LITERAL' => 77,
			"\"" => 81,
			'NUMBER' => 79,
			"\$" => 82
		},
		GOTOS => {
			'nameargs' => 248,
			'filename' => 80,
			'filepart' => 78,
			'name' => 85,
			'names' => 75
		}
	},
	{#State 173
		ACTIONS => {
			'UNLESS' => 27,
			'TRY' => 28,
			'MACRO' => 25,
			'FOR' => 23,
			'IDENT' => 24,
			'GET' => 22,
			'RAWPERL' => 20,
			'CALL' => 18,
			"\$" => 17,
			"[" => 16,
			'REF' => 15,
			'USE' => 12,
			"(" => 14,
			'THROW' => 10,
			"\"" => 11,
			'LAST' => 9,
			'FILTER' => 6,
			'PERL' => 4,
			'INCLUDE' => 5,
			'NUMBER' => 1,
			";" => -18,
			'VIEW' => 67,
			'INSERT' => 68,
			'DEBUG' => 66,
			'STOP' => 64,
			'SWITCH' => 62,
			'DEFAULT' => 60,
			'WHILE' => 59,
			'IF' => 57,
			'TEXT' => 56,
			'NEXT' => 53,
			'LITERAL' => 51,
			'PROCESS' => 48,
			'BLOCK' => 49,
			'NOT' => 43,
			"{" => 45,
			'RETURN' => 42,
			'WRAPPER' => 41,
			'META' => 38,
			'CLEAR' => 39,
			'SET' => 37,
			"\${" => 33
		},
		DEFAULT => -3,
		GOTOS => {
			'use' => 32,
			'condition' => 31,
			'capture' => 2,
			'ident' => 34,
			'atomdir' => 36,
			'anonblock' => 35,
			'switch' => 3,
			'chunks' => 8,
			'defblock' => 7,
			'wrapper' => 40,
			'expr' => 44,
			'lterm' => 47,
			'node' => 46,
			'setlist' => 13,
			'directive' => 52,
			'filter' => 50,
			'defblockname' => 19,
			'chunk' => 58,
			'sterm' => 54,
			'term' => 55,
			'statement' => 21,
			'perl' => 61,
			'loop' => 63,
			'view' => 65,
			'rawperl' => 26,
			'block' => 249,
			'assign' => 69,
			'macro' => 70,
			'atomexpr' => 73,
			'try' => 30,
			'item' => 72
		}
	},
	{#State 174
		ACTIONS => {
			'REF' => 15,
			"(" => 14,
			"[" => 16,
			'LITERAL' => 253,
			"\"" => 11,
			"{" => 45,
			'NOT' => 43,
			'IDENT' => 24,
			"\${" => 33,
			'NUMBER' => 1,
			'COMMA' => 251,
			"\$" => 17
		},
		DEFAULT => -164,
		GOTOS => {
			'expr' => 254,
			'term' => 55,
			'ident' => 252,
			'sterm' => 54,
			'lterm' => 47,
			'node' => 46,
			'param' => 250,
			'item' => 255
		}
	},
	{#State 175
		DEFAULT => -157,
		GOTOS => {
			'args' => 256
		}
	},
	{#State 176
		ACTIONS => {
			'NUMBER' => 79,
			"\"" => 81,
			'FILENAME' => 83,
			'IDENT' => 84,
			'LITERAL' => 77
		},
		GOTOS => {
			'name' => 257,
			'filename' => 80,
			'filepart' => 78
		}
	},
	{#State 177
		ACTIONS => {
			'NUMBER' => 79,
			'FILENAME' => 83,
			'IDENT' => 84
		},
		GOTOS => {
			'filepart' => 258
		}
	},
	{#State 178
		ACTIONS => {
			"\$" => 17,
			";" => 186,
			"\"" => 259,
			"\${" => 33,
			'TEXT' => 185,
			'IDENT' => 24
		},
		GOTOS => {
			'node' => 46,
			'quotable' => 187,
			'ident' => 184,
			'item' => 72
		}
	},
	{#State 179
		ACTIONS => {
			'DOT' => 129
		},
		DEFAULT => -157,
		GOTOS => {
			'args' => 260
		}
	},
	{#State 180
		ACTIONS => {
			'LITERAL' => 77,
			'FILENAME' => 83,
			'IDENT' => 84,
			"\$" => 82,
			'NUMBER' => 79,
			"\"" => 81
		},
		GOTOS => {
			'names' => 75,
			'name' => 85,
			'nameargs' => 261,
			'filepart' => 78,
			'filename' => 80
		}
	},
	{#State 181
		ACTIONS => {
			'MACRO' => 25,
			'TRY' => 28,
			'UNLESS' => 27,
			'RAWPERL' => 20,
			'GET' => 22,
			'FOR' => 23,
			'IDENT' => 24,
			"\$" => 17,
			'CALL' => 18,
			"(" => 14,
			'USE' => 12,
			'REF' => 15,
			"[" => 16,
			'LAST' => 9,
			"\"" => 11,
			'THROW' => 10,
			'INCLUDE' => 5,
			'PERL' => 4,
			'FILTER' => 6,
			";" => -18,
			'NUMBER' => 1,
			'INSERT' => 68,
			'VIEW' => 67,
			'SWITCH' => 62,
			'STOP' => 64,
			'DEBUG' => 66,
			'WHILE' => 59,
			'DEFAULT' => 60,
			'NEXT' => 53,
			'TEXT' => 56,
			'IF' => 57,
			'PROCESS' => 48,
			'BLOCK' => 49,
			'LITERAL' => 51,
			'NOT' => 43,
			"{" => 45,
			'SET' => 37,
			'CLEAR' => 39,
			'META' => 38,
			'RETURN' => 42,
			'WRAPPER' => 41,
			"\${" => 33
		},
		DEFAULT => -3,
		GOTOS => {
			'setlist' => 13,
			'node' => 46,
			'lterm' => 47,
			'filter' => 50,
			'directive' => 52,
			'expr' => 44,
			'switch' => 3,
			'atomdir' => 36,
			'anonblock' => 35,
			'wrapper' => 40,
			'chunks' => 8,
			'defblock' => 7,
			'condition' => 31,
			'use' => 32,
			'ident' => 34,
			'capture' => 2,
			'block' => 262,
			'assign' => 69,
			'macro' => 70,
			'try' => 30,
			'item' => 72,
			'atomexpr' => 73,
			'loop' => 63,
			'view' => 65,
			'rawperl' => 26,
			'statement' => 21,
			'perl' => 61,
			'sterm' => 54,
			'term' => 55,
			'defblockname' => 19,
			'chunk' => 58
		}
	},
	{#State 182
		ACTIONS => {
			'IDENT' => 24,
			'TEXT' => 185,
			"\${" => 33,
			"\"" => 263,
			"\$" => 17,
			";" => 186
		},
		GOTOS => {
			'item' => 72,
			'ident' => 184,
			'node' => 46,
			'quotable' => 187
		}
	},
	{#State 183
		ACTIONS => {
			'ASSIGN' => -133
		},
		DEFAULT => -131
	},
	{#State 184
		ACTIONS => {
			'DOT' => 129
		},
		DEFAULT => -178
	},
	{#State 185
		DEFAULT => -179
	},
	{#State 186
		DEFAULT => -180
	},
	{#State 187
		DEFAULT => -176
	},
	{#State 188
		DEFAULT => -112
	},
	{#State 189
		ACTIONS => {
			"\"" => 11,
			"{" => 45,
			'NOT' => 43,
			'REF' => 15,
			"(" => 14,
			"[" => 16,
			'LITERAL' => 109,
			'NUMBER' => 1,
			"\${" => 33,
			"\$" => 17,
			'IDENT' => 24
		},
		GOTOS => {
			'item' => 72,
			'node' => 46,
			'lterm' => 47,
			'expr' => 264,
			'sterm' => 54,
			'ident' => 108,
			'term' => 55
		}
	},
	{#State 190
		DEFAULT => -145
	},
	{#State 191
		DEFAULT => -146
	},
	{#State 192
		DEFAULT => -115
	},
	{#State 193
		DEFAULT => -116
	},
	{#State 194
		DEFAULT => -106
	},
	{#State 195
		DEFAULT => -107
	},
	{#State 196
		ACTIONS => {
			'IDENT' => 24,
			'LITERAL' => 109,
			"\"" => 11,
			'REF' => 15,
			"\${" => 33,
			'NUMBER' => 1,
			"\$" => 17
		},
		GOTOS => {
			'item' => 72,
			'ident' => 108,
			'sterm' => 265,
			'node' => 46
		}
	},
	{#State 197
		ACTIONS => {
			'MACRO' => 25,
			'TRY' => 28,
			'UNLESS' => 27,
			'CALL' => 18,
			"\$" => 17,
			'GET' => 22,
			'FOR' => 23,
			'IDENT' => 24,
			'RAWPERL' => 20,
			'LAST' => 9,
			"\"" => 11,
			'THROW' => 10,
			"[" => 16,
			"(" => 14,
			'USE' => 12,
			'REF' => 15,
			";" => -18,
			'NUMBER' => 1,
			'FILTER' => 6,
			'INCLUDE' => 5,
			'PERL' => 4,
			'DEBUG' => 66,
			'SWITCH' => 62,
			'STOP' => 64,
			'INSERT' => 68,
			'VIEW' => 67,
			'TEXT' => 56,
			'IF' => 57,
			'NEXT' => 53,
			'DEFAULT' => 60,
			'WHILE' => 59,
			'NOT' => 43,
			"{" => 45,
			'LITERAL' => 51,
			'BLOCK' => 49,
			'PROCESS' => 48,
			"\${" => 33,
			'CLEAR' => 39,
			'META' => 38,
			'RETURN' => 42,
			'WRAPPER' => 41,
			'SET' => 37
		},
		DEFAULT => -3,
		GOTOS => {
			'defblockname' => 19,
			'chunk' => 58,
			'sterm' => 54,
			'term' => 55,
			'perl' => 61,
			'statement' => 21,
			'view' => 65,
			'rawperl' => 26,
			'loop' => 63,
			'atomexpr' => 73,
			'try' => 30,
			'item' => 72,
			'template' => 266,
			'block' => 29,
			'macro' => 70,
			'assign' => 69,
			'capture' => 2,
			'ident' => 34,
			'use' => 32,
			'condition' => 31,
			'chunks' => 8,
			'defblock' => 7,
			'wrapper' => 40,
			'atomdir' => 36,
			'anonblock' => 35,
			'switch' => 3,
			'expr' => 44,
			'directive' => 52,
			'filter' => 50,
			'node' => 46,
			'lterm' => 47,
			'setlist' => 13
		}
	},
	{#State 198
		ACTIONS => {
			"\"" => 269,
			'NUMBER' => 268,
			'LITERAL' => 267
		}
	},
	{#State 199
		DEFAULT => -99
	},
	{#State 200
		DEFAULT => -98
	},
	{#State 201
		ACTIONS => {
			'TEXT' => 270
		}
	},
	{#State 202
		DEFAULT => -56,
		GOTOS => {
			'@1-3' => 271
		}
	},
	{#State 203
		ACTIONS => {
			"\"" => 11,
			'NUMBER' => 1,
			"\${" => 33,
			"\$" => 17,
			"{" => 45,
			'REF' => 15,
			'IDENT' => 24,
			"[" => 16,
			'LITERAL' => 109
		},
		GOTOS => {
			'term' => 272,
			'sterm' => 54,
			'ident' => 108,
			'node' => 46,
			'lterm' => 47,
			'item' => 72
		}
	},
	{#State 204
		ACTIONS => {
			"\$" => 17,
			"\"" => 11,
			"\${" => 33,
			'NUMBER' => 1,
			"{" => 45,
			'REF' => 15,
			'LITERAL' => 109,
			"[" => 16,
			'IDENT' => 24
		},
		GOTOS => {
			'item' => 72,
			'node' => 46,
			'lterm' => 47,
			'term' => 273,
			'ident' => 108,
			'sterm' => 54
		}
	},
	{#State 205
		ACTIONS => {
			'IDENT' => 24,
			'NUMBER' => 1,
			"\${" => 33,
			'COMMA' => 251,
			"\$" => 17,
			'REF' => 15,
			"(" => 14,
			'LITERAL' => 253,
			"[" => 16,
			"\"" => 11,
			"{" => 45,
			'NOT' => 43
		},
		DEFAULT => -64,
		GOTOS => {
			'ident' => 252,
			'sterm' => 54,
			'term' => 55,
			'expr' => 254,
			'item' => 255,
			'param' => 250,
			'lterm' => 47,
			'node' => 46
		}
	},
	{#State 206
		ACTIONS => {
			"(" => 14,
			'REF' => 15,
			'LITERAL' => 51,
			"[" => 16,
			"\"" => 11,
			'NOT' => 43,
			"{" => 45,
			'IDENT' => 275,
			"\$" => 17,
			"\${" => 33,
			'NUMBER' => 1
		},
		GOTOS => {
			'expr' => 103,
			'sterm' => 54,
			'ident' => 104,
			'term' => 55,
			'assign' => 102,
			'node' => 46,
			'lterm' => 47,
			'item' => 72,
			'margs' => 274
		}
	},
	{#State 207
		DEFAULT => -92
	},
	{#State 208
		ACTIONS => {
			"\${" => 33,
			"\$" => 17,
			'IDENT' => 24,
			'LITERAL' => 100
		},
		GOTOS => {
			'item' => 72,
			'ident' => 99,
			'setlist' => 131,
			'assign' => 69,
			'node' => 46
		}
	},
	{#State 209
		ACTIONS => {
			'MOD' => 137,
			'DIV' => 144,
			'OR' => 140,
			"+" => 142,
			"/" => 136,
			'CAT' => 145,
			'BINOP' => 139,
			'CMPOP' => 143,
			"?" => 141,
			'AND' => 138
		},
		DEFAULT => -26
	},
	{#State 210
		ACTIONS => {
			";" => 276
		}
	},
	{#State 211
		DEFAULT => -93
	},
	{#State 212
		ACTIONS => {
			'TRY' => 28,
			'UNLESS' => 27,
			'MACRO' => 25,
			'CALL' => 18,
			"\$" => 17,
			'IDENT' => 24,
			'FOR' => 23,
			'GET' => 22,
			'RAWPERL' => 20,
			"\"" => 11,
			'THROW' => 10,
			'LAST' => 9,
			"[" => 16,
			'REF' => 15,
			"(" => 14,
			'USE' => 12,
			'NUMBER' => 1,
			";" => -18,
			'FILTER' => 6,
			'INCLUDE' => 5,
			'PERL' => 4,
			'DEBUG' => 66,
			'STOP' => 64,
			'SWITCH' => 62,
			'INSERT' => 68,
			'VIEW' => 67,
			'IF' => 57,
			'TEXT' => 56,
			'NEXT' => 53,
			'DEFAULT' => 60,
			'WHILE' => 59,
			'NOT' => 43,
			"{" => 45,
			'LITERAL' => 51,
			'PROCESS' => 48,
			'BLOCK' => 49,
			"\${" => 33,
			'WRAPPER' => 41,
			'RETURN' => 42,
			'CLEAR' => 39,
			'META' => 38,
			'SET' => 37
		},
		DEFAULT => -3,
		GOTOS => {
			'atomexpr' => 73,
			'item' => 72,
			'try' => 30,
			'macro' => 70,
			'assign' => 69,
			'block' => 277,
			'view' => 65,
			'rawperl' => 26,
			'loop' => 63,
			'perl' => 61,
			'statement' => 21,
			'defblockname' => 19,
			'chunk' => 58,
			'term' => 55,
			'sterm' => 54,
			'directive' => 52,
			'filter' => 50,
			'lterm' => 47,
			'node' => 46,
			'setlist' => 13,
			'expr' => 44,
			'chunks' => 8,
			'defblock' => 7,
			'wrapper' => 40,
			'atomdir' => 36,
			'anonblock' => 35,
			'switch' => 3,
			'capture' => 2,
			'ident' => 34,
			'use' => 32,
			'condition' => 31
		}
	},
	{#State 213
		ACTIONS => {
			'FINAL' => 279,
			'CATCH' => 280
		},
		DEFAULT => -72,
		GOTOS => {
			'final' => 278
		}
	},
	{#State 214
		DEFAULT => -132
	},
	{#State 215
		DEFAULT => -126
	},
	{#State 216
		DEFAULT => -127
	},
	{#State 217
		ACTIONS => {
			";" => -151,
			"\${" => -151,
			'DIV' => 144,
			'OR' => 140,
			'CAT' => 145,
			"?" => 141,
			'LITERAL' => -151,
			'MOD' => 137,
			"\$" => -151,
			'COMMA' => -151,
			'IDENT' => -151,
			"+" => 142,
			"/" => 136,
			'BINOP' => 139,
			'CMPOP' => 143,
			'AND' => 138
		},
		DEFAULT => -26
	},
	{#State 218
		DEFAULT => -89
	},
	{#State 219
		ACTIONS => {
			'NUMBER' => 1,
			"\${" => 33,
			'FILTER' => 6,
			'RETURN' => 42,
			'WRAPPER' => 41,
			'CLEAR' => 39,
			'PERL' => 4,
			'INCLUDE' => 5,
			'SET' => 208,
			'NOT' => 43,
			"{" => 45,
			'THROW' => 10,
			"\"" => 11,
			'LAST' => 9,
			"[" => 16,
			'LITERAL' => 51,
			'REF' => 15,
			'PROCESS' => 48,
			'BLOCK' => 210,
			"(" => 14,
			'IF' => 57,
			'CALL' => 18,
			'NEXT' => 53,
			"\$" => 17,
			'IDENT' => 24,
			'FOR' => 23,
			'DEFAULT' => 60,
			'GET' => 22,
			'WHILE' => 59,
			'UNLESS' => 27,
			'TRY' => 28,
			'DEBUG' => 66,
			'STOP' => 64,
			'SWITCH' => 62,
			'INSERT' => 68
		},
		GOTOS => {
			'condition' => 31,
			'ident' => 104,
			'term' => 55,
			'sterm' => 54,
			'switch' => 3,
			'mdir' => 281,
			'atomdir' => 36,
			'wrapper' => 40,
			'perl' => 61,
			'loop' => 63,
			'expr' => 217,
			'setlist' => 13,
			'assign' => 69,
			'node' => 46,
			'lterm' => 47,
			'item' => 72,
			'try' => 30,
			'filter' => 50,
			'directive' => 211,
			'atomexpr' => 73
		}
	},
	{#State 220
		ACTIONS => {
			'MACRO' => 25,
			'TRY' => 28,
			'UNLESS' => 27,
			"\$" => 17,
			'CALL' => 18,
			'RAWPERL' => 20,
			'GET' => 22,
			'FOR' => 23,
			'IDENT' => 24,
			'LAST' => 9,
			'THROW' => 10,
			"\"" => 11,
			"(" => 14,
			'USE' => 12,
			'REF' => 15,
			"[" => 16,
			";" => -18,
			'NUMBER' => 1,
			'INCLUDE' => 5,
			'PERL' => 4,
			'FILTER' => 6,
			'SWITCH' => 62,
			'STOP' => 64,
			'DEBUG' => 66,
			'INSERT' => 68,
			'VIEW' => 67,
			'NEXT' => 53,
			'TEXT' => 56,
			'IF' => 57,
			'WHILE' => 59,
			'DEFAULT' => 60,
			'NOT' => 43,
			"{" => 45,
			'BLOCK' => 49,
			'PROCESS' => 48,
			'LITERAL' => 51,
			"\${" => 33,
			'SET' => 37,
			'CLEAR' => 39,
			'META' => 38,
			'WRAPPER' => 41,
			'RETURN' => 42
		},
		DEFAULT => -3,
		GOTOS => {
			'expr' => 44,
			'filter' => 50,
			'directive' => 52,
			'setlist' => 13,
			'lterm' => 47,
			'node' => 46,
			'ident' => 34,
			'capture' => 2,
			'condition' => 31,
			'use' => 32,
			'wrapper' => 40,
			'chunks' => 8,
			'defblock' => 7,
			'switch' => 3,
			'atomdir' => 36,
			'anonblock' => 35,
			'view' => 65,
			'rawperl' => 26,
			'loop' => 63,
			'item' => 72,
			'try' => 30,
			'atomexpr' => 73,
			'macro' => 70,
			'block' => 282,
			'assign' => 69,
			'term' => 55,
			'sterm' => 54,
			'defblockname' => 19,
			'chunk' => 58,
			'perl' => 61,
			'statement' => 21
		}
	},
	{#State 221
		ACTIONS => {
			'MOD' => 137,
			'DIV' => 144
		},
		DEFAULT => -135
	},
	{#State 222
		DEFAULT => -138
	},
	{#State 223
		ACTIONS => {
			'MOD' => 137,
			"/" => 136,
			"+" => 142,
			'CMPOP' => 143,
			'BINOP' => 139,
			'DIV' => 144,
			'CAT' => 145
		},
		DEFAULT => -141
	},
	{#State 224
		ACTIONS => {
			'MOD' => 137,
			"+" => 142,
			"/" => 136,
			'DIV' => 144
		},
		DEFAULT => -134
	},
	{#State 225
		ACTIONS => {
			'BINOP' => 139,
			'CMPOP' => 143,
			"+" => 142,
			"/" => 136,
			'MOD' => 137,
			'CAT' => 145,
			'DIV' => 144
		},
		DEFAULT => -142
	},
	{#State 226
		ACTIONS => {
			'OR' => 140,
			"+" => 142,
			"/" => 136,
			'MOD' => 137,
			'DIV' => 144,
			'BINOP' => 139,
			":" => 283,
			'CAT' => 145,
			'CMPOP' => 143,
			'AND' => 138,
			"?" => 141
		}
	},
	{#State 227
		ACTIONS => {
			'DIV' => 144,
			"/" => 136,
			'MOD' => 137
		},
		DEFAULT => -136
	},
	{#State 228
		ACTIONS => {
			'MOD' => 137,
			"/" => 136,
			"+" => 142,
			'BINOP' => 139,
			'DIV' => 144
		},
		DEFAULT => -139
	},
	{#State 229
		ACTIONS => {
			'MOD' => 137
		},
		DEFAULT => -137
	},
	{#State 230
		ACTIONS => {
			'DIV' => 144,
			'CMPOP' => 143,
			'BINOP' => 139,
			"/" => 136,
			"+" => 142,
			'MOD' => 137
		},
		DEFAULT => -140
	},
	{#State 231
		DEFAULT => -109
	},
	{#State 232
		ACTIONS => {
			"\"" => 11,
			"{" => 45,
			'NOT' => 43,
			"(" => 14,
			'REF' => 15,
			'LITERAL' => 109,
			"[" => 16,
			"\$" => 17,
			"\${" => 33,
			'NUMBER' => 1,
			'IDENT' => 24
		},
		GOTOS => {
			'item' => 72,
			'node' => 46,
			'lterm' => 47,
			'sterm' => 54,
			'ident' => 108,
			'term' => 55,
			'expr' => 284
		}
	},
	{#State 233
		ACTIONS => {
			'LITERAL' => 109,
			"[" => 16,
			"(" => 14,
			'REF' => 15,
			"{" => 45,
			'NOT' => 43,
			"\"" => 11,
			'IDENT' => 24,
			"\$" => 17,
			"\${" => 33,
			'NUMBER' => 1
		},
		GOTOS => {
			'expr' => 285,
			'term' => 55,
			'sterm' => 54,
			'ident' => 108,
			'lterm' => 47,
			'node' => 46,
			'item' => 72
		}
	},
	{#State 234
		DEFAULT => -122
	},
	{#State 235
		DEFAULT => -121
	},
	{#State 236
		ACTIONS => {
			'RETURN' => 42,
			'WRAPPER' => 41,
			'META' => 38,
			'CLEAR' => 39,
			'SET' => 37,
			"\${" => 33,
			'LITERAL' => 51,
			'PROCESS' => 48,
			'BLOCK' => 49,
			'NOT' => 43,
			"{" => 45,
			'DEFAULT' => 60,
			'WHILE' => 59,
			'IF' => 57,
			'TEXT' => 56,
			'NEXT' => 53,
			'VIEW' => 67,
			'INSERT' => 68,
			'DEBUG' => 66,
			'STOP' => 64,
			'SWITCH' => 62,
			'FILTER' => 6,
			'PERL' => 4,
			'INCLUDE' => 5,
			'NUMBER' => 1,
			";" => -18,
			"[" => 16,
			'REF' => 15,
			'USE' => 12,
			"(" => 14,
			'THROW' => 10,
			"\"" => 11,
			'LAST' => 9,
			'IDENT' => 24,
			'FOR' => 23,
			'GET' => 22,
			'RAWPERL' => 20,
			'CALL' => 18,
			"\$" => 17,
			'UNLESS' => 27,
			'TRY' => 28,
			'MACRO' => 25
		},
		DEFAULT => -3,
		GOTOS => {
			'defblockname' => 19,
			'chunk' => 58,
			'term' => 55,
			'sterm' => 54,
			'statement' => 21,
			'perl' => 61,
			'loop' => 63,
			'view' => 65,
			'rawperl' => 26,
			'assign' => 69,
			'block' => 286,
			'macro' => 70,
			'atomexpr' => 73,
			'item' => 72,
			'try' => 30,
			'use' => 32,
			'condition' => 31,
			'capture' => 2,
			'ident' => 34,
			'atomdir' => 36,
			'anonblock' => 35,
			'switch' => 3,
			'chunks' => 8,
			'defblock' => 7,
			'wrapper' => 40,
			'expr' => 44,
			'node' => 46,
			'lterm' => 47,
			'setlist' => 13,
			'directive' => 52,
			'filter' => 50
		}
	},
	{#State 237
		ACTIONS => {
			'MOD' => 137,
			"+" => 142,
			"/" => 136,
			'AND' => 138,
			'BINOP' => 139,
			'CMPOP' => 143,
			'DIV' => 144,
			'OR' => 140,
			"?" => 141,
			'CAT' => 145
		},
		DEFAULT => -152
	},
	{#State 238
		ACTIONS => {
			'REF' => 15,
			"(" => 14,
			'USE' => 12,
			"[" => 16,
			'THROW' => 10,
			"\"" => 11,
			'LAST' => 9,
			'INCLUDE' => 5,
			'PERL' => 4,
			'FILTER' => 6,
			'NUMBER' => 1,
			";" => -18,
			'TRY' => 28,
			'UNLESS' => 27,
			'MACRO' => 25,
			'RAWPERL' => 20,
			'FOR' => 23,
			'IDENT' => 24,
			'GET' => 22,
			"\$" => 17,
			'CALL' => 18,
			'PROCESS' => 48,
			'BLOCK' => 49,
			'LITERAL' => 51,
			"{" => 45,
			'NOT' => 43,
			'SET' => 37,
			'RETURN' => 42,
			'WRAPPER' => 41,
			'CLEAR' => 39,
			'META' => 38,
			"\${" => 33,
			'INSERT' => 68,
			'VIEW' => 67,
			'STOP' => 64,
			'SWITCH' => 62,
			'DEBUG' => 66,
			'WHILE' => 59,
			'DEFAULT' => 60,
			'NEXT' => 53,
			'IF' => 57,
			'TEXT' => 56
		},
		DEFAULT => -3,
		GOTOS => {
			'loop' => 63,
			'view' => 65,
			'rawperl' => 26,
			'block' => 287,
			'assign' => 69,
			'macro' => 70,
			'atomexpr' => 73,
			'item' => 72,
			'try' => 30,
			'defblockname' => 19,
			'chunk' => 58,
			'sterm' => 54,
			'term' => 55,
			'statement' => 21,
			'perl' => 61,
			'expr' => 44,
			'node' => 46,
			'lterm' => 47,
			'setlist' => 13,
			'directive' => 52,
			'filter' => 50,
			'use' => 32,
			'condition' => 31,
			'capture' => 2,
			'ident' => 34,
			'atomdir' => 36,
			'anonblock' => 35,
			'switch' => 3,
			'chunks' => 8,
			'defblock' => 7,
			'wrapper' => 40
		}
	},
	{#State 239
		DEFAULT => -59,
		GOTOS => {
			'@2-3' => 288
		}
	},
	{#State 240
		ACTIONS => {
			'LAST' => 9,
			"\"" => 11,
			'THROW' => 10,
			"[" => 16,
			'USE' => 12,
			"(" => 14,
			'REF' => 15,
			";" => -18,
			'NUMBER' => 1,
			'FILTER' => 6,
			'PERL' => 4,
			'INCLUDE' => 5,
			'MACRO' => 25,
			'UNLESS' => 27,
			'TRY' => 28,
			'CALL' => 18,
			"\$" => 17,
			'GET' => 22,
			'FOR' => 23,
			'IDENT' => 24,
			'RAWPERL' => 20,
			"{" => 45,
			'NOT' => 43,
			'LITERAL' => 51,
			'PROCESS' => 48,
			'BLOCK' => 49,
			"\${" => 33,
			'META' => 38,
			'CLEAR' => 39,
			'RETURN' => 42,
			'WRAPPER' => 41,
			'SET' => 37,
			'DEBUG' => 66,
			'SWITCH' => 62,
			'STOP' => 64,
			'VIEW' => 67,
			'INSERT' => 68,
			'TEXT' => 56,
			'IF' => 57,
			'NEXT' => 53,
			'DEFAULT' => 60,
			'WHILE' => 59
		},
		DEFAULT => -3,
		GOTOS => {
			'rawperl' => 26,
			'view' => 65,
			'loop' => 63,
			'try' => 30,
			'item' => 72,
			'atomexpr' => 73,
			'macro' => 70,
			'assign' => 69,
			'block' => 289,
			'sterm' => 54,
			'term' => 55,
			'chunk' => 58,
			'defblockname' => 19,
			'perl' => 61,
			'statement' => 21,
			'expr' => 44,
			'filter' => 50,
			'directive' => 52,
			'setlist' => 13,
			'node' => 46,
			'lterm' => 47,
			'ident' => 34,
			'capture' => 2,
			'condition' => 31,
			'use' => 32,
			'wrapper' => 40,
			'defblock' => 7,
			'chunks' => 8,
			'switch' => 3,
			'anonblock' => 35,
			'atomdir' => 36
		}
	},
	{#State 241
		DEFAULT => -74,
		GOTOS => {
			'@3-3' => 290
		}
	},
	{#State 242
		ACTIONS => {
			"\"" => 11,
			")" => 291,
			"{" => 45,
			'NOT' => 43,
			"(" => 14,
			'REF' => 15,
			"[" => 16,
			'LITERAL' => 253,
			"\$" => 17,
			"\${" => 33,
			'NUMBER' => 1,
			'COMMA' => 251,
			'IDENT' => 24
		},
		GOTOS => {
			'lterm' => 47,
			'node' => 46,
			'item' => 255,
			'param' => 250,
			'ident' => 252,
			'sterm' => 54,
			'term' => 55,
			'expr' => 254
		}
	},
	{#State 243
		DEFAULT => -58
	},
	{#State 244
		ACTIONS => {
			'OR' => 140,
			"/" => 136,
			"+" => 142,
			'CMPOP' => 143,
			'MOD' => 137,
			'BINOP' => 139,
			'CAT' => 145,
			'DIV' => 144,
			'AND' => 138,
			"?" => 141
		},
		DEFAULT => -47
	},
	{#State 245
		DEFAULT => -81
	},
	{#State 246
		ACTIONS => {
			'AND' => 138,
			"?" => 141,
			'CMPOP' => 143,
			'BINOP' => 139,
			'CAT' => 145,
			"/" => 136,
			"+" => 142,
			'OR' => 140,
			'DIV' => 144,
			'MOD' => 137
		},
		DEFAULT => -45
	},
	{#State 247
		ACTIONS => {
			"/" => 136,
			"+" => 142,
			'OR' => 140,
			'DIV' => 144,
			"?" => 141,
			'AND' => 138,
			'CMPOP' => 143,
			'MOD' => 137,
			'BINOP' => 139,
			'CAT' => 145
		},
		DEFAULT => -61
	},
	{#State 248
		DEFAULT => -66
	},
	{#State 249
		ACTIONS => {
			'END' => 292
		}
	},
	{#State 250
		DEFAULT => -154
	},
	{#State 251
		DEFAULT => -156
	},
	{#State 252
		ACTIONS => {
			'ASSIGN' => 293,
			'DOT' => 129
		},
		DEFAULT => -110
	},
	{#State 253
		ACTIONS => {
			'ASSIGN' => 233
		},
		DEFAULT => -113
	},
	{#State 254
		ACTIONS => {
			'OR' => 140,
			'DIV' => 144,
			"?" => 141,
			'CAT' => 145,
			"+" => 142,
			"/" => 136,
			'MOD' => 137,
			'AND' => 138,
			'BINOP' => 139,
			'CMPOP' => 143
		},
		DEFAULT => -153
	},
	{#State 255
		ACTIONS => {
			"(" => 166,
			'ASSIGN' => 232
		},
		DEFAULT => -129
	},
	{#State 256
		ACTIONS => {
			"\$" => 17,
			'NUMBER' => 1,
			"\${" => 33,
			'COMMA' => 251,
			'IDENT' => 24,
			"\"" => 11,
			")" => 294,
			'NOT' => 43,
			"{" => 45,
			"(" => 14,
			'REF' => 15,
			"[" => 16,
			'LITERAL' => 253
		},
		GOTOS => {
			'sterm' => 54,
			'ident' => 252,
			'term' => 55,
			'expr' => 254,
			'lterm' => 47,
			'node' => 46,
			'item' => 255,
			'param' => 250
		}
	},
	{#State 257
		DEFAULT => -166
	},
	{#State 258
		DEFAULT => -171
	},
	{#State 259
		DEFAULT => -168
	},
	{#State 260
		ACTIONS => {
			'IDENT' => 24,
			"\${" => 33,
			'NUMBER' => 1,
			'COMMA' => 251,
			"\$" => 17,
			"[" => 16,
			'LITERAL' => 253,
			'REF' => 15,
			"(" => 14,
			"{" => 45,
			'NOT' => 43,
			"\"" => 11
		},
		DEFAULT => -163,
		GOTOS => {
			'expr' => 254,
			'ident' => 252,
			'term' => 55,
			'sterm' => 54,
			'param' => 250,
			'item' => 255,
			'node' => 46,
			'lterm' => 47
		}
	},
	{#State 261
		DEFAULT => -158
	},
	{#State 262
		ACTIONS => {
			'END' => 295
		}
	},
	{#State 263
		ACTIONS => {
			'ASSIGN' => -161
		},
		DEFAULT => -168
	},
	{#State 264
		ACTIONS => {
			"/" => 136,
			"+" => 142,
			'MOD' => 137,
			'AND' => 138,
			'CMPOP' => 143,
			'BINOP' => 139,
			'OR' => 140,
			'DIV' => 144,
			"?" => 141,
			'CAT' => 145
		},
		DEFAULT => -151
	},
	{#State 265
		DEFAULT => -118
	},
	{#State 266
		ACTIONS => {
			'END' => 296
		}
	},
	{#State 267
		DEFAULT => -101
	},
	{#State 268
		DEFAULT => -103
	},
	{#State 269
		ACTIONS => {
			'TEXT' => 297
		}
	},
	{#State 270
		ACTIONS => {
			'END' => 298
		}
	},
	{#State 271
		ACTIONS => {
			'RETURN' => 42,
			'WRAPPER' => 41,
			'META' => 38,
			'CLEAR' => 39,
			'SET' => 37,
			"\${" => 33,
			'LITERAL' => 51,
			'BLOCK' => 49,
			'PROCESS' => 48,
			"{" => 45,
			'NOT' => 43,
			'DEFAULT' => 60,
			'WHILE' => 59,
			'IF' => 57,
			'TEXT' => 56,
			'NEXT' => 53,
			'VIEW' => 67,
			'INSERT' => 68,
			'DEBUG' => 66,
			'STOP' => 64,
			'SWITCH' => 62,
			'FILTER' => 6,
			'PERL' => 4,
			'INCLUDE' => 5,
			'NUMBER' => 1,
			";" => -18,
			"[" => 16,
			'REF' => 15,
			'USE' => 12,
			"(" => 14,
			"\"" => 11,
			'THROW' => 10,
			'LAST' => 9,
			'IDENT' => 24,
			'FOR' => 23,
			'GET' => 22,
			'RAWPERL' => 20,
			'CALL' => 18,
			"\$" => 17,
			'UNLESS' => 27,
			'TRY' => 28,
			'MACRO' => 25
		},
		DEFAULT => -3,
		GOTOS => {
			'loop' => 63,
			'rawperl' => 26,
			'view' => 65,
			'assign' => 69,
			'block' => 299,
			'macro' => 70,
			'atomexpr' => 73,
			'try' => 30,
			'item' => 72,
			'chunk' => 58,
			'defblockname' => 19,
			'term' => 55,
			'sterm' => 54,
			'statement' => 21,
			'perl' => 61,
			'expr' => 44,
			'lterm' => 47,
			'node' => 46,
			'setlist' => 13,
			'directive' => 52,
			'filter' => 50,
			'use' => 32,
			'condition' => 31,
			'capture' => 2,
			'ident' => 34,
			'anonblock' => 35,
			'atomdir' => 36,
			'switch' => 3,
			'defblock' => 7,
			'chunks' => 8,
			'wrapper' => 40
		}
	},
	{#State 272
		DEFAULT => -157,
		GOTOS => {
			'args' => 300
		}
	},
	{#State 273
		DEFAULT => -157,
		GOTOS => {
			'args' => 301
		}
	},
	{#State 274
		ACTIONS => {
			")" => 304,
			'IDENT' => 302,
			'COMMA' => 303
		}
	},
	{#State 275
		ACTIONS => {
			'COMMA' => -97,
			'IDENT' => -97,
			")" => -97
		},
		DEFAULT => -131
	},
	{#State 276
		ACTIONS => {
			"\${" => 33,
			'META' => 38,
			'CLEAR' => 39,
			'WRAPPER' => 41,
			'RETURN' => 42,
			'SET' => 37,
			"{" => 45,
			'NOT' => 43,
			'LITERAL' => 51,
			'PROCESS' => 48,
			'BLOCK' => 49,
			'TEXT' => 56,
			'IF' => 57,
			'NEXT' => 53,
			'DEFAULT' => 60,
			'WHILE' => 59,
			'DEBUG' => 66,
			'SWITCH' => 62,
			'STOP' => 64,
			'VIEW' => 67,
			'INSERT' => 68,
			";" => -18,
			'NUMBER' => 1,
			'FILTER' => 6,
			'PERL' => 4,
			'INCLUDE' => 5,
			'LAST' => 9,
			"\"" => 11,
			'THROW' => 10,
			"[" => 16,
			'USE' => 12,
			"(" => 14,
			'REF' => 15,
			'CALL' => 18,
			"\$" => 17,
			'GET' => 22,
			'FOR' => 23,
			'IDENT' => 24,
			'RAWPERL' => 20,
			'MACRO' => 25,
			'UNLESS' => 27,
			'TRY' => 28
		},
		DEFAULT => -3,
		GOTOS => {
			'condition' => 31,
			'use' => 32,
			'ident' => 34,
			'capture' => 2,
			'switch' => 3,
			'anonblock' => 35,
			'atomdir' => 36,
			'wrapper' => 40,
			'defblock' => 7,
			'chunks' => 8,
			'expr' => 44,
			'setlist' => 13,
			'lterm' => 47,
			'node' => 46,
			'filter' => 50,
			'directive' => 52,
			'sterm' => 54,
			'term' => 55,
			'chunk' => 58,
			'defblockname' => 19,
			'statement' => 21,
			'perl' => 61,
			'loop' => 63,
			'rawperl' => 26,
			'view' => 65,
			'macro' => 70,
			'block' => 305,
			'assign' => 69,
			'item' => 72,
			'try' => 30,
			'atomexpr' => 73
		}
	},
	{#State 277
		ACTIONS => {
			'ELSE' => 306,
			'ELSIF' => 308
		},
		DEFAULT => -50,
		GOTOS => {
			'else' => 307
		}
	},
	{#State 278
		ACTIONS => {
			'END' => 309
		}
	},
	{#State 279
		ACTIONS => {
			";" => 310
		}
	},
	{#State 280
		ACTIONS => {
			'NUMBER' => 79,
			";" => 312,
			'FILENAME' => 83,
			'IDENT' => 84,
			'DEFAULT' => 313
		},
		GOTOS => {
			'filename' => 311,
			'filepart' => 78
		}
	},
	{#State 281
		DEFAULT => -90
	},
	{#State 282
		ACTIONS => {
			'END' => 314
		}
	},
	{#State 283
		ACTIONS => {
			'IDENT' => 24,
			"\${" => 33,
			'NUMBER' => 1,
			"\$" => 17,
			"[" => 16,
			'LITERAL' => 109,
			'REF' => 15,
			"(" => 14,
			"{" => 45,
			'NOT' => 43,
			"\"" => 11
		},
		GOTOS => {
			'item' => 72,
			'node' => 46,
			'lterm' => 47,
			'sterm' => 54,
			'ident' => 108,
			'term' => 55,
			'expr' => 315
		}
	},
	{#State 284
		ACTIONS => {
			'AND' => 138,
			'BINOP' => 139,
			'CMPOP' => 143,
			'MOD' => 137,
			"+" => 142,
			"/" => 136,
			"?" => 141,
			'CAT' => 145,
			'DIV' => 144,
			'OR' => 140
		},
		DEFAULT => -125
	},
	{#State 285
		ACTIONS => {
			'CAT' => 145,
			"?" => 141,
			'OR' => 140,
			'DIV' => 144,
			'BINOP' => 139,
			'CMPOP' => 143,
			'AND' => 138,
			"+" => 142,
			"/" => 136,
			'MOD' => 137
		},
		DEFAULT => -124
	},
	{#State 286
		ACTIONS => {
			'END' => 316
		}
	},
	{#State 287
		ACTIONS => {
			'ELSE' => 306,
			'ELSIF' => 308
		},
		DEFAULT => -50,
		GOTOS => {
			'else' => 317
		}
	},
	{#State 288
		ACTIONS => {
			"\"" => 11,
			'THROW' => 10,
			'LAST' => 9,
			"[" => 16,
			'REF' => 15,
			'USE' => 12,
			"(" => 14,
			'NUMBER' => 1,
			";" => -18,
			'FILTER' => 6,
			'PERL' => 4,
			'INCLUDE' => 5,
			'UNLESS' => 27,
			'TRY' => 28,
			'MACRO' => 25,
			'CALL' => 18,
			"\$" => 17,
			'IDENT' => 24,
			'FOR' => 23,
			'GET' => 22,
			'RAWPERL' => 20,
			"{" => 45,
			'NOT' => 43,
			'LITERAL' => 51,
			'BLOCK' => 49,
			'PROCESS' => 48,
			"\${" => 33,
			'WRAPPER' => 41,
			'RETURN' => 42,
			'META' => 38,
			'CLEAR' => 39,
			'SET' => 37,
			'DEBUG' => 66,
			'STOP' => 64,
			'SWITCH' => 62,
			'VIEW' => 67,
			'INSERT' => 68,
			'IF' => 57,
			'TEXT' => 56,
			'NEXT' => 53,
			'DEFAULT' => 60,
			'WHILE' => 59
		},
		DEFAULT => -3,
		GOTOS => {
			'directive' => 52,
			'filter' => 50,
			'lterm' => 47,
			'node' => 46,
			'setlist' => 13,
			'expr' => 44,
			'chunks' => 8,
			'defblock' => 7,
			'wrapper' => 40,
			'atomdir' => 36,
			'anonblock' => 35,
			'switch' => 3,
			'capture' => 2,
			'ident' => 34,
			'use' => 32,
			'condition' => 31,
			'atomexpr' => 73,
			'try' => 30,
			'item' => 72,
			'block' => 318,
			'macro' => 70,
			'assign' => 69,
			'view' => 65,
			'rawperl' => 26,
			'loop' => 63,
			'perl' => 61,
			'statement' => 21,
			'defblockname' => 19,
			'chunk' => 58,
			'term' => 55,
			'sterm' => 54
		}
	},
	{#State 289
		ACTIONS => {
			'CASE' => 319
		},
		DEFAULT => -55,
		GOTOS => {
			'case' => 320
		}
	},
	{#State 290
		ACTIONS => {
			'MACRO' => 25,
			'TRY' => 28,
			'UNLESS' => 27,
			'GET' => 22,
			'IDENT' => 24,
			'FOR' => 23,
			'RAWPERL' => 20,
			'CALL' => 18,
			"\$" => 17,
			"[" => 16,
			"(" => 14,
			'USE' => 12,
			'REF' => 15,
			'LAST' => 9,
			'THROW' => 10,
			"\"" => 11,
			'FILTER' => 6,
			'INCLUDE' => 5,
			'PERL' => 4,
			";" => -18,
			'NUMBER' => 1,
			'INSERT' => 68,
			'VIEW' => 67,
			'DEBUG' => 66,
			'SWITCH' => 62,
			'STOP' => 64,
			'DEFAULT' => 60,
			'WHILE' => 59,
			'TEXT' => 56,
			'IF' => 57,
			'NEXT' => 53,
			'LITERAL' => 51,
			'PROCESS' => 48,
			'BLOCK' => 49,
			'NOT' => 43,
			"{" => 45,
			'CLEAR' => 39,
			'META' => 38,
			'WRAPPER' => 41,
			'RETURN' => 42,
			'SET' => 37,
			"\${" => 33
		},
		DEFAULT => -3,
		GOTOS => {
			'loop' => 63,
			'view' => 65,
			'rawperl' => 26,
			'macro' => 70,
			'block' => 321,
			'assign' => 69,
			'try' => 30,
			'item' => 72,
			'atomexpr' => 73,
			'term' => 55,
			'sterm' => 54,
			'defblockname' => 19,
			'chunk' => 58,
			'statement' => 21,
			'perl' => 61,
			'expr' => 44,
			'setlist' => 13,
			'node' => 46,
			'lterm' => 47,
			'filter' => 50,
			'directive' => 52,
			'condition' => 31,
			'use' => 32,
			'ident' => 34,
			'capture' => 2,
			'switch' => 3,
			'atomdir' => 36,
			'anonblock' => 35,
			'wrapper' => 40,
			'chunks' => 8,
			'defblock' => 7
		}
	},
	{#State 291
		DEFAULT => -130
	},
	{#State 292
		DEFAULT => -77
	},
	{#State 293
		ACTIONS => {
			"(" => 14,
			'REF' => 15,
			"[" => 16,
			'LITERAL' => 109,
			'IDENT' => 24,
			"\$" => 17,
			'NUMBER' => 1,
			"\${" => 33,
			"\"" => 11,
			"{" => 45,
			'NOT' => 43
		},
		GOTOS => {
			'expr' => 322,
			'ident' => 108,
			'term' => 55,
			'sterm' => 54,
			'lterm' => 47,
			'node' => 46,
			'item' => 72
		}
	},
	{#State 294
		DEFAULT => -165
	},
	{#State 295
		DEFAULT => -80
	},
	{#State 296
		DEFAULT => -82
	},
	{#State 297
		ACTIONS => {
			"\"" => 323
		}
	},
	{#State 298
		DEFAULT => -79
	},
	{#State 299
		ACTIONS => {
			'END' => 324
		}
	},
	{#State 300
		ACTIONS => {
			"\"" => 11,
			"{" => 45,
			'NOT' => 43,
			'REF' => 15,
			"(" => 14,
			'LITERAL' => 253,
			"[" => 16,
			'COMMA' => 251,
			'NUMBER' => 1,
			"\${" => 33,
			"\$" => 17,
			'IDENT' => 24
		},
		DEFAULT => -62,
		GOTOS => {
			'param' => 250,
			'item' => 255,
			'node' => 46,
			'lterm' => 47,
			'expr' => 254,
			'term' => 55,
			'sterm' => 54,
			'ident' => 252
		}
	},
	{#State 301
		ACTIONS => {
			"\"" => 11,
			'NOT' => 43,
			"{" => 45,
			"(" => 14,
			'REF' => 15,
			'LITERAL' => 253,
			"[" => 16,
			"\$" => 17,
			'COMMA' => 251,
			"\${" => 33,
			'NUMBER' => 1,
			'IDENT' => 24
		},
		DEFAULT => -63,
		GOTOS => {
			'item' => 255,
			'param' => 250,
			'lterm' => 47,
			'node' => 46,
			'ident' => 252,
			'sterm' => 54,
			'term' => 55,
			'expr' => 254
		}
	},
	{#State 302
		DEFAULT => -95
	},
	{#State 303
		DEFAULT => -96
	},
	{#State 304
		ACTIONS => {
			'IF' => 57,
			'CALL' => 18,
			'NEXT' => 53,
			"\$" => 17,
			'FOR' => 23,
			'IDENT' => 24,
			'DEFAULT' => 60,
			'GET' => 22,
			'WHILE' => 59,
			'UNLESS' => 27,
			'DEBUG' => 66,
			'TRY' => 28,
			'STOP' => 64,
			'SWITCH' => 62,
			'INSERT' => 68,
			"\${" => 33,
			'NUMBER' => 1,
			'FILTER' => 6,
			'RETURN' => 42,
			'WRAPPER' => 41,
			'CLEAR' => 39,
			'PERL' => 4,
			'INCLUDE' => 5,
			'SET' => 208,
			"{" => 45,
			'NOT' => 43,
			"\"" => 11,
			'THROW' => 10,
			'LAST' => 9,
			"[" => 16,
			'LITERAL' => 51,
			'REF' => 15,
			'BLOCK' => 210,
			'PROCESS' => 48,
			"(" => 14
		},
		GOTOS => {
			'expr' => 209,
			'loop' => 63,
			'atomexpr' => 73,
			'directive' => 211,
			'filter' => 50,
			'item' => 72,
			'try' => 30,
			'lterm' => 47,
			'node' => 46,
			'assign' => 69,
			'setlist' => 13,
			'term' => 55,
			'sterm' => 54,
			'ident' => 104,
			'condition' => 31,
			'perl' => 61,
			'wrapper' => 40,
			'atomdir' => 36,
			'switch' => 3,
			'mdir' => 325
		}
	},
	{#State 305
		ACTIONS => {
			'END' => 326
		}
	},
	{#State 306
		ACTIONS => {
			";" => 327
		}
	},
	{#State 307
		ACTIONS => {
			'END' => 328
		}
	},
	{#State 308
		ACTIONS => {
			'NOT' => 43,
			"{" => 45,
			"\"" => 11,
			"[" => 16,
			'LITERAL' => 109,
			"(" => 14,
			'REF' => 15,
			"\$" => 17,
			'NUMBER' => 1,
			"\${" => 33,
			'IDENT' => 24
		},
		GOTOS => {
			'node' => 46,
			'lterm' => 47,
			'item' => 72,
			'expr' => 329,
			'ident' => 108,
			'term' => 55,
			'sterm' => 54
		}
	},
	{#State 309
		DEFAULT => -67
	},
	{#State 310
		ACTIONS => {
			"[" => 16,
			"(" => 14,
			'USE' => 12,
			'REF' => 15,
			'LAST' => 9,
			'THROW' => 10,
			"\"" => 11,
			'FILTER' => 6,
			'INCLUDE' => 5,
			'PERL' => 4,
			";" => -18,
			'NUMBER' => 1,
			'MACRO' => 25,
			'TRY' => 28,
			'UNLESS' => 27,
			'GET' => 22,
			'FOR' => 23,
			'IDENT' => 24,
			'RAWPERL' => 20,
			'CALL' => 18,
			"\$" => 17,
			'LITERAL' => 51,
			'BLOCK' => 49,
			'PROCESS' => 48,
			'NOT' => 43,
			"{" => 45,
			'CLEAR' => 39,
			'META' => 38,
			'RETURN' => 42,
			'WRAPPER' => 41,
			'SET' => 37,
			"\${" => 33,
			'INSERT' => 68,
			'VIEW' => 67,
			'DEBUG' => 66,
			'SWITCH' => 62,
			'STOP' => 64,
			'DEFAULT' => 60,
			'WHILE' => 59,
			'TEXT' => 56,
			'IF' => 57,
			'NEXT' => 53
		},
		DEFAULT => -3,
		GOTOS => {
			'chunk' => 58,
			'defblockname' => 19,
			'term' => 55,
			'sterm' => 54,
			'statement' => 21,
			'perl' => 61,
			'loop' => 63,
			'rawperl' => 26,
			'view' => 65,
			'block' => 330,
			'assign' => 69,
			'macro' => 70,
			'atomexpr' => 73,
			'item' => 72,
			'try' => 30,
			'use' => 32,
			'condition' => 31,
			'capture' => 2,
			'ident' => 34,
			'anonblock' => 35,
			'atomdir' => 36,
			'switch' => 3,
			'defblock' => 7,
			'chunks' => 8,
			'wrapper' => 40,
			'expr' => 44,
			'lterm' => 47,
			'node' => 46,
			'setlist' => 13,
			'directive' => 52,
			'filter' => 50
		}
	},
	{#State 311
		ACTIONS => {
			";" => 331,
			'DOT' => 177
		}
	},
	{#State 312
		ACTIONS => {
			"\$" => 17,
			'CALL' => 18,
			'RAWPERL' => 20,
			'GET' => 22,
			'FOR' => 23,
			'IDENT' => 24,
			'MACRO' => 25,
			'TRY' => 28,
			'UNLESS' => 27,
			";" => -18,
			'NUMBER' => 1,
			'INCLUDE' => 5,
			'PERL' => 4,
			'FILTER' => 6,
			'LAST' => 9,
			'THROW' => 10,
			"\"" => 11,
			"(" => 14,
			'USE' => 12,
			'REF' => 15,
			"[" => 16,
			'NEXT' => 53,
			'TEXT' => 56,
			'IF' => 57,
			'WHILE' => 59,
			'DEFAULT' => 60,
			'SWITCH' => 62,
			'STOP' => 64,
			'DEBUG' => 66,
			'INSERT' => 68,
			'VIEW' => 67,
			"\${" => 33,
			'SET' => 37,
			'CLEAR' => 39,
			'META' => 38,
			'WRAPPER' => 41,
			'RETURN' => 42,
			"{" => 45,
			'NOT' => 43,
			'PROCESS' => 48,
			'BLOCK' => 49,
			'LITERAL' => 51
		},
		DEFAULT => -3,
		GOTOS => {
			'statement' => 21,
			'perl' => 61,
			'defblockname' => 19,
			'chunk' => 58,
			'sterm' => 54,
			'term' => 55,
			'macro' => 70,
			'assign' => 69,
			'block' => 332,
			'atomexpr' => 73,
			'try' => 30,
			'item' => 72,
			'loop' => 63,
			'view' => 65,
			'rawperl' => 26,
			'atomdir' => 36,
			'anonblock' => 35,
			'switch' => 3,
			'chunks' => 8,
			'defblock' => 7,
			'wrapper' => 40,
			'use' => 32,
			'condition' => 31,
			'capture' => 2,
			'ident' => 34,
			'node' => 46,
			'lterm' => 47,
			'setlist' => 13,
			'directive' => 52,
			'filter' => 50,
			'expr' => 44
		}
	},
	{#State 313
		ACTIONS => {
			";" => 333
		}
	},
	{#State 314
		DEFAULT => -65
	},
	{#State 315
		ACTIONS => {
			'CMPOP' => 143,
			'BINOP' => 139,
			'AND' => 138,
			"/" => 136,
			"+" => 142,
			'MOD' => 137,
			'CAT' => 145,
			"?" => 141,
			'OR' => 140,
			'DIV' => 144
		},
		DEFAULT => -144
	},
	{#State 316
		DEFAULT => -88
	},
	{#State 317
		ACTIONS => {
			'END' => 334
		}
	},
	{#State 318
		ACTIONS => {
			'END' => 335
		}
	},
	{#State 319
		ACTIONS => {
			'IDENT' => 24,
			'DEFAULT' => 337,
			"[" => 16,
			'LITERAL' => 109,
			'REF' => 15,
			"{" => 45,
			"\"" => 11,
			"\${" => 33,
			'NUMBER' => 1,
			";" => 338,
			"\$" => 17
		},
		GOTOS => {
			'lterm' => 47,
			'node' => 46,
			'sterm' => 54,
			'ident' => 108,
			'term' => 336,
			'item' => 72
		}
	},
	{#State 320
		ACTIONS => {
			'END' => 339
		}
	},
	{#State 321
		ACTIONS => {
			'END' => 340
		}
	},
	{#State 322
		ACTIONS => {
			"/" => 136,
			"+" => 142,
			'MOD' => 137,
			'CMPOP' => 143,
			'BINOP' => 139,
			'AND' => 138,
			'OR' => 140,
			'DIV' => 144,
			'CAT' => 145,
			"?" => 141
		},
		DEFAULT => -155
	},
	{#State 323
		DEFAULT => -102
	},
	{#State 324
		DEFAULT => -57
	},
	{#State 325
		DEFAULT => -91
	},
	{#State 326
		DEFAULT => -94
	},
	{#State 327
		ACTIONS => {
			'INCLUDE' => 5,
			'PERL' => 4,
			'FILTER' => 6,
			";" => -18,
			'NUMBER' => 1,
			"(" => 14,
			'USE' => 12,
			'REF' => 15,
			"[" => 16,
			'LAST' => 9,
			"\"" => 11,
			'THROW' => 10,
			'RAWPERL' => 20,
			'GET' => 22,
			'FOR' => 23,
			'IDENT' => 24,
			"\$" => 17,
			'CALL' => 18,
			'MACRO' => 25,
			'TRY' => 28,
			'UNLESS' => 27,
			'SET' => 37,
			'CLEAR' => 39,
			'META' => 38,
			'RETURN' => 42,
			'WRAPPER' => 41,
			"\${" => 33,
			'BLOCK' => 49,
			'PROCESS' => 48,
			'LITERAL' => 51,
			'NOT' => 43,
			"{" => 45,
			'WHILE' => 59,
			'DEFAULT' => 60,
			'NEXT' => 53,
			'TEXT' => 56,
			'IF' => 57,
			'INSERT' => 68,
			'VIEW' => 67,
			'SWITCH' => 62,
			'STOP' => 64,
			'DEBUG' => 66
		},
		DEFAULT => -3,
		GOTOS => {
			'use' => 32,
			'condition' => 31,
			'capture' => 2,
			'ident' => 34,
			'anonblock' => 35,
			'atomdir' => 36,
			'switch' => 3,
			'defblock' => 7,
			'chunks' => 8,
			'wrapper' => 40,
			'expr' => 44,
			'lterm' => 47,
			'node' => 46,
			'setlist' => 13,
			'directive' => 52,
			'filter' => 50,
			'chunk' => 58,
			'defblockname' => 19,
			'sterm' => 54,
			'term' => 55,
			'statement' => 21,
			'perl' => 61,
			'loop' => 63,
			'rawperl' => 26,
			'view' => 65,
			'assign' => 69,
			'macro' => 70,
			'block' => 341,
			'atomexpr' => 73,
			'item' => 72,
			'try' => 30
		}
	},
	{#State 328
		DEFAULT => -46
	},
	{#State 329
		ACTIONS => {
			'OR' => 140,
			"+" => 142,
			"/" => 136,
			'BINOP' => 139,
			'CAT' => 145,
			'CMPOP' => 143,
			'MOD' => 137,
			";" => 342,
			'AND' => 138,
			"?" => 141,
			'DIV' => 144
		}
	},
	{#State 330
		DEFAULT => -71
	},
	{#State 331
		ACTIONS => {
			'STOP' => 64,
			'SWITCH' => 62,
			'DEBUG' => 66,
			'VIEW' => 67,
			'INSERT' => 68,
			'NEXT' => 53,
			'IF' => 57,
			'TEXT' => 56,
			'WHILE' => 59,
			'DEFAULT' => 60,
			"{" => 45,
			'NOT' => 43,
			'BLOCK' => 49,
			'PROCESS' => 48,
			'LITERAL' => 51,
			"\${" => 33,
			'SET' => 37,
			'RETURN' => 42,
			'WRAPPER' => 41,
			'META' => 38,
			'CLEAR' => 39,
			'UNLESS' => 27,
			'TRY' => 28,
			'MACRO' => 25,
			"\$" => 17,
			'CALL' => 18,
			'RAWPERL' => 20,
			'FOR' => 23,
			'IDENT' => 24,
			'GET' => 22,
			'THROW' => 10,
			"\"" => 11,
			'LAST' => 9,
			'REF' => 15,
			'USE' => 12,
			"(" => 14,
			"[" => 16,
			'NUMBER' => 1,
			";" => -18,
			'PERL' => 4,
			'INCLUDE' => 5,
			'FILTER' => 6
		},
		DEFAULT => -3,
		GOTOS => {
			'loop' => 63,
			'rawperl' => 26,
			'view' => 65,
			'block' => 343,
			'macro' => 70,
			'assign' => 69,
			'atomexpr' => 73,
			'item' => 72,
			'try' => 30,
			'chunk' => 58,
			'defblockname' => 19,
			'term' => 55,
			'sterm' => 54,
			'statement' => 21,
			'perl' => 61,
			'expr' => 44,
			'lterm' => 47,
			'node' => 46,
			'setlist' => 13,
			'directive' => 52,
			'filter' => 50,
			'use' => 32,
			'condition' => 31,
			'capture' => 2,
			'ident' => 34,
			'anonblock' => 35,
			'atomdir' => 36,
			'switch' => 3,
			'defblock' => 7,
			'chunks' => 8,
			'wrapper' => 40
		}
	},
	{#State 332
		ACTIONS => {
			'FINAL' => 279,
			'CATCH' => 280
		},
		DEFAULT => -72,
		GOTOS => {
			'final' => 344
		}
	},
	{#State 333
		ACTIONS => {
			'UNLESS' => 27,
			'TRY' => 28,
			'MACRO' => 25,
			'RAWPERL' => 20,
			'IDENT' => 24,
			'FOR' => 23,
			'GET' => 22,
			"\$" => 17,
			'CALL' => 18,
			'REF' => 15,
			'USE' => 12,
			"(" => 14,
			"[" => 16,
			'THROW' => 10,
			"\"" => 11,
			'LAST' => 9,
			'PERL' => 4,
			'INCLUDE' => 5,
			'FILTER' => 6,
			'NUMBER' => 1,
			";" => -18,
			'VIEW' => 67,
			'INSERT' => 68,
			'STOP' => 64,
			'SWITCH' => 62,
			'DEBUG' => 66,
			'WHILE' => 59,
			'DEFAULT' => 60,
			'NEXT' => 53,
			'IF' => 57,
			'TEXT' => 56,
			'BLOCK' => 49,
			'PROCESS' => 48,
			'LITERAL' => 51,
			'NOT' => 43,
			"{" => 45,
			'SET' => 37,
			'RETURN' => 42,
			'WRAPPER' => 41,
			'META' => 38,
			'CLEAR' => 39,
			"\${" => 33
		},
		DEFAULT => -3,
		GOTOS => {
			'expr' => 44,
			'setlist' => 13,
			'lterm' => 47,
			'node' => 46,
			'filter' => 50,
			'directive' => 52,
			'condition' => 31,
			'use' => 32,
			'ident' => 34,
			'capture' => 2,
			'switch' => 3,
			'atomdir' => 36,
			'anonblock' => 35,
			'wrapper' => 40,
			'chunks' => 8,
			'defblock' => 7,
			'loop' => 63,
			'view' => 65,
			'rawperl' => 26,
			'macro' => 70,
			'block' => 345,
			'assign' => 69,
			'try' => 30,
			'item' => 72,
			'atomexpr' => 73,
			'sterm' => 54,
			'term' => 55,
			'defblockname' => 19,
			'chunk' => 58,
			'statement' => 21,
			'perl' => 61
		}
	},
	{#State 334
		DEFAULT => -44
	},
	{#State 335
		DEFAULT => -60
	},
	{#State 336
		ACTIONS => {
			";" => 346
		}
	},
	{#State 337
		ACTIONS => {
			";" => 347
		}
	},
	{#State 338
		ACTIONS => {
			'DEFAULT' => 60,
			'WHILE' => 59,
			'IF' => 57,
			'TEXT' => 56,
			'NEXT' => 53,
			'INSERT' => 68,
			'VIEW' => 67,
			'DEBUG' => 66,
			'STOP' => 64,
			'SWITCH' => 62,
			'RETURN' => 42,
			'WRAPPER' => 41,
			'CLEAR' => 39,
			'META' => 38,
			'SET' => 37,
			"\${" => 33,
			'LITERAL' => 51,
			'BLOCK' => 49,
			'PROCESS' => 48,
			'NOT' => 43,
			"{" => 45,
			'IDENT' => 24,
			'FOR' => 23,
			'GET' => 22,
			'RAWPERL' => 20,
			'CALL' => 18,
			"\$" => 17,
			'TRY' => 28,
			'UNLESS' => 27,
			'MACRO' => 25,
			'FILTER' => 6,
			'INCLUDE' => 5,
			'PERL' => 4,
			'NUMBER' => 1,
			";" => -18,
			"[" => 16,
			'REF' => 15,
			"(" => 14,
			'USE' => 12,
			"\"" => 11,
			'THROW' => 10,
			'LAST' => 9
		},
		DEFAULT => -3,
		GOTOS => {
			'expr' => 44,
			'directive' => 52,
			'filter' => 50,
			'node' => 46,
			'lterm' => 47,
			'setlist' => 13,
			'capture' => 2,
			'ident' => 34,
			'use' => 32,
			'condition' => 31,
			'defblock' => 7,
			'chunks' => 8,
			'wrapper' => 40,
			'anonblock' => 35,
			'atomdir' => 36,
			'switch' => 3,
			'rawperl' => 26,
			'view' => 65,
			'loop' => 63,
			'atomexpr' => 73,
			'try' => 30,
			'item' => 72,
			'macro' => 70,
			'block' => 348,
			'assign' => 69,
			'chunk' => 58,
			'defblockname' => 19,
			'sterm' => 54,
			'term' => 55,
			'perl' => 61,
			'statement' => 21
		}
	},
	{#State 339
		DEFAULT => -51
	},
	{#State 340
		DEFAULT => -75
	},
	{#State 341
		DEFAULT => -49
	},
	{#State 342
		ACTIONS => {
			"\${" => 33,
			'SET' => 37,
			'CLEAR' => 39,
			'META' => 38,
			'RETURN' => 42,
			'WRAPPER' => 41,
			"{" => 45,
			'NOT' => 43,
			'BLOCK' => 49,
			'PROCESS' => 48,
			'LITERAL' => 51,
			'NEXT' => 53,
			'TEXT' => 56,
			'IF' => 57,
			'WHILE' => 59,
			'DEFAULT' => 60,
			'SWITCH' => 62,
			'STOP' => 64,
			'DEBUG' => 66,
			'INSERT' => 68,
			'VIEW' => 67,
			";" => -18,
			'NUMBER' => 1,
			'INCLUDE' => 5,
			'PERL' => 4,
			'FILTER' => 6,
			'LAST' => 9,
			'THROW' => 10,
			"\"" => 11,
			"(" => 14,
			'USE' => 12,
			'REF' => 15,
			"[" => 16,
			"\$" => 17,
			'CALL' => 18,
			'RAWPERL' => 20,
			'GET' => 22,
			'FOR' => 23,
			'IDENT' => 24,
			'MACRO' => 25,
			'TRY' => 28,
			'UNLESS' => 27
		},
		DEFAULT => -3,
		GOTOS => {
			'directive' => 52,
			'filter' => 50,
			'lterm' => 47,
			'node' => 46,
			'setlist' => 13,
			'expr' => 44,
			'defblock' => 7,
			'chunks' => 8,
			'wrapper' => 40,
			'anonblock' => 35,
			'atomdir' => 36,
			'switch' => 3,
			'capture' => 2,
			'ident' => 34,
			'use' => 32,
			'condition' => 31,
			'atomexpr' => 73,
			'try' => 30,
			'item' => 72,
			'assign' => 69,
			'block' => 349,
			'macro' => 70,
			'rawperl' => 26,
			'view' => 65,
			'loop' => 63,
			'perl' => 61,
			'statement' => 21,
			'chunk' => 58,
			'defblockname' => 19,
			'sterm' => 54,
			'term' => 55
		}
	},
	{#State 343
		ACTIONS => {
			'CATCH' => 280,
			'FINAL' => 279
		},
		DEFAULT => -72,
		GOTOS => {
			'final' => 350
		}
	},
	{#State 344
		DEFAULT => -70
	},
	{#State 345
		ACTIONS => {
			'CATCH' => 280,
			'FINAL' => 279
		},
		DEFAULT => -72,
		GOTOS => {
			'final' => 351
		}
	},
	{#State 346
		ACTIONS => {
			'SET' => 37,
			'CLEAR' => 39,
			'META' => 38,
			'WRAPPER' => 41,
			'RETURN' => 42,
			"\${" => 33,
			'PROCESS' => 48,
			'BLOCK' => 49,
			'LITERAL' => 51,
			"{" => 45,
			'NOT' => 43,
			'WHILE' => 59,
			'DEFAULT' => 60,
			'NEXT' => 53,
			'TEXT' => 56,
			'IF' => 57,
			'INSERT' => 68,
			'VIEW' => 67,
			'SWITCH' => 62,
			'STOP' => 64,
			'DEBUG' => 66,
			'INCLUDE' => 5,
			'PERL' => 4,
			'FILTER' => 6,
			";" => -18,
			'NUMBER' => 1,
			"(" => 14,
			'USE' => 12,
			'REF' => 15,
			"[" => 16,
			'LAST' => 9,
			'THROW' => 10,
			"\"" => 11,
			'RAWPERL' => 20,
			'GET' => 22,
			'FOR' => 23,
			'IDENT' => 24,
			"\$" => 17,
			'CALL' => 18,
			'MACRO' => 25,
			'TRY' => 28,
			'UNLESS' => 27
		},
		DEFAULT => -3,
		GOTOS => {
			'rawperl' => 26,
			'view' => 65,
			'loop' => 63,
			'try' => 30,
			'item' => 72,
			'atomexpr' => 73,
			'macro' => 70,
			'assign' => 69,
			'block' => 352,
			'term' => 55,
			'sterm' => 54,
			'chunk' => 58,
			'defblockname' => 19,
			'perl' => 61,
			'statement' => 21,
			'expr' => 44,
			'filter' => 50,
			'directive' => 52,
			'setlist' => 13,
			'node' => 46,
			'lterm' => 47,
			'ident' => 34,
			'capture' => 2,
			'condition' => 31,
			'use' => 32,
			'wrapper' => 40,
			'defblock' => 7,
			'chunks' => 8,
			'switch' => 3,
			'anonblock' => 35,
			'atomdir' => 36
		}
	},
	{#State 347
		ACTIONS => {
			'RETURN' => 42,
			'WRAPPER' => 41,
			'CLEAR' => 39,
			'META' => 38,
			'SET' => 37,
			"\${" => 33,
			'LITERAL' => 51,
			'BLOCK' => 49,
			'PROCESS' => 48,
			"{" => 45,
			'NOT' => 43,
			'DEFAULT' => 60,
			'WHILE' => 59,
			'IF' => 57,
			'TEXT' => 56,
			'NEXT' => 53,
			'INSERT' => 68,
			'VIEW' => 67,
			'DEBUG' => 66,
			'STOP' => 64,
			'SWITCH' => 62,
			'FILTER' => 6,
			'INCLUDE' => 5,
			'PERL' => 4,
			'NUMBER' => 1,
			";" => -18,
			"[" => 16,
			'REF' => 15,
			"(" => 14,
			'USE' => 12,
			"\"" => 11,
			'THROW' => 10,
			'LAST' => 9,
			'FOR' => 23,
			'IDENT' => 24,
			'GET' => 22,
			'RAWPERL' => 20,
			'CALL' => 18,
			"\$" => 17,
			'TRY' => 28,
			'UNLESS' => 27,
			'MACRO' => 25
		},
		DEFAULT => -3,
		GOTOS => {
			'defblockname' => 19,
			'chunk' => 58,
			'sterm' => 54,
			'term' => 55,
			'perl' => 61,
			'statement' => 21,
			'view' => 65,
			'rawperl' => 26,
			'loop' => 63,
			'atomexpr' => 73,
			'item' => 72,
			'try' => 30,
			'block' => 353,
			'assign' => 69,
			'macro' => 70,
			'capture' => 2,
			'ident' => 34,
			'use' => 32,
			'condition' => 31,
			'chunks' => 8,
			'defblock' => 7,
			'wrapper' => 40,
			'atomdir' => 36,
			'anonblock' => 35,
			'switch' => 3,
			'expr' => 44,
			'directive' => 52,
			'filter' => 50,
			'node' => 46,
			'lterm' => 47,
			'setlist' => 13
		}
	},
	{#State 348
		DEFAULT => -54
	},
	{#State 349
		ACTIONS => {
			'ELSE' => 306,
			'ELSIF' => 308
		},
		DEFAULT => -50,
		GOTOS => {
			'else' => 354
		}
	},
	{#State 350
		DEFAULT => -68
	},
	{#State 351
		DEFAULT => -69
	},
	{#State 352
		ACTIONS => {
			'CASE' => 319
		},
		DEFAULT => -55,
		GOTOS => {
			'case' => 355
		}
	},
	{#State 353
		DEFAULT => -53
	},
	{#State 354
		DEFAULT => -48
	},
	{#State 355
		DEFAULT => -52
	}
];


#========================================================================
# Rules
#========================================================================

$RULES = [
	[#Rule 0
		 '$start', 2, undef
	],
	[#Rule 1
		 'template', 1,
sub
#line 64 "Parser.yp"
{ $factory->template($_[1])           }
	],
	[#Rule 2
		 'block', 1,
sub
#line 67 "Parser.yp"
{ $factory->block($_[1])              }
	],
	[#Rule 3
		 'block', 0,
sub
#line 68 "Parser.yp"
{ $factory->block()                   }
	],
	[#Rule 4
		 'chunks', 2,
sub
#line 71 "Parser.yp"
{ push(@{$_[1]}, $_[2]) 
                                        if defined $_[2]; $_[1]           }
	],
	[#Rule 5
		 'chunks', 1,
sub
#line 73 "Parser.yp"
{ defined $_[1] ? [ $_[1] ] : [ ]     }
	],
	[#Rule 6
		 'chunk', 1,
sub
#line 76 "Parser.yp"
{ $factory->textblock($_[1])          }
	],
	[#Rule 7
		 'chunk', 2,
sub
#line 77 "Parser.yp"
{ return '' unless $_[1];
                                      $_[0]->location() . $_[1];
                                    }
	],
	[#Rule 8
		 'statement', 1, undef
	],
	[#Rule 9
		 'statement', 1, undef
	],
	[#Rule 10
		 'statement', 1, undef
	],
	[#Rule 11
		 'statement', 1, undef
	],
	[#Rule 12
		 'statement', 1, undef
	],
	[#Rule 13
		 'statement', 1, undef
	],
	[#Rule 14
		 'statement', 1, undef
	],
	[#Rule 15
		 'statement', 1, undef
	],
	[#Rule 16
		 'statement', 1,
sub
#line 90 "Parser.yp"
{ $factory->get($_[1])                }
	],
	[#Rule 17
		 'statement', 2,
sub
#line 91 "Parser.yp"
{ $_[0]->add_metadata($_[2]);         }
	],
	[#Rule 18
		 'statement', 0, undef
	],
	[#Rule 19
		 'directive', 1,
sub
#line 95 "Parser.yp"
{ $factory->set($_[1])                }
	],
	[#Rule 20
		 'directive', 1, undef
	],
	[#Rule 21
		 'directive', 1, undef
	],
	[#Rule 22
		 'directive', 1, undef
	],
	[#Rule 23
		 'directive', 1, undef
	],
	[#Rule 24
		 'directive', 1, undef
	],
	[#Rule 25
		 'directive', 1, undef
	],
	[#Rule 26
		 'atomexpr', 1,
sub
#line 109 "Parser.yp"
{ $factory->get($_[1])                }
	],
	[#Rule 27
		 'atomexpr', 1, undef
	],
	[#Rule 28
		 'atomdir', 2,
sub
#line 113 "Parser.yp"
{ $factory->get($_[2])                }
	],
	[#Rule 29
		 'atomdir', 2,
sub
#line 114 "Parser.yp"
{ $factory->call($_[2])               }
	],
	[#Rule 30
		 'atomdir', 2,
sub
#line 115 "Parser.yp"
{ $factory->set($_[2])                }
	],
	[#Rule 31
		 'atomdir', 2,
sub
#line 116 "Parser.yp"
{ $factory->default($_[2])            }
	],
	[#Rule 32
		 'atomdir', 2,
sub
#line 117 "Parser.yp"
{ $factory->insert($_[2])             }
	],
	[#Rule 33
		 'atomdir', 2,
sub
#line 118 "Parser.yp"
{ $factory->include($_[2])            }
	],
	[#Rule 34
		 'atomdir', 2,
sub
#line 119 "Parser.yp"
{ $factory->process($_[2])            }
	],
	[#Rule 35
		 'atomdir', 2,
sub
#line 120 "Parser.yp"
{ $factory->throw($_[2])              }
	],
	[#Rule 36
		 'atomdir', 1,
sub
#line 121 "Parser.yp"
{ $factory->return()                  }
	],
	[#Rule 37
		 'atomdir', 1,
sub
#line 122 "Parser.yp"
{ $factory->stop()                    }
	],
	[#Rule 38
		 'atomdir', 1,
sub
#line 123 "Parser.yp"
{ "\$output = '';";                   }
	],
	[#Rule 39
		 'atomdir', 1,
sub
#line 124 "Parser.yp"
{ $_[0]->block_label('last ', ';')    }
	],
	[#Rule 40
		 'atomdir', 1,
sub
#line 125 "Parser.yp"
{ $_[0]->in_block('FOR')
                                        ? $factory->next($_[0]->block_label)
                                        : $_[0]->block_label('next ', ';') }
	],
	[#Rule 41
		 'atomdir', 2,
sub
#line 128 "Parser.yp"
{ if ($_[2]->[0]->[0] =~ /^'(on|off)'$/) {
                                          $_[0]->{ DEBUG_DIRS } = ($1 eq 'on');
                                          $factory->debug($_[2]);
                                      }
                                      else {
                                          $_[0]->{ DEBUG_DIRS } ? $factory->debug($_[2]) : '';
                                      }
                                    }
	],
	[#Rule 42
		 'atomdir', 1, undef
	],
	[#Rule 43
		 'atomdir', 1, undef
	],
	[#Rule 44
		 'condition', 6,
sub
#line 141 "Parser.yp"
{ $factory->if(@_[2, 4, 5])           }
	],
	[#Rule 45
		 'condition', 3,
sub
#line 142 "Parser.yp"
{ $factory->if(@_[3, 1])              }
	],
	[#Rule 46
		 'condition', 6,
sub
#line 144 "Parser.yp"
{ $factory->if("!($_[2])", @_[4, 5])  }
	],
	[#Rule 47
		 'condition', 3,
sub
#line 145 "Parser.yp"
{ $factory->if("!($_[3])", $_[1])     }
	],
	[#Rule 48
		 'else', 5,
sub
#line 149 "Parser.yp"
{ unshift(@{$_[5]}, [ @_[2, 4] ]);
                                      $_[5];                              }
	],
	[#Rule 49
		 'else', 3,
sub
#line 151 "Parser.yp"
{ [ $_[3] ]                           }
	],
	[#Rule 50
		 'else', 0,
sub
#line 152 "Parser.yp"
{ [ undef ]                           }
	],
	[#Rule 51
		 'switch', 6,
sub
#line 156 "Parser.yp"
{ $factory->switch(@_[2, 5])          }
	],
	[#Rule 52
		 'case', 5,
sub
#line 160 "Parser.yp"
{ unshift(@{$_[5]}, [ @_[2, 4] ]); 
                                      $_[5];                              }
	],
	[#Rule 53
		 'case', 4,
sub
#line 162 "Parser.yp"
{ [ $_[4] ]                           }
	],
	[#Rule 54
		 'case', 3,
sub
#line 163 "Parser.yp"
{ [ $_[3] ]                           }
	],
	[#Rule 55
		 'case', 0,
sub
#line 164 "Parser.yp"
{ [ undef ]                           }
	],
	[#Rule 56
		 '@1-3', 0,
sub
#line 167 "Parser.yp"
{ $_[0]->enter_block('FOR')           }
	],
	[#Rule 57
		 'loop', 6,
sub
#line 168 "Parser.yp"
{ $factory->foreach(@{$_[2]}, $_[5], $_[0]->leave_block)  }
	],
	[#Rule 58
		 'loop', 3,
sub
#line 169 "Parser.yp"
{ $factory->foreach(@{$_[3]}, $_[1])  }
	],
	[#Rule 59
		 '@2-3', 0,
sub
#line 170 "Parser.yp"
{ $_[0]->enter_block('WHILE')         }
	],
	[#Rule 60
		 'loop', 6,
sub
#line 171 "Parser.yp"
{ $factory->while(@_[2, 5], $_[0]->leave_block) }
	],
	[#Rule 61
		 'loop', 3,
sub
#line 172 "Parser.yp"
{ $factory->while(@_[3, 1]) }
	],
	[#Rule 62
		 'loopvar', 4,
sub
#line 175 "Parser.yp"
{ [ @_[1, 3, 4] ]                     }
	],
	[#Rule 63
		 'loopvar', 4,
sub
#line 176 "Parser.yp"
{ [ @_[1, 3, 4] ]                     }
	],
	[#Rule 64
		 'loopvar', 2,
sub
#line 177 "Parser.yp"
{ [ 0, @_[1, 2] ]                     }
	],
	[#Rule 65
		 'wrapper', 5,
sub
#line 181 "Parser.yp"
{ $factory->wrapper(@_[2, 4])         }
	],
	[#Rule 66
		 'wrapper', 3,
sub
#line 183 "Parser.yp"
{ $factory->wrapper(@_[3, 1])         }
	],
	[#Rule 67
		 'try', 5,
sub
#line 187 "Parser.yp"
{ $factory->try(@_[3, 4])             }
	],
	[#Rule 68
		 'final', 5,
sub
#line 191 "Parser.yp"
{ unshift(@{$_[5]}, [ @_[2,4] ]);
                                      $_[5];                              }
	],
	[#Rule 69
		 'final', 5,
sub
#line 194 "Parser.yp"
{ unshift(@{$_[5]}, [ undef, $_[4] ]);
                                      $_[5];                              }
	],
	[#Rule 70
		 'final', 4,
sub
#line 197 "Parser.yp"
{ unshift(@{$_[4]}, [ undef, $_[3] ]);
                                      $_[4];                              }
	],
	[#Rule 71
		 'final', 3,
sub
#line 199 "Parser.yp"
{ [ $_[3] ]                           }
	],
	[#Rule 72
		 'final', 0,
sub
#line 200 "Parser.yp"
{ [ 0 ] }
	],
	[#Rule 73
		 'use', 2,
sub
#line 203 "Parser.yp"
{ $factory->use($_[2])                }
	],
	[#Rule 74
		 '@3-3', 0,
sub
#line 206 "Parser.yp"
{ $_[0]->push_defblock();             }
	],
	[#Rule 75
		 'view', 6,
sub
#line 207 "Parser.yp"
{ $factory->view(@_[2,5], 
                                                     $_[0]->pop_defblock) }
	],
	[#Rule 76
		 '@4-2', 0,
sub
#line 211 "Parser.yp"
{ ${$_[0]->{ INPERL }}++;             }
	],
	[#Rule 77
		 'perl', 5,
sub
#line 212 "Parser.yp"
{ ${$_[0]->{ INPERL }}--;
                                      $_[0]->{ EVAL_PERL } 
                                      ? $factory->perl($_[4])             
                                      : $factory->no_perl();              }
	],
	[#Rule 78
		 '@5-1', 0,
sub
#line 218 "Parser.yp"
{ ${$_[0]->{ INPERL }}++; 
                                      $rawstart = ${$_[0]->{'LINE'}};     }
	],
	[#Rule 79
		 'rawperl', 5,
sub
#line 220 "Parser.yp"
{ ${$_[0]->{ INPERL }}--;
                                      $_[0]->{ EVAL_PERL } 
                                      ? $factory->rawperl($_[4], $rawstart)
                                      : $factory->no_perl();              }
	],
	[#Rule 80
		 'filter', 5,
sub
#line 227 "Parser.yp"
{ $factory->filter(@_[2,4])           }
	],
	[#Rule 81
		 'filter', 3,
sub
#line 229 "Parser.yp"
{ $factory->filter(@_[3,1])           }
	],
	[#Rule 82
		 'defblock', 5,
sub
#line 234 "Parser.yp"
{ my $name = join('/', @{ $_[0]->{ DEFBLOCKS } });
                                      pop(@{ $_[0]->{ DEFBLOCKS } });
                                      $_[0]->define_block($name, $_[4]); 
                                      undef
                                    }
	],
	[#Rule 83
		 'defblockname', 2,
sub
#line 241 "Parser.yp"
{ push(@{ $_[0]->{ DEFBLOCKS } }, $_[2]);
                                      $_[2];
                                    }
	],
	[#Rule 84
		 'blockname', 1, undef
	],
	[#Rule 85
		 'blockname', 1,
sub
#line 247 "Parser.yp"
{ $_[1] =~ s/^'(.*)'$/$1/; $_[1]      }
	],
	[#Rule 86
		 'blockargs', 1, undef
	],
	[#Rule 87
		 'blockargs', 0, undef
	],
	[#Rule 88
		 'anonblock', 5,
sub
#line 255 "Parser.yp"
{ local $" = ', ';
                                      print STDERR "experimental block args: [@{ $_[2] }]\n"
                                          if $_[2];
                                      $factory->anon_block($_[4])         }
	],
	[#Rule 89
		 'capture', 3,
sub
#line 261 "Parser.yp"
{ $factory->capture(@_[1, 3])         }
	],
	[#Rule 90
		 'capture', 4,
sub
#line 262 "Parser.yp"
{ $factory->capture(@_[2, 4])         }
	],
	[#Rule 91
		 'macro', 6,
sub
#line 266 "Parser.yp"
{ $factory->macro(@_[2, 6, 4])        }
	],
	[#Rule 92
		 'macro', 3,
sub
#line 267 "Parser.yp"
{ $factory->macro(@_[2, 3])           }
	],
	[#Rule 93
		 'mdir', 1, undef
	],
	[#Rule 94
		 'mdir', 4,
sub
#line 271 "Parser.yp"
{ $_[3]                               }
	],
	[#Rule 95
		 'margs', 2,
sub
#line 274 "Parser.yp"
{ push(@{$_[1]}, $_[2]); $_[1]        }
	],
	[#Rule 96
		 'margs', 2,
sub
#line 275 "Parser.yp"
{ $_[1]                               }
	],
	[#Rule 97
		 'margs', 1,
sub
#line 276 "Parser.yp"
{ [ $_[1] ]                           }
	],
	[#Rule 98
		 'metadata', 2,
sub
#line 279 "Parser.yp"
{ push(@{$_[1]}, @{$_[2]}); $_[1]     }
	],
	[#Rule 99
		 'metadata', 2, undef
	],
	[#Rule 100
		 'metadata', 1, undef
	],
	[#Rule 101
		 'meta', 3,
sub
#line 284 "Parser.yp"
{ for ($_[3]) { s/^'//; s/'$//; 
                                                       s/\\'/'/g  }; 
                                         [ @_[1,3] ] }
	],
	[#Rule 102
		 'meta', 5,
sub
#line 287 "Parser.yp"
{ [ @_[1,4] ] }
	],
	[#Rule 103
		 'meta', 3,
sub
#line 288 "Parser.yp"
{ [ @_[1,3] ] }
	],
	[#Rule 104
		 'term', 1, undef
	],
	[#Rule 105
		 'term', 1, undef
	],
	[#Rule 106
		 'lterm', 3,
sub
#line 300 "Parser.yp"
{ "[ $_[2] ]"                         }
	],
	[#Rule 107
		 'lterm', 3,
sub
#line 301 "Parser.yp"
{ "[ $_[2] ]"                         }
	],
	[#Rule 108
		 'lterm', 2,
sub
#line 302 "Parser.yp"
{ "[ ]"                               }
	],
	[#Rule 109
		 'lterm', 3,
sub
#line 303 "Parser.yp"
{ "{ $_[2]  }"                        }
	],
	[#Rule 110
		 'sterm', 1,
sub
#line 306 "Parser.yp"
{ $factory->ident($_[1])              }
	],
	[#Rule 111
		 'sterm', 2,
sub
#line 307 "Parser.yp"
{ $factory->identref($_[2])           }
	],
	[#Rule 112
		 'sterm', 3,
sub
#line 308 "Parser.yp"
{ $factory->quoted($_[2])             }
	],
	[#Rule 113
		 'sterm', 1, undef
	],
	[#Rule 114
		 'sterm', 1, undef
	],
	[#Rule 115
		 'list', 2,
sub
#line 313 "Parser.yp"
{ "$_[1], $_[2]"                      }
	],
	[#Rule 116
		 'list', 2, undef
	],
	[#Rule 117
		 'list', 1, undef
	],
	[#Rule 118
		 'range', 3,
sub
#line 318 "Parser.yp"
{ $_[1] . '..' . $_[3]                }
	],
	[#Rule 119
		 'hash', 1, undef
	],
	[#Rule 120
		 'hash', 0,
sub
#line 323 "Parser.yp"
{ "" }
	],
	[#Rule 121
		 'params', 2,
sub
#line 326 "Parser.yp"
{ "$_[1], $_[2]"                      }
	],
	[#Rule 122
		 'params', 2, undef
	],
	[#Rule 123
		 'params', 1, undef
	],
	[#Rule 124
		 'param', 3,
sub
#line 331 "Parser.yp"
{ "$_[1] => $_[3]"                    }
	],
	[#Rule 125
		 'param', 3,
sub
#line 332 "Parser.yp"
{ "$_[1] => $_[3]"                    }
	],
	[#Rule 126
		 'ident', 3,
sub
#line 335 "Parser.yp"
{ push(@{$_[1]}, @{$_[3]}); $_[1]     }
	],
	[#Rule 127
		 'ident', 3,
sub
#line 336 "Parser.yp"
{ push(@{$_[1]}, 
                                           map {($_, 0)} split(/\./, $_[3]));
                                      $_[1];                              }
	],
	[#Rule 128
		 'ident', 1, undef
	],
	[#Rule 129
		 'node', 1,
sub
#line 342 "Parser.yp"
{ [ $_[1], 0 ]                        }
	],
	[#Rule 130
		 'node', 4,
sub
#line 343 "Parser.yp"
{ [ $_[1], $factory->args($_[3]) ]    }
	],
	[#Rule 131
		 'item', 1,
sub
#line 346 "Parser.yp"
{ "'$_[1]'"                           }
	],
	[#Rule 132
		 'item', 3,
sub
#line 347 "Parser.yp"
{ $_[2]                               }
	],
	[#Rule 133
		 'item', 2,
sub
#line 348 "Parser.yp"
{ $_[0]->{ V1DOLLAR }
                                       ? "'$_[2]'" 
                                       : $factory->ident(["'$_[2]'", 0])  }
	],
	[#Rule 134
		 'expr', 3,
sub
#line 353 "Parser.yp"
{ "$_[1] $_[2] $_[3]"                 }
	],
	[#Rule 135
		 'expr', 3,
sub
#line 354 "Parser.yp"
{ "$_[1] $_[2] $_[3]"                 }
	],
	[#Rule 136
		 'expr', 3,
sub
#line 355 "Parser.yp"
{ "$_[1] $_[2] $_[3]"                 }
	],
	[#Rule 137
		 'expr', 3,
sub
#line 356 "Parser.yp"
{ "int($_[1] / $_[3])"                }
	],
	[#Rule 138
		 'expr', 3,
sub
#line 357 "Parser.yp"
{ "$_[1] % $_[3]"                     }
	],
	[#Rule 139
		 'expr', 3,
sub
#line 358 "Parser.yp"
{ "$_[1] $CMPOP{ $_[2] } $_[3]"       }
	],
	[#Rule 140
		 'expr', 3,
sub
#line 359 "Parser.yp"
{ "$_[1]  . $_[3]"                    }
	],
	[#Rule 141
		 'expr', 3,
sub
#line 360 "Parser.yp"
{ "$_[1] && $_[3]"                    }
	],
	[#Rule 142
		 'expr', 3,
sub
#line 361 "Parser.yp"
{ "$_[1] || $_[3]"                    }
	],
	[#Rule 143
		 'expr', 2,
sub
#line 362 "Parser.yp"
{ "! $_[2]"                           }
	],
	[#Rule 144
		 'expr', 5,
sub
#line 363 "Parser.yp"
{ "$_[1] ? $_[3] : $_[5]"             }
	],
	[#Rule 145
		 'expr', 3,
sub
#line 364 "Parser.yp"
{ $factory->assign(@{$_[2]})          }
	],
	[#Rule 146
		 'expr', 3,
sub
#line 365 "Parser.yp"
{ "($_[2])"                           }
	],
	[#Rule 147
		 'expr', 1, undef
	],
	[#Rule 148
		 'setlist', 2,
sub
#line 369 "Parser.yp"
{ push(@{$_[1]}, @{$_[2]}); $_[1]     }
	],
	[#Rule 149
		 'setlist', 2, undef
	],
	[#Rule 150
		 'setlist', 1, undef
	],
	[#Rule 151
		 'assign', 3,
sub
#line 375 "Parser.yp"
{ [ $_[1], $_[3] ]                    }
	],
	[#Rule 152
		 'assign', 3,
sub
#line 376 "Parser.yp"
{ [ @_[1,3] ]                         }
	],
	[#Rule 153
		 'args', 2,
sub
#line 383 "Parser.yp"
{ push(@{$_[1]}, $_[2]); $_[1]        }
	],
	[#Rule 154
		 'args', 2,
sub
#line 384 "Parser.yp"
{ push(@{$_[1]->[0]}, $_[2]); $_[1]   }
	],
	[#Rule 155
		 'args', 4,
sub
#line 385 "Parser.yp"
{ push(@{$_[1]->[0]}, "'', " . 
                                      $factory->assign(@_[2,4])); $_[1]  }
	],
	[#Rule 156
		 'args', 2,
sub
#line 387 "Parser.yp"
{ $_[1]                               }
	],
	[#Rule 157
		 'args', 0,
sub
#line 388 "Parser.yp"
{ [ [ ] ]                             }
	],
	[#Rule 158
		 'lnameargs', 3,
sub
#line 398 "Parser.yp"
{ push(@{$_[3]}, $_[1]); $_[3]        }
	],
	[#Rule 159
		 'lnameargs', 1, undef
	],
	[#Rule 160
		 'lvalue', 1, undef
	],
	[#Rule 161
		 'lvalue', 3,
sub
#line 403 "Parser.yp"
{ $factory->quoted($_[2])             }
	],
	[#Rule 162
		 'lvalue', 1, undef
	],
	[#Rule 163
		 'nameargs', 3,
sub
#line 407 "Parser.yp"
{ [ [$factory->ident($_[2])], $_[3] ]   }
	],
	[#Rule 164
		 'nameargs', 2,
sub
#line 408 "Parser.yp"
{ [ @_[1,2] ] }
	],
	[#Rule 165
		 'nameargs', 4,
sub
#line 409 "Parser.yp"
{ [ @_[1,3] ] }
	],
	[#Rule 166
		 'names', 3,
sub
#line 412 "Parser.yp"
{ push(@{$_[1]}, $_[3]); $_[1] }
	],
	[#Rule 167
		 'names', 1,
sub
#line 413 "Parser.yp"
{ [ $_[1] ]                    }
	],
	[#Rule 168
		 'name', 3,
sub
#line 416 "Parser.yp"
{ $factory->quoted($_[2])  }
	],
	[#Rule 169
		 'name', 1,
sub
#line 417 "Parser.yp"
{ "'$_[1]'" }
	],
	[#Rule 170
		 'name', 1, undef
	],
	[#Rule 171
		 'filename', 3,
sub
#line 421 "Parser.yp"
{ "$_[1].$_[3]" }
	],
	[#Rule 172
		 'filename', 1, undef
	],
	[#Rule 173
		 'filepart', 1, undef
	],
	[#Rule 174
		 'filepart', 1, undef
	],
	[#Rule 175
		 'filepart', 1, undef
	],
	[#Rule 176
		 'quoted', 2,
sub
#line 435 "Parser.yp"
{ push(@{$_[1]}, $_[2]) 
                                          if defined $_[2]; $_[1]         }
	],
	[#Rule 177
		 'quoted', 0,
sub
#line 437 "Parser.yp"
{ [ ]                                 }
	],
	[#Rule 178
		 'quotable', 1,
sub
#line 440 "Parser.yp"
{ $factory->ident($_[1])              }
	],
	[#Rule 179
		 'quotable', 1,
sub
#line 441 "Parser.yp"
{ $factory->text($_[1])               }
	],
	[#Rule 180
		 'quotable', 1,
sub
#line 442 "Parser.yp"
{ undef                               }
	]
];

} #--- END BEGIN


1;

__END__

=head1 NAME

Template::Grammar - Parser state/rule tables for the TT grammar

=head1 SYNOPSIS

    # no user serviceable parts inside

=head1 DESCRIPTION

This module defines the state and rule tables that the L<Template::Parser>
module uses to parse templates.  It is generated from a YACC-like grammar
using the C<Parse::Yapp> module.  The F<parser> sub-directory of the
Template Toolkit source distribution contains the grammar and other
files required to generate this module.

But you don't need to worry about any of that unless you're planning to
modify the Template Toolkit language.

=head1 AUTHOR

Andy Wardley E<lt>abw@wardley.orgE<gt>

L<http://wardley.org/>

=head1 COPYRIGHT

Copyright (C) 1996-2020 Andy Wardley.  All Rights Reserved.

This module is free software; you can redistribute it and/or
modify it under the same terms as Perl itself.

=head1 SEE ALSO

L<Template::Parser>

=cut

# Local Variables:
# mode: perl
# perl-indent-level: 4
# indent-tabs-mode: nil
# End:
#
# vim: expandtab shiftwidth=4:
