# Usage: Makefile.PL --pp # disable XS
#        Makefile.PL -g   # add -g to the compiler and disable optimization flags
use inc::Module::Install;
use Module::Install::XSUtil 0.44;

name 'Data-MessagePack';
all_from 'lib/Data/MessagePack.pm';

test_requires('Test::More' => 0.94); # done_testing
test_requires('Test::Requires');

tests 't/*.t';
recursive_author_tests('xt');

if ($Module::Install::AUTHOR) {
    init_msgpack();
}

my $use_xs = 0;
if ( $] >= 5.008005 and want_xs() ) {
    my $has_c99 = c99_available(); # msgpack C library requires C99.

    if ( $has_c99 ) {
        requires_c99();
        use_xshelper();
        cc_warnings;
        cc_include_paths('include');
        cc_src_paths('xs-src');
	postamble (qq{
xs-src/pack.o : xshelper.h include/msgpack/pack_define.h include/msgpack/pack_template.h include/msgpack/sysdep.h
xs-src/unpack.o : xshelper.h include/msgpack/unpack_define.h include/msgpack/unpack_template.h include/msgpack/sysdep.h
});

        if($Module::Install::AUTHOR) {
            postamble qq{test :: test_pp\n\n};
        }
        $use_xs = 1;
    }
    else {
        print <<NOT_SUPPORT_C99;

This distribution requires a C99 compiler, but yours seems not to support C99.
Instead of XS, configure PP version.

NOT_SUPPORT_C99

    }
}

if(!$use_xs) {
    print "configure PP version\n\n";
    requires 'Math::BigInt' => 1.89; # old versions of BigInt were broken
}

test_with_env( test_pp => PERL_DATA_MESSAGEPACK => 'pp' );

repository('http://github.com/msgpack/msgpack-perl');

clean_files qw{
    *.stackdump
    *.gcov *.gcda *.gcno
    *.out
    nytprof
    cover_db
};

WriteAll;

# copied from Makefile.PL in Text::Xslate.
sub test_with_env {
    my($name, %env) = @_;

    my $dir = '.testenv';
    if(not -e $dir) {
        mkdir $dir or die "Cannot mkdir '.testenv': $!";
    }
    clean_files($dir);

    {
        open my $out, '>', "$dir/$name.pl"
            or die "Cannot open '$dir/$name.pl' for writing: $!";
       print $out "# This file sets the env for 'make $name', \n";
       print $out "# generated by $0 at ", scalar(localtime), ".\n";
       print $out "# DO NOT EDIT THIS FILE DIRECTLY.\n";
       print $out "\n";

        while(my($name, $value) = each %env) {
            printf $out '$ENV{q{%s}} = q{%s};'."\n", $name, $value;
        }
    }

    # repeat testing for pure Perl mode
    # see also ExtUtils::MM_Any::test_via_harness()

    my $t =  q{$(FULLPERLRUN) -MExtUtils::Command::MM -e}
            .q{ "do q[%s]; test_harness($(TEST_VERBOSE), '$(INST_LIB)', '$(INST_ARCHLIB)')"}
            .q{ $(TEST_FILES)};

    postamble qq{$name :: pure_all\n}
            . qq{\t} . q{$(NOECHO) $(ECHO) TESTING: } . $name . qq{\n}
            . qq{\t} . sprintf($t, "$dir/$name.pl") . qq{\n\n}

            . qq{testall :: $name\n\n};
    return;
}

sub init_msgpack {
    print "AuthorMode: copy modules\n";
    if(not -d 'include') {
        system 'git', 'submodule', 'init';
        system 'git', 'submodule', 'update';
    }
    else {
        system 'git', 'submodule', 'sync';
    }

    require File::Path;
    require File::Copy;

    File::Path::rmtree([qw(include t/std)]);
    File::Path::mkpath([qw(include/msgpack t/std)]);

    for my $src (<msgpack/msgpack/*.h>) {
        print "AuthorMode: copy $src to include/msgpack\n";
        File::Copy::copy($src, 'include/msgpack') or die "copy failed: $!";
    }

    for my $src(<msgpack/test/*.{json,mpac}>) {
        print "AuthorMode: copy $src to t/std/\n";
        File::Copy::copy($src, 't/std') or die "copy failed: $!";
    }
}

