# Generated by default/object.tt
package Paws::SSOIdentityStore::Group;
  use Moose;
  has DisplayName => (is => 'ro', isa => 'Str', required => 1);
  has GroupId => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::SSOIdentityStore::Group

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SSOIdentityStore::Group object:

  $service_obj->Method(Att1 => { DisplayName => $value, ..., GroupId => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SSOIdentityStore::Group object:

  $result = $service_obj->Method(...);
  $result->Att1->DisplayName

=head1 DESCRIPTION

A group object, which contains a specified groupE<rsquo>s metadata and
attributes.

=head1 ATTRIBUTES


=head2 B<REQUIRED> DisplayName => Str

Contains the groupE<rsquo>s display name value. The length limit is
1024 characters. This value can consist of letters, accented
characters, symbols, numbers, punctuation, tab, new line, carriage
return, space and non breaking space in this attribute. The characters
E<ldquo>E<lt>E<gt>;:%E<rdquo> are excluded. This value is specified at
the time the group is created and stored as an attribute of the group
object in the identity store.


=head2 B<REQUIRED> GroupId => Str

The identifier for a group in the identity store.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SSOIdentityStore>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

