/*
 * Decompiled with CFR 0.152.
 */
package at.ac.tuwien.dbai.pdfwrap.analysis;

import at.ac.tuwien.dbai.pdfwrap.analysis.CandidateCluster;
import at.ac.tuwien.dbai.pdfwrap.analysis.ISegmentationRules;
import at.ac.tuwien.dbai.pdfwrap.analysis.TextBlockSegmentationRules;
import at.ac.tuwien.dbai.pdfwrap.comparators.EdgeAttributeComparator;
import at.ac.tuwien.dbai.pdfwrap.comparators.YComparator;
import at.ac.tuwien.dbai.pdfwrap.model.document.CompositeSegment;
import at.ac.tuwien.dbai.pdfwrap.model.document.GenericSegment;
import at.ac.tuwien.dbai.pdfwrap.model.document.TextBlock;
import at.ac.tuwien.dbai.pdfwrap.model.document.TextLine;
import at.ac.tuwien.dbai.pdfwrap.model.document.TextSegment;
import at.ac.tuwien.dbai.pdfwrap.model.graph.AdjacencyEdge;
import at.ac.tuwien.dbai.pdfwrap.model.graph.AdjacencyGraph;
import at.ac.tuwien.dbai.pdfwrap.utils.ListUtils;
import at.ac.tuwien.dbai.pdfwrap.utils.SegmentUtils;
import at.ac.tuwien.dbai.pdfwrap.utils.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class PageSegmenter {
    float maxH = 0.0f;

    public PageSegmenter(AdjacencyGraph ng) {
    }

    private boolean checkHashes(Collection cols, Collection values) {
        if (cols.size() == values.size()) {
            for (GenericSegment item : cols) {
                if (values.contains(item)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    protected static boolean inSwallowGroup(CandidateCluster c, List<GenericSegment> swallowedItems, List<AdjacencyEdge<GenericSegment>> unusedEdges) {
        ArrayList<TextSegment> swallowedSegments = new ArrayList<TextSegment>();
        for (GenericSegment o : swallowedItems) {
            if (c.getItems().contains(o)) continue;
            swallowedSegments.add((TextSegment)o);
        }
        for (GenericSegment gs : swallowedItems) {
            TextSegment s = (TextSegment)gs;
            boolean foundMemberOfCGetItems = false;
            for (AdjacencyEdge<GenericSegment> e : unusedEdges) {
                if (e.getNodeFrom() != s && e.getNodeTo() != s) continue;
                if (c.getItems().contains(e.getNodeFrom())) {
                    foundMemberOfCGetItems = true;
                }
                if (!c.getItems().contains(e.getNodeTo())) continue;
                foundMemberOfCGetItems = true;
            }
            if (foundMemberOfCGetItems) continue;
            return false;
        }
        return true;
    }

    public static List<TextBlock> clusterLinesIntoTextBlocks(AdjacencyGraph<? extends GenericSegment> lineAG, int maxIterations, HashMap<GenericSegment, CandidateCluster> clustHash) {
        ArrayList<TextBlock> retVal = new ArrayList<TextBlock>();
        List<CandidateCluster> l = PageSegmenter.orderedEdgeCluster(lineAG, new TextBlockSegmentationRules(), maxIterations, clustHash);
        for (CandidateCluster c : l) {
            TextBlock tb = new TextBlock(c.getX1(), c.getX2(), c.getY1(), c.getY2(), c.getText(), c.getFontName(), c.getFontSize());
            tb.setLineSpacing(c.getLineSpacing());
            for (TextSegment ts : c.getItems()) {
                tb.getItems().add((TextLine)ts);
            }
            retVal.add(tb);
        }
        return retVal;
    }

    public static List<CandidateCluster> orderedEdgeCluster(AdjacencyGraph<? extends GenericSegment> lineAG, ISegmentationRules rules, int maxIterations, HashMap<GenericSegment, CandidateCluster> clustHash) {
        if (maxIterations <= 0) {
            maxIterations = Integer.MAX_VALUE;
        } else {
            System.out.println("running with " + maxIterations + " iterations");
        }
        long startProcess = System.currentTimeMillis();
        long t = System.currentTimeMillis();
        ArrayList<CandidateCluster> retVal = new ArrayList<CandidateCluster>();
        ArrayList<GenericSegment> unusedSegments = new ArrayList<GenericSegment>();
        ArrayList<GenericSegment> allSegments = new ArrayList<GenericSegment>();
        for (GenericSegment genericSegment : lineAG.getVertSegmentList()) {
            allSegments.add(genericSegment);
            unusedSegments.add(genericSegment);
        }
        ArrayList<AdjacencyEdge<GenericSegment>> arrayList = new ArrayList<AdjacencyEdge<GenericSegment>>();
        ArrayList<AdjacencyEdge<GenericSegment>> allEdges = new ArrayList<AdjacencyEdge<GenericSegment>>();
        for (AdjacencyEdge<? extends GenericSegment> e : lineAG.getEdges()) {
            AdjacencyEdge<GenericSegment> aegs = new AdjacencyEdge<GenericSegment>(e.getNodeFrom(), e.getNodeTo(), e.getDirection(), e.getWeight());
            arrayList.add(aegs);
            allEdges.add(aegs);
        }
        Collections.sort(arrayList, new EdgeAttributeComparator());
        HashMap<GenericSegment, List<GenericSegment>> vertNeighbourMap = new HashMap<GenericSegment, List<GenericSegment>>();
        System.out.println("priorityEdges.size: " + arrayList.size());
        System.out.println("lineAGEdges.size: " + lineAG.getEdges().size());
        int iteration = 0;
        t = System.currentTimeMillis();
        while (arrayList.size() > 0 && iteration < maxIterations) {
            CandidateCluster newc;
            List<GenericSegment> swallowedSegments;
            CandidateCluster c;
            long start = System.currentTimeMillis();
            AdjacencyEdge ae = (AdjacencyEdge)arrayList.remove(0);
            if (!(ae.getNodeFrom() instanceof TextSegment) || !(ae.getNodeTo() instanceof TextSegment)) continue;
            TextSegment segFrom = (TextSegment)ae.getNodeFrom();
            TextSegment segTo = (TextSegment)ae.getNodeTo();
            float lineSpacing = ae.physicalLength() / ae.getFontSize();
            if (++iteration % 1000 == 0) {
                System.out.println("Iteration: " + iteration + " of " + allEdges.size());
            }
            if (clustHash.get(segFrom) == null && clustHash.get(segTo) == null) {
                CandidateCluster newc2;
                if (!rules.clusterTogether(ae, null, null, allEdges, vertNeighbourMap, allSegments)) continue;
                List<GenericSegment> swallowedSegments2 = PageSegmenter.swallow(PageSegmenter.createList(segFrom), PageSegmenter.createList(segTo), allSegments, clustHash);
                if (!ae.isVertical() && (!ae.isHorizontal() || swallowedSegments2.size() > 2) || !rules.isValidCluster(newc2 = PageSegmenter.makeCluster(swallowedSegments2))) continue;
                t = System.currentTimeMillis();
                PageSegmenter.updateHashes(newc2, allSegments, clustHash, retVal, arrayList, allEdges, ae.isVertical(), vertNeighbourMap);
                t = System.currentTimeMillis();
                newc2.findBoundingBox();
                newc2.setFontSize(ae.getFontSize());
                newc2.setCalculatedFields();
                continue;
            }
            if (clustHash.get(segFrom) == null) {
                CandidateCluster newc3;
                c = clustHash.get(segTo);
                if (!rules.clusterTogether(ae, null, c, allEdges, vertNeighbourMap, allSegments)) continue;
                swallowedSegments = PageSegmenter.swallow(PageSegmenter.createList(c.getItems()), PageSegmenter.createList(segFrom), allSegments, clustHash);
                if (!ae.isVertical() && (!ae.isHorizontal() || !PageSegmenter.inSwallowGroup(c, swallowedSegments, arrayList)) || !rules.isValidCluster(newc3 = PageSegmenter.makeCluster(swallowedSegments))) continue;
                PageSegmenter.updateHashes(newc3, allSegments, clustHash, retVal, arrayList, allEdges, ae.isVertical(), vertNeighbourMap);
                t = System.currentTimeMillis();
                retVal.remove(c);
                newc3.findBoundingBox();
                newc3.setFontSize(ae.getFontSize());
                newc3.setCalculatedFields();
                t = System.currentTimeMillis();
                continue;
            }
            if (clustHash.get(segTo) == null) {
                CandidateCluster newc4;
                c = clustHash.get(segFrom);
                if (!rules.clusterTogether(ae, c, null, allEdges, vertNeighbourMap, allSegments)) continue;
                swallowedSegments = PageSegmenter.swallow(PageSegmenter.createList(c.getItems()), PageSegmenter.createList(segTo), allSegments, clustHash);
                if (!ae.isVertical() && (!ae.isHorizontal() || !PageSegmenter.inSwallowGroup(c, swallowedSegments, arrayList)) || !rules.isValidCluster(newc4 = PageSegmenter.makeCluster(swallowedSegments))) continue;
                PageSegmenter.updateHashes(newc4, allSegments, clustHash, retVal, arrayList, allEdges, ae.isVertical(), vertNeighbourMap);
                retVal.remove(c);
                newc4.findBoundingBox();
                newc4.setFontSize(ae.getFontSize());
                newc4.setCalculatedFields();
                t = System.currentTimeMillis();
                continue;
            }
            t = System.currentTimeMillis();
            CandidateCluster c1 = clustHash.get(segFrom);
            CandidateCluster c2 = clustHash.get(segTo);
            boolean skip = false;
            if (ae.isHorizontal()) {
                skip = true;
            }
            if (skip || !rules.clusterTogether(ae, c1, c2, allEdges, vertNeighbourMap, allSegments)) continue;
            List<GenericSegment> swallowedSegments3 = PageSegmenter.swallow(PageSegmenter.createList(c1.getItems()), PageSegmenter.createList(c2.getItems()), allSegments, clustHash);
            if (!ae.isVertical() && (!ae.isHorizontal() || swallowedSegments3.size() > c1.getItems().size() + c2.getItems().size()) || !rules.isValidCluster(newc = PageSegmenter.makeCluster(swallowedSegments3))) continue;
            PageSegmenter.updateHashes(newc, allSegments, clustHash, retVal, arrayList, allEdges, ae.isVertical(), vertNeighbourMap);
            newc.findBoundingBox();
            newc.setFontSize(ae.getFontSize());
            newc.setCalculatedFields();
            retVal.remove(c2);
            retVal.remove(c1);
            ae.isHorizontal();
        }
        if (arrayList.size() == 0) {
            for (GenericSegment s : allSegments) {
                if (clustHash.get(s) != null) continue;
                CandidateCluster c = PageSegmenter.makeCluster(PageSegmenter.createList(s));
                c.setCalculatedFields();
                clustHash.put(s, c);
                retVal.add(c);
            }
        }
        System.out.println("Total time for clustering: " + (System.currentTimeMillis() - startProcess));
        return retVal;
    }

    protected static void updateHashes(CandidateCluster c, List<GenericSegment> items, HashMap clustHash, List<CandidateCluster> callingRetVal, List<AdjacencyEdge<GenericSegment>> priorityEdges, List<AdjacencyEdge<GenericSegment>> allEdges, boolean performNeighbourFinding, HashMap<GenericSegment, List<GenericSegment>> vertNeighbourMap) {
        long t = System.currentTimeMillis();
        for (TextSegment ts : c.getItems()) {
            if (clustHash.get(ts) != null) {
                CandidateCluster clust = (CandidateCluster)clustHash.get(ts);
                for (TextSegment item : clust.getItems()) {
                    clustHash.remove(item);
                    callingRetVal.remove(clust);
                }
            }
            clustHash.put(ts, c);
        }
        callingRetVal.add(c);
        t = System.currentTimeMillis();
        if (performNeighbourFinding) {
            TextSegment lowestNeighbourAbove = null;
            TextSegment highestNeighbourBelow = null;
            List<GenericSegment> foo = PageSegmenter.findNearestVerticalNeighbours(c, allEdges, vertNeighbourMap);
            t = System.currentTimeMillis();
            lowestNeighbourAbove = (TextSegment)foo.get(0);
            highestNeighbourBelow = (TextSegment)foo.get(1);
            Collections.sort(c.getItems(), new YComparator());
            t = System.currentTimeMillis();
            TextSegment topItem = c.getTopElementMatchingFontsizeAfterSorting();
            TextSegment bottomItem = c.getBottomElementMatchingFontsizeAfterSorting();
            t = System.currentTimeMillis();
            if (topItem != null && bottomItem != null) {
                AdjacencyEdge<TextSegment> edgeToAdd;
                if (highestNeighbourBelow != null) {
                    edgeToAdd = new AdjacencyEdge<TextSegment>(bottomItem, highestNeighbourBelow, 3);
                    long st = System.currentTimeMillis();
                    t = System.currentTimeMillis();
                    ArrayList<AdjacencyEdge<GenericSegment>> edgesToRemove = new ArrayList<AdjacencyEdge<GenericSegment>>();
                    for (AdjacencyEdge<GenericSegment> ae : priorityEdges) {
                        if (!ae.isVertical()) continue;
                        if (ae.getNodeFrom() == highestNeighbourBelow) {
                            if (!c.getItems().contains(ae.getNodeTo())) continue;
                            edgesToRemove.add(ae);
                            continue;
                        }
                        if (ae.getNodeTo() != highestNeighbourBelow || !c.getItems().contains(ae.getNodeFrom())) continue;
                        edgesToRemove.add(ae);
                    }
                    priorityEdges.removeAll(edgesToRemove);
                    priorityEdges.add(edgeToAdd);
                    Collections.sort(priorityEdges, new EdgeAttributeComparator());
                }
                if (lowestNeighbourAbove != null) {
                    edgeToAdd = new AdjacencyEdge<TextSegment>(topItem, lowestNeighbourAbove, 2);
                    ArrayList<AdjacencyEdge<GenericSegment>> edgesToRemove = new ArrayList<AdjacencyEdge<GenericSegment>>();
                    for (AdjacencyEdge<GenericSegment> ae : priorityEdges) {
                        if (!ae.isVertical()) continue;
                        if (ae.getNodeFrom() == lowestNeighbourAbove) {
                            if (!c.getItems().contains(ae.getNodeTo())) continue;
                            edgesToRemove.add(ae);
                            continue;
                        }
                        if (ae.getNodeTo() != lowestNeighbourAbove || !c.getItems().contains(ae.getNodeFrom())) continue;
                        edgesToRemove.add(ae);
                    }
                    priorityEdges.removeAll(edgesToRemove);
                    priorityEdges.add(edgeToAdd);
                    Collections.sort(priorityEdges, new EdgeAttributeComparator());
                }
            }
            t = System.currentTimeMillis();
        }
    }

    protected static List<GenericSegment> findNearestVerticalNeighbours(GenericSegment c, List<AdjacencyEdge<GenericSegment>> allEdges, HashMap<GenericSegment, List<GenericSegment>> vertNeighbourMap) {
        if (vertNeighbourMap.containsKey(c)) {
            return vertNeighbourMap.get(c);
        }
        GenericSegment lowestNeighbourAbove = null;
        GenericSegment highestNeighbourBelow = null;
        for (AdjacencyEdge<GenericSegment> ae : allEdges) {
            GenericSegment segFrom = ae.getNodeFrom();
            GenericSegment segTo = ae.getNodeTo();
            if (!ae.isVertical()) continue;
            if (c == segFrom && c != segTo) {
                if (segTo.getYmid() > c.getY2()) {
                    if (lowestNeighbourAbove != null && !(segTo.getYmid() < lowestNeighbourAbove.getYmid())) continue;
                    lowestNeighbourAbove = segTo;
                    continue;
                }
                if (!(segTo.getYmid() < c.getY1()) || highestNeighbourBelow != null && !(segTo.getYmid() > highestNeighbourBelow.getYmid())) continue;
                highestNeighbourBelow = segTo;
                continue;
            }
            if (c == segFrom || c != segTo) continue;
            if (segFrom.getYmid() > c.getY2()) {
                if (lowestNeighbourAbove != null && !(segFrom.getYmid() < lowestNeighbourAbove.getYmid())) continue;
                lowestNeighbourAbove = segFrom;
                continue;
            }
            if (!(segFrom.getYmid() < c.getY1()) || highestNeighbourBelow != null && !(segFrom.getYmid() > highestNeighbourBelow.getYmid())) continue;
            highestNeighbourBelow = segFrom;
        }
        ArrayList<GenericSegment> retVal = new ArrayList<GenericSegment>();
        retVal.add(lowestNeighbourAbove);
        retVal.add(highestNeighbourBelow);
        vertNeighbourMap.put(c, retVal);
        return retVal;
    }

    protected static List<GenericSegment> swallow(List<GenericSegment> l1, List<GenericSegment> l2, List<GenericSegment> items, HashMap clustHash) {
        CompositeSegment<GenericSegment> temp = new CompositeSegment<GenericSegment>();
        temp.getItems().addAll(l1);
        temp.getItems().addAll(l2);
        temp.findBoundingBox();
        List<GenericSegment> swallowedItems = new ArrayList<GenericSegment>();
        boolean loop = true;
        while (loop) {
            swallowedItems = ListUtils.findElementsIntersectingBBox(items, temp);
            ArrayList newItems = new ArrayList();
            for (GenericSegment gs : swallowedItems) {
                if (clustHash.get(gs) == null) continue;
                CandidateCluster clust = (CandidateCluster)clustHash.get(gs);
                newItems.addAll(clust.getItems());
            }
            swallowedItems.addAll(newItems);
            ListUtils.removeDuplicates(swallowedItems);
            if (temp.getItems().size() == swallowedItems.size()) {
                loop = false;
            }
            temp.setItems(swallowedItems);
            temp.findBoundingBox();
        }
        return swallowedItems;
    }

    protected static CandidateCluster makeCluster(List<GenericSegment> items) {
        CandidateCluster retVal = new CandidateCluster();
        for (GenericSegment gs : items) {
            retVal.getItems().add((TextSegment)gs);
        }
        retVal.findFontSize();
        CandidateCluster tempClust = new CandidateCluster();
        for (GenericSegment gs : items) {
            tempClust.getItems().add((TextSegment)gs);
        }
        tempClust.findLines(Float.MAX_VALUE);
        retVal.setFoundLines(tempClust.getFoundLines());
        Collections.sort(retVal.getFoundLines(), new YComparator());
        retVal.findBoundingBox();
        return retVal;
    }

    public static boolean checkForChasms(CandidateCluster cts) {
        float minChasmHeight = 3.5f;
        float minChasmWidth = 0.5f;
        List<List<GenericSegment>> lineGaps = PageSegmenter.findLineGaps(cts, minChasmWidth * cts.getFontSize());
        List<GenericSegment> gaps = PageSegmenter.mergeLineGaps(lineGaps, minChasmWidth * cts.getFontSize(), minChasmHeight * cts.getFontSize());
        for (GenericSegment gap : gaps) {
            if (!(gap.getWidth() > minChasmWidth * cts.getFontSize()) || !(gap.getHeight() > minChasmHeight * cts.getFontSize())) continue;
            return true;
        }
        return false;
    }

    public static List<List<GenericSegment>> findLineGaps(CandidateCluster cts, float minWidth) {
        ArrayList<List<GenericSegment>> retVal = new ArrayList<List<GenericSegment>>();
        for (CompositeSegment<? extends TextSegment> l : cts.getFoundLines()) {
            ArrayList<GenericSegment> lineGaps = new ArrayList<GenericSegment>();
            int n = 1;
            while (n < l.getItems().size()) {
                GenericSegment a = l.getItems().get(n - 1);
                GenericSegment b = l.getItems().get(n);
                if (b.getX1() - a.getX2() > minWidth) {
                    float newY1 = Utils.maximum(a.getY1(), b.getY1());
                    float newY2 = Utils.minimum(a.getY2(), b.getY2());
                    GenericSegment gapSeg = new GenericSegment(a.getX2(), b.getX1(), newY1, newY2);
                    lineGaps.add(gapSeg);
                }
                ++n;
            }
            retVal.add(lineGaps);
        }
        return retVal;
    }

    public static List<GenericSegment> mergeLineGaps(List<List<GenericSegment>> lineGaps, float minWidth, float minHeight) {
        ArrayList<GenericSegment> retVal = new ArrayList<GenericSegment>();
        int n = 1;
        while (n <= lineGaps.size()) {
            List<GenericSegment> thisLineGaps = lineGaps.get(n - 1);
            List<Object> nextLineGaps = new ArrayList();
            if (n < lineGaps.size()) {
                nextLineGaps = lineGaps.get(n);
            }
            boolean potentialNewGap = false;
            float lastX2 = -1.0f;
            float lastY1 = -1.0f;
            float lastY2 = -1.0f;
            int lastIndex = -1;
            int i = 0;
            while (i < thisLineGaps.size()) {
                GenericSegment thisGap = thisLineGaps.get(i);
                boolean intersects = false;
                boolean addedGap = false;
                if (potentialNewGap && lastX2 >= thisGap.getX1()) {
                    float newX2 = lastX2;
                    if (lastX2 <= thisGap.getX2()) {
                        potentialNewGap = false;
                        newX2 = thisGap.getX2();
                    }
                    GenericSegment newGap = new GenericSegment(thisGap.getX1(), newX2, lastY1, thisGap.getY2());
                    nextLineGaps.add(lastIndex + 1, newGap);
                    addedGap = true;
                    intersects = true;
                }
                if (!addedGap) {
                    int j = 0;
                    while (j < nextLineGaps.size()) {
                        GenericSegment nextGap = (GenericSegment)nextLineGaps.get(j);
                        if (SegmentUtils.horizIntersect(thisGap, nextGap)) {
                            intersects = true;
                            nextGap.setY2(thisGap.getY2());
                            if (thisGap.getX1() > nextGap.getX1()) {
                                nextGap.setX1(thisGap.getX1());
                            }
                            if (thisGap.getX2() < nextGap.getX2()) {
                                lastX2 = nextGap.getX2();
                                lastY1 = nextGap.getY1();
                                lastY2 = nextGap.getY2();
                                nextGap.setX2(thisGap.getX2());
                                potentialNewGap = true;
                                lastIndex = j;
                            } else {
                                potentialNewGap = false;
                            }
                        }
                        ++j;
                    }
                }
                if (!intersects) {
                    retVal.add(thisGap);
                }
                ++i;
            }
            ++n;
        }
        return retVal;
    }

    protected static List<GenericSegment> createList(GenericSegment gs) {
        ArrayList<GenericSegment> retVal = new ArrayList<GenericSegment>();
        retVal.add(gs);
        return retVal;
    }

    protected static List<GenericSegment> createList(List<? extends GenericSegment> l) {
        ArrayList<GenericSegment> retVal = new ArrayList<GenericSegment>();
        for (GenericSegment genericSegment : l) {
            retVal.add(genericSegment);
        }
        return retVal;
    }
}

