/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset;

import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordTransBuilderIF;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dataset.transform.AlbersEqualArea;
import ucar.nc2.dataset.transform.FlatEarth;
import ucar.nc2.dataset.transform.LambertAzimuthal;
import ucar.nc2.dataset.transform.LambertConformalConic;
import ucar.nc2.dataset.transform.MSGnavigation;
import ucar.nc2.dataset.transform.Mercator;
import ucar.nc2.dataset.transform.Orthographic;
import ucar.nc2.dataset.transform.PolarStereographic;
import ucar.nc2.dataset.transform.RotatedLatLon;
import ucar.nc2.dataset.transform.RotatedPole;
import ucar.nc2.dataset.transform.Stereographic;
import ucar.nc2.dataset.transform.TransverseMercator;
import ucar.nc2.dataset.transform.UTM;
import ucar.nc2.dataset.transform.VAtmHybridHeight;
import ucar.nc2.dataset.transform.VAtmHybridSigmaPressure;
import ucar.nc2.dataset.transform.VAtmSigma;
import ucar.nc2.dataset.transform.VExplicitField;
import ucar.nc2.dataset.transform.VOceanS;
import ucar.nc2.dataset.transform.VOceanSG1;
import ucar.nc2.dataset.transform.VOceanSG2;
import ucar.nc2.dataset.transform.VOceanSigma;
import ucar.nc2.dataset.transform.VerticalPerspective;
import ucar.unidata.util.Parameter;

public class CoordTransBuilder {
    private static Logger log = LoggerFactory.getLogger(CoordTransBuilder.class);
    private static List<Transform> transformList = new ArrayList<Transform>();
    private static boolean userMode = false;
    private static boolean loadWarnings = false;

    public static void registerTransform(String transformName, Class c) {
        if (!CoordTransBuilderIF.class.isAssignableFrom(c)) {
            throw new IllegalArgumentException("Class " + c.getName() + " must implement CoordTransBuilderIF");
        }
        try {
            c.newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("CoordTransBuilderIF Class " + c.getName() + " cannot instantiate, probably need default Constructor");
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("CoordTransBuilderIF Class " + c.getName() + " is not accessible");
        }
        if (userMode) {
            transformList.add(0, new Transform(transformName, c));
        } else {
            transformList.add(new Transform(transformName, c));
        }
    }

    public static void registerTransform(String transformName, String className) throws ClassNotFoundException {
        Class<?> c = Class.forName(className);
        CoordTransBuilder.registerTransform(transformName, c);
    }

    public static void registerTransformMaybe(String transformName, String className) {
        Class<?> c = null;
        try {
            c = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            log.warn("Coordinate Transform Class " + className + " not found.");
        }
        CoordTransBuilder.registerTransform(transformName, c);
    }

    public static CoordinateTransform makeCoordinateTransform(NetcdfDataset ds, Variable ctv, Formatter parseInfo, Formatter errInfo) {
        String transform_name = ds.findAttValueIgnoreCase(ctv, "transform_name", null);
        if (null == transform_name) {
            transform_name = ds.findAttValueIgnoreCase(ctv, "Projection_Name", null);
        }
        if (null == transform_name) {
            transform_name = ds.findAttValueIgnoreCase(ctv, "grid_mapping_name", null);
        }
        if (null == transform_name) {
            transform_name = ds.findAttValueIgnoreCase(ctv, "standard_name", null);
        }
        if (null == transform_name) {
            parseInfo.format("**Failed to find Coordinate Transform name from Variable= %s\n", ctv);
            return null;
        }
        transform_name = transform_name.trim();
        Class builderClass = null;
        for (Transform transform : transformList) {
            if (!transform.transName.equals(transform_name)) continue;
            builderClass = transform.transClass;
            break;
        }
        if (null == builderClass) {
            parseInfo.format("**Failed to find CoordTransBuilder name= %s from Variable= %s\n", transform_name, ctv);
            return null;
        }
        CoordTransBuilderIF builder = null;
        try {
            builder = (CoordTransBuilderIF)builderClass.newInstance();
        }
        catch (InstantiationException e) {
            log.error("Cant instantiate " + builderClass.getName(), e);
        }
        catch (IllegalAccessException e) {
            log.error("Cant access " + builderClass.getName(), e);
        }
        if (null == builder) {
            parseInfo.format("**Failed to build CoordTransBuilder object from class= %s for Variable= %s\n", builderClass.getName(), ctv);
            return null;
        }
        builder.setErrorBuffer(errInfo);
        CoordinateTransform ct = builder.makeCoordinateTransform(ds, ctv);
        if (ct != null) {
            parseInfo.format(" Made Coordinate transform %s from variable %s: %s\n", transform_name, ctv.getName(), builder);
        }
        return ct;
    }

    public static VariableDS makeDummyTransformVariable(NetcdfDataset ds, CoordinateTransform ct) {
        VariableDS v = new VariableDS(ds, null, null, ct.getName(), DataType.CHAR, "", null, null);
        List<Parameter> params = ct.getParameters();
        for (Parameter p : params) {
            if (p.isString()) {
                v.addAttribute(new Attribute(p.getName(), p.getStringValue()));
                continue;
            }
            double[] data = p.getNumericValues();
            Array dataA = Array.factory(Double.TYPE, new int[]{data.length}, (Object)data);
            v.addAttribute(new Attribute(p.getName(), dataA));
        }
        v.addAttribute(new Attribute("_CoordinateTransformType", ct.getTransformType().toString()));
        Array data = Array.factory(DataType.CHAR.getPrimitiveClassType(), new int[0], (Object)new char[]{' '});
        v.setCachedData(data, true);
        return v;
    }

    static {
        CoordTransBuilder.registerTransform("albers_conical_equal_area", AlbersEqualArea.class);
        CoordTransBuilder.registerTransform("flat_earth", FlatEarth.class);
        CoordTransBuilder.registerTransform("lambert_azimuthal_equal_area", LambertAzimuthal.class);
        CoordTransBuilder.registerTransform("lambert_conformal_conic", LambertConformalConic.class);
        CoordTransBuilder.registerTransformMaybe("mcidas_area", "ucar.nc2.iosp.mcidas.McIDASAreaTransformBuilder");
        CoordTransBuilder.registerTransform("mercator", Mercator.class);
        CoordTransBuilder.registerTransform("MSGnavigation", MSGnavigation.class);
        CoordTransBuilder.registerTransform("orthographic", Orthographic.class);
        CoordTransBuilder.registerTransform("polar_stereographic", PolarStereographic.class);
        CoordTransBuilder.registerTransform("rotated_latitude_longitude", RotatedPole.class);
        CoordTransBuilder.registerTransform("rotated_latlon_grib", RotatedLatLon.class);
        CoordTransBuilder.registerTransform("stereographic", Stereographic.class);
        CoordTransBuilder.registerTransform("transverse_mercator", TransverseMercator.class);
        CoordTransBuilder.registerTransform("vertical_perspective", VerticalPerspective.class);
        CoordTransBuilder.registerTransform("UTM", UTM.class);
        CoordTransBuilder.registerTransform("atmosphere_hybrid_height_coordinate", VAtmHybridHeight.class);
        CoordTransBuilder.registerTransform("atmosphere_hybrid_sigma_pressure_coordinate", VAtmHybridSigmaPressure.class);
        CoordTransBuilder.registerTransform("atmosphere_sigma_coordinate", VAtmSigma.class);
        CoordTransBuilder.registerTransform("ocean_s_coordinate", VOceanS.class);
        CoordTransBuilder.registerTransform("ocean_sigma_coordinate", VOceanSigma.class);
        CoordTransBuilder.registerTransform("explicit_field", VExplicitField.class);
        CoordTransBuilder.registerTransform("existing3DField", VExplicitField.class);
        CoordTransBuilder.registerTransform("ocean_s_coordinate_g1", VOceanSG1.class);
        CoordTransBuilder.registerTransform("ocean_s_coordinate_g2", VOceanSG2.class);
        userMode = true;
    }

    private static class Transform {
        String transName;
        Class transClass;

        Transform(String transName, Class transClass) {
            this.transName = transName;
            this.transClass = transClass;
        }
    }
}

