package App::InteractivePerlTutorial::Chapter::Sub::Arguments;

use 5.014000;
use strict;
use warnings;
our $VERSION = '0.000_001';

use constant TEXT => 'Arguments';

use constant EXERCISES => [
	{ statement => 'Make a program that reads numbers on different lines and that has a subroutine that adds 5 to each one of them and returns their maximum. Print the result on the screen', input => "1\n2\n57\n", check => sub { $_[1] eq '62' }, solution => <<'SOL' },
sub printmax {
  my $max = shift;
  foreach (@_) {
    if ($_ > $max) {
      $max = $_;
    }
  }

  return $max + 5;
}

printmax <>
SOL
];

1;
__DATA__

=encoding utf-8

=head1 Arguments

Instead of using global variables in subroutines in the last chapters, you can give values as arguments.
For example, if you have a subroutine named max that returns the maximum between two values you can write in the main program:

  say &max(2,3);   # says 3

Arguments are given to the subroutine as a list in a special variable @_.
In the example above, $_[0] would be 2 and $_[1] would be 3;
The maximum function between 2 numbers could look like that:

  sub max {
	if ($_[0]>$_[1]) {
		return $_[0];
	} else {
		return $_[1];
	}
  }

The function above only uses the first 2 arguments, but you can write the function to use as many arguments as it is given:

  sub max_improved {
	my $max_val=shift @_;    #Local variable, takes the value of the first argument
	foreach (@_)	# Takes all the other arguments
	{
		if ($_>$max_val)  # Checks if the arguments are bigger than the current maximum
		{
			$max_val=$_;
		}
	}
	return $max_val;
  }


=cut
