/*
 * Decompiled with CFR 0.152.
 */
package org.couchbase.mock.memcached;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.LinkedList;
import java.util.Queue;
import org.couchbase.mock.memcached.BinaryProtocolHandler;
import org.couchbase.mock.memcached.MemcachedServer;
import org.couchbase.mock.memcached.protocol.BinaryCommand;
import org.couchbase.mock.memcached.protocol.BinaryResponse;
import org.couchbase.mock.memcached.protocol.CommandFactory;

public class MemcachedConnection {
    private BinaryProtocolHandler protocolHandler;
    private final byte[] header;
    private BinaryCommand command;
    private final ByteBuffer input;
    private final Queue<ByteBuffer> output;
    private boolean authenticated;
    private boolean closed = false;

    public MemcachedConnection(MemcachedServer server) throws IOException {
        this.authenticated = server.getBucket().getPassword().length() <= 0;
        this.header = new byte[24];
        this.input = ByteBuffer.wrap(this.header);
        this.protocolHandler = server.getProtocolHandler();
        this.output = new LinkedList<ByteBuffer>();
    }

    public void step() throws IOException {
        if (this.closed) {
            throw new ClosedChannelException();
        }
        if (this.input.position() == this.header.length) {
            if (this.command == null) {
                this.command = CommandFactory.create(this.input);
            }
            if (this.command.complete()) {
                this.protocolHandler.execute(this.command, this);
                this.command = null;
                this.input.rewind();
            }
        }
    }

    public void sendResponse(BinaryResponse response) {
        this.output.add(response.getBuffer());
    }

    boolean hasOutput() {
        return !this.output.isEmpty();
    }

    public ByteBuffer getInputBuffer() {
        if (this.command == null) {
            return this.input;
        }
        return this.command.getInputBuffer();
    }

    public ByteBuffer getOutputBuffer() {
        if (this.output.isEmpty()) {
            return null;
        }
        return this.output.remove();
    }

    void shutdown() {
        this.closed = true;
    }

    boolean isClosed() {
        return this.closed;
    }

    void setAuthenticated(boolean state) {
        this.authenticated = state;
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }
}

