#!/usr/bin/env perl

use strict;
use warnings;

use Encode qw(encode_utf8);
use English;
use Error::Pure qw(err);
use Map::Tube::Text::Table;

# Error::Pure environment.
$ENV{'ERROR_PURE'} = 'AllError';

# Arguments.
if (@ARGV < 1) {
        print STDERR "Usage: $0 metro\n";
        exit 1;
}
my $metro = $ARGV[0];

# Object.
my $class = 'Map::Tube::'.$metro;
eval "require $class;";
if ($EVAL_ERROR) {
        err "Cannot load '$class' class.",
                'Error', $EVAL_ERROR;
}

# Metro object.
my $tube = eval "$class->new";
if ($EVAL_ERROR) {
        err "Cannot create object for '$class' class.",
                'Error', $EVAL_ERROR;
}

# GraphViz object.
my $table = Map::Tube::Text::Table->new(
        'tube' => $tube,
);

# Print out.
print encode_utf8($table->print);

# Output without arguments like:
# Usage: /tmp/SZXfa2g154 metro

# Output with 'Tbilisi' argument like:
# ┌──────────────────────────────────────────────────────────────────────────────────────────────────┐
# │ Junctions                                                                                        │
# ├──────────────────┬──────────────────────────────────────────┬────────────────────────────────────┤
# │ Station          │ Line                                     │ Connected to                       │
# ├──────────────────┼──────────────────────────────────────────┼────────────────────────────────────┤
# │ სადგურის მოედანი │ ახმეტელი-ვარკეთილის ხაზი,საბურთალოს ხაზი │ მარჯანიშვილი, ნაძალადევი, წერეთელი │
# └──────────────────┴──────────────────────────────────────────┴────────────────────────────────────┘
# ┌───────────────────────────────────────────────────────────┐
# │ Line 'ახმეტელი-ვარკეთილის ხაზი'                           │
# ├──────────────────────┬────────────────────────────────────┤
# │ Station              │ Connected to                       │
# ├──────────────────────┼────────────────────────────────────┤
# │ ახმეტელის თეატრი     │ სარაჯიშვილი                        │
# │ სარაჯიშვილი          │ ახმეტელის თეატრი, გურამიშვილი      │
# │ გურამიშვილი          │ სარაჯიშვილი, ღრმაღელე              │
# │ ღრმაღელე             │ გურამიშვილი, დიდუბე                │
# │ დიდუბე               │ გოცირიძე, ღრმაღელე                 │
# │ გოცირიძე             │ დიდუბე, ნაძალადევი                 │
# │ ნაძალადევი           │ გოცირიძე, სადგურის მოედანი         │
# │ მარჯანიშვილი         │ რუსთაველი, სადგურის მოედანი        │
# │ რუსთაველი            │ თავისუფლების მოედანი, მარჯანიშვილი │
# │ თავისუფლების მოედანი │ ავლაბარი, რუსთაველი                │
# │ ავლაბარი             │ 300 არაგველი, თავისუფლების მოედანი │
# │ 300 არაგველი         │ ავლაბარი, ისანი                    │
# │ ისანი                │ 300 არაგველი, სამგორი              │
# │ სამგორი              │ ვარკეთილი, ისანი                   │
# │ ვარკეთილი            │ სამგორი                            │
# │ სადგურის მოედანი     │ მარჯანიშვილი, ნაძალადევი, წერეთელი │
# └──────────────────────┴────────────────────────────────────┘
# ┌────────────────────────────────────────────────────────────────────┐
# │ Line 'საბურთალოს ხაზი'                                             │
# ├─────────────────────────┬──────────────────────────────────────────┤
# │ Station                 │ Connected to                             │
# ├─────────────────────────┼──────────────────────────────────────────┤
# │ წერეთელი                │ სადგურის მოედანი, ტექნიკური უნივერსიტეტი │
# │ ტექნიკური უნივერსიტეტი  │ სამედიცინო უნივერსიტეტი, წერეთელი        │
# │ სამედიცინო უნივერსიტეტი │ დელისი, ტექნიკური უნივერსიტეტი           │
# │ დელისი                  │ ვაჟა-ფშაველა, სამედიცინო უნივერსიტეტი    │
# │ ვაჟა-ფშაველა            │ დელისი                                   │
# │ სადგურის მოედანი        │ მარჯანიშვილი, ნაძალადევი, წერეთელი       │
# └─────────────────────────┴──────────────────────────────────────────┘