#!/usr/bin/perl

package eBay::API::XML::DataType::ExpressHistogramDepartmentType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. ExpressHistogramDepartmentType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::ExpressHistogramDepartmentType

=head1 DESCRIPTION

Details about an Express department and matching item and catalog product counts 
in that department, if any.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::ExpressHistogramDepartmentType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::ExpressHistogramAisleType;
use eBay::API::XML::DataType::ExpressHistogramDomainDetailsType;


my @gaProperties = ( [ 'Aisle', 'ns:ExpressHistogramAisleType', '1'
	     ,'eBay::API::XML::DataType::ExpressHistogramAisleType', '1' ]
	, [ 'DomainDetails', 'ns:ExpressHistogramDomainDetailsType', ''
	     ,'eBay::API::XML::DataType::ExpressHistogramDomainDetailsType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setAisle()

Contains item and catalog product counts for an aisle (if any) and may contain a list of product types.
Only returned when HistogramDetails is configured to return aisles and/or product types.<br>
<br>
A Department node can contain multiple Aisle nodes.

#    Argument: reference to an array  
                      of 'ns:ExpressHistogramAisleType'

=cut

sub setAisle {
  my $self = shift;
  $self->{'Aisle'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getAisle()

#    Returns: reference to an array  
                      of 'ns:ExpressHistogramAisleType'

=cut

sub getAisle {
  my $self = shift;
  return $self->_getDataTypeArray('Aisle');
}


=head2 setDomainDetails()

Identifies the department and provides matching item and 
eBay catalog product counts in the specified department.
Only returned if a department matched the request.<br>
<br>
If this node is missing but Department.Aisle.ProductType is present, it means that the product type 
specified in Department.Aisle.ProductType is not grouped into a department.
In the Express Web site UI, stand-alone product types are elevated to (treated as) departments
from the user's perspective. However, the API always maintains the Department/Aisle/ProductType
structure to help you distinguish between actual departments, aisles, and stand-alone product types.

#    Argument: 'ns:ExpressHistogramDomainDetailsType'

=cut

sub setDomainDetails {
  my $self = shift;
  $self->{'DomainDetails'} = shift
}

=head2 getDomainDetails()

#    Returns: 'ns:ExpressHistogramDomainDetailsType'

=cut

sub getDomainDetails {
  my $self = shift;
  return $self->_getDataTypeInstance( 'DomainDetails'
		,'eBay::API::XML::DataType::ExpressHistogramDomainDetailsType');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
