/*
 * Decompiled with CFR 0.152.
 */
package org.couchbase.mock.memcached.protocol;

public enum CommandCode {
    GET(0),
    SET(1),
    ADD(2),
    REPLACE(3),
    DELETE(4),
    INCREMENT(5),
    DECREMENT(6),
    QUIT(7),
    FLUSH(8),
    GETQ(9),
    NOOP(10),
    VERSION(11),
    GETK(12),
    GETKQ(13),
    APPEND(14),
    PREPEND(15),
    STAT(16),
    SETQ(17),
    ADDQ(18),
    REPLACEQ(19),
    DELETEQ(20),
    INCREMENTQ(21),
    DECREMENTQ(22),
    QUITQ(23),
    FLUSHQ(24),
    APPENDQ(25),
    PREPENDQ(26),
    VERBOSITY(27),
    TOUCH(28),
    GAT(29),
    GATQ(30),
    SASL_LIST_MECHS(32),
    SASL_AUTH(33),
    SASL_STEP(34),
    RGET(48),
    RSET(49),
    RSETQ(50),
    RAPPEND(51),
    RAPPENDQ(52),
    RPREPEND(53),
    RPREPENDQ(54),
    RDELETE(55),
    RDELETEQ(56),
    RINCR(57),
    RINCRQ(58),
    RDECR(59),
    RDECRQ(60),
    SET_VBUCKET(61),
    GET_VBUCKET(62),
    DEL_VBUCKET(63),
    TAP_CONNECT(64),
    TAP_MUTATION(65),
    TAP_DELETE(66),
    TAP_FLUSH(67),
    TAP_OPAQUE(68),
    TAP_VBUCKET_SET(69),
    LAST_RESERVED(239),
    SCRUB(240),
    GET_REPLICA(131),
    OBSERVE(146),
    EVICT(147),
    GETL(148),
    UNL(149),
    GET_CLUSTER_CONFIG(181),
    HELLO(31),
    ILLEGAL(255),
    OBSERVE_SEQNO(145);

    private final int value;

    private CommandCode(int value) {
        this.value = value;
    }

    public int cc() {
        return this.value;
    }

    public static CommandCode valueOf(int cc) {
        switch (cc) {
            case 0: {
                return GET;
            }
            case 1: {
                return SET;
            }
            case 2: {
                return ADD;
            }
            case 3: {
                return REPLACE;
            }
            case 4: {
                return DELETE;
            }
            case 5: {
                return INCREMENT;
            }
            case 6: {
                return DECREMENT;
            }
            case 7: {
                return QUIT;
            }
            case 8: {
                return FLUSH;
            }
            case 9: {
                return GETQ;
            }
            case 10: {
                return NOOP;
            }
            case 11: {
                return VERSION;
            }
            case 12: {
                return GETK;
            }
            case 13: {
                return GETKQ;
            }
            case 14: {
                return APPEND;
            }
            case 15: {
                return PREPEND;
            }
            case 16: {
                return STAT;
            }
            case 17: {
                return SETQ;
            }
            case 18: {
                return ADDQ;
            }
            case 19: {
                return REPLACEQ;
            }
            case 20: {
                return DELETEQ;
            }
            case 21: {
                return INCREMENTQ;
            }
            case 22: {
                return DECREMENTQ;
            }
            case 23: {
                return QUITQ;
            }
            case 24: {
                return FLUSHQ;
            }
            case 25: {
                return APPENDQ;
            }
            case 26: {
                return PREPENDQ;
            }
            case 27: {
                return VERBOSITY;
            }
            case 28: {
                return TOUCH;
            }
            case 29: {
                return GAT;
            }
            case 30: {
                return GATQ;
            }
            case 32: {
                return SASL_LIST_MECHS;
            }
            case 33: {
                return SASL_AUTH;
            }
            case 34: {
                return SASL_STEP;
            }
            case -109: {
                return EVICT;
            }
            case -108: {
                return GETL;
            }
            case -107: {
                return UNL;
            }
            case -125: {
                return GET_REPLICA;
            }
            case -110: {
                return OBSERVE;
            }
            case -75: {
                return GET_CLUSTER_CONFIG;
            }
            case 31: {
                return HELLO;
            }
            case -111: {
                return OBSERVE_SEQNO;
            }
        }
        return ILLEGAL;
    }

    static String toString(CommandCode cc) {
        switch (cc) {
            case SET: {
                return "set";
            }
            case ADD: {
                return "add";
            }
            case REPLACE: {
                return "replace";
            }
            case FLUSH: {
                return "flush";
            }
            case DELETE: {
                return "delete";
            }
            case INCREMENT: {
                return "increment";
            }
            case DECREMENT: {
                return "decrement";
            }
            case PREPEND: {
                return "prepend";
            }
            case APPEND: {
                return "append";
            }
            case VERSION: {
                return "version";
            }
            case NOOP: {
                return "noop";
            }
            case QUIT: {
                return "quit";
            }
            case GET: {
                return "get";
            }
            case GETQ: {
                return "getq";
            }
            case GETK: {
                return "getk";
            }
            case GETKQ: {
                return "getkq";
            }
            case ILLEGAL: {
                return "Illegal";
            }
            case STAT: {
                return "stat";
            }
            case SETQ: {
                return "setq";
            }
            case ADDQ: {
                return "addq";
            }
            case REPLACEQ: {
                return "replaceq";
            }
            case DELETEQ: {
                return "deleteq";
            }
            case INCREMENTQ: {
                return "incrementq";
            }
            case DECREMENTQ: {
                return "decrementq";
            }
            case QUITQ: {
                return "quitq";
            }
            case FLUSHQ: {
                return "flushq";
            }
            case APPENDQ: {
                return "appendq";
            }
            case PREPENDQ: {
                return "prependq";
            }
            case VERBOSITY: {
                return "verbosity";
            }
            case SASL_LIST_MECHS: {
                return "sasl_list_mechs";
            }
            case SASL_AUTH: {
                return "sasl_auth";
            }
            case SASL_STEP: {
                return "sasl_step";
            }
            case TOUCH: {
                return "touch";
            }
            case GAT: {
                return "gat";
            }
            case GATQ: {
                return "gatq";
            }
            case EVICT: {
                return "evict";
            }
            case GETL: {
                return "getl";
            }
            case UNL: {
                return "unl";
            }
            case GET_REPLICA: {
                return "get_replica";
            }
            case OBSERVE: {
                return "observe";
            }
            case GET_CLUSTER_CONFIG: {
                return "get_cluster_config";
            }
            case HELLO: {
                return "hello";
            }
            case OBSERVE_SEQNO: {
                return "observe_seqno";
            }
        }
        return "unknown";
    }
}

