#!perl -T

use Test;
use strict;

plan(tests => 3);


# Test 1: See if the module loads

eval 'use Lingua::EL::Poly2Mono  "poly2mono"';
ok($@ eq '');


# Test 2: Byte-mode conversion

ok(
	poly2mono(
		 "\xce\xa4\xce\xbf\xe1\xbd\x90\xce\xbb\xe1\xbd\xb1\xcf\x87\xce"
       . "\xb9\xcf\x83\xcf\x84\xce\xbf\xce\xbd \xce\xb8\xe1\xbd\xb3\xce"
       . "\xbb\xcf\x89 \xce\xbd\xe1\xbc\x84\xcf\x83\xcf\x84\xce\xb1\xce"
       . "\xb9 \xce\xba\xce\xb1\xce\xbb\xe1\xbd\xb1!"
	)
	
	eq
	
	    "\xce\xa4\xce\xbf\xcf\x85\xce\xbb\xce\xac\xcf\x87\xce\xb9\xcf"
      . "\x83\xcf\x84\xce\xbf\xce\xbd \xce\xb8\xce\xad\xce\xbb\xcf\x89"
      . " \xce\xbd\xce\xb1 \xce\x84\xcf\x83\xcf\x84\xce\xb1\xce\xb9 "
      . "\xce\xba\xce\xb1\xce\xbb\xce\xac!"
);


# Test 3: Unicode-mode conversion

$Lingua::EL::Poly2Mono::OLD_PERL = $Lingua::EL::Poly2Mono::OLD_PERL;
skip($Lingua::EL::Poly2Mono::OLD_PERL && 'Skipped test 3 in absence of Encode::is_utf8',
	sub {
		 poly2mono(
         "\x{03a4}\x{03bf}\x{1f50}\x{03bb}\x{1f71}\x{03c7}\x{03b9}"
      .  "\x{03c3}\x{03c4}\x{03bf}\x{03bd} \x{03b8}\x{1f73}\x{03bb}"
      .  "\x{03c9} \x{03bd}\x{1f04}\x{03c3}\x{03c4}\x{03b1}\x{03b9} "
      .  "\x{03ba}\x{03b1}\x{03bb}\x{1f71}!"
	     )
		 
		 eq
		 
        "\x{03a4}\x{03bf}\x{03c5}\x{03bb}\x{03ac}\x{03c7}\x{03b9}"
      . "\x{03c3}\x{03c4}\x{03bf}\x{03bd} \x{03b8}\x{03ad}\x{03bb}"
      . "\x{03c9} \x{03bd}\x{03b1} \x{0384}\x{03c3}\x{03c4}\x{03b1}"
      . "\x{03b9} \x{03ba}\x{03b1}\x{03bb}\x{03ac}!"
	}
);
	
