#!/usr/bin/perl

package eBay::API::XML::Call::SetReturnURL;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. SetReturnURL.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 07/07/2008 17:42
# API Release Number: ... 571
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::SetReturnURL

=head1 DESCRIPTION



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::SetReturnURL inherits from the L<eBay::API::XML::BaseCall> class

=cut

use eBay::API::XML::BaseCall;
our @ISA = ("eBay::API::XML::BaseCall");

use eBay::API::XML::Call::SetReturnURL::SetReturnURLRequestType;
use eBay::API::XML::Call::SetReturnURL::SetReturnURLResponseType;


=head1 Subroutines:

=cut

sub getApiCallName {
   return 'SetReturnURL';
}
sub getRequestDataTypeFullPackage {
   return 'eBay::API::XML::Call::SetReturnURL::SetReturnURLRequestType';
}
sub getResponseDataTypeFullPackage {
   return 'eBay::API::XML::Call::SetReturnURL::SetReturnURLResponseType';
}

#
# input properties
#

=head2 setAction()

Specifies whether the authentication entry is being added, deleted, or
modified.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=AuthNAuth
Title: Authentication & Authorization

  RequiredInput: Yes
#    Argument: 'ns:ModifyActionCodeType'

=cut
       
sub setAction {
   my $self   = shift;
   my $sAction = shift;
   $self->getRequestDataType()->setAction($sAction);
}

=head2 setApplicationDisplayName()

Sets an application display name for the eBay sign-in page.
Need not be set with every call. Optional.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=AuthNAuth
Title: Authentication & Authorization

  RequiredInput: No
#    Argument: 'xs:string'

=cut
       
sub setApplicationDisplayName {
   my $self   = shift;
   my $sApplicationDisplayName = shift;
   $self->getRequestDataType()->setApplicationDisplayName($sApplicationDisplayName);
}

=head2 setAuthenticationEntry()

The authentication preferences and other data that you are
adding, deleting, or modifying.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=AuthNAuth
Title: Authentication & Authorization

  RequiredInput: Yes
#    Argument: 'ns:AuthenticationEntryType'

=cut
       
sub setAuthenticationEntry {
   my $self   = shift;
   my $pAuthenticationEntry = shift;
   $self->getRequestDataType()->setAuthenticationEntry($pAuthenticationEntry);
}



#
# output properties
#





1;   
