#!perl -T
use 5.006;
use strict;
use warnings;
use Test::More;
use File::Temp ();
use Crypt::LE ':errors';
$|=1;
plan tests => 9;

my $le = Crypt::LE->new(autodir => 0);

can_ok($le, 'directory');
can_ok($le, 'register');
can_ok($le, 'accept_tos');
can_ok($le, 'request_challenge');
can_ok($le, 'accept_challenge');
can_ok($le, 'verify_challenge');
can_ok($le, 'request_certificate');
can_ok($le, 'request_issuer_certificate');

# We don't want to ship the same account key to everyone with this module and
# we don't really want to pollute Let's Encrypt staging server with multiple odd
# registrations, so just making sure that interaction works.

ok($le->directory() == OK, 'loading resources directory');

diag( "Testing Crypt::LE $Crypt::LE::VERSION, Workflow methods, $^X" );
