package TableData::Object;

our $DATE = '2015-10-29'; # DATE
our $VERSION = '0.04'; # VERSION

use 5.010001;
use strict;
use warnings;

use Data::Check::Structure qw(is_aos is_aoaos is_aohos);

require Exporter;
our @ISA = qw(Exporter);
our @EXPORT_OK = qw(table);

sub table { __PACKAGE__->new(@_) }

sub new {
    my ($class, $data, $spec) = @_;
    if (!defined($data)) {
        die "Please specify table data";
    } elsif (ref($data) eq 'HASH') {
        TableData::Object::hash->new($data);
    } elsif (is_aos($data, {max=>10})) {
        TableData::Object::aos->new($data);
    } elsif (is_aoaos($data, {max=>10})) {
        TableData::Object::aoaos->new($data, $spec);
    }elsif (is_aohos($data, {max=>10})) {
        TableData::Object::aohos->new($data, $spec);
    } else {
        die "Unknown table data form, please supply array of scalar, ".
            "array of array of scalar, or array of hash of scalar";
    }
}

1;
# ABSTRACT: Manipulate data structure via table object

__END__

=pod

=encoding UTF-8

=head1 NAME

TableData::Object - Manipulate data structure via table object

=head1 VERSION

This document describes version 0.04 of TableData::Object (from Perl distribution TableData-Object), released on 2015-10-29.

=for Pod::Coverage .+

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/TableData-Object>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-TableData-Object>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=TableData-Object>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
