use strict;
use warnings;

use Test::More qw(no_plan);
use Data::Dumper;

my %base_files_and_counts = (
    't/test-code/perl/slocrunner.pl'                                    => 23,  
    't/test-code/perl/stddeviation.pl'                                  => 12,
    't/test-code/perl/Utility/Rule.pm'                                  => 40,
    't/test-code/perl/Utility/StandardDeviation.pm'                     => 22,
    't/test-code/perl/Utility/SLOCCounter.pm'                           => 73,
    't/test-code/perl/Utility/Utility.pm'                               => 4,
    't/test-code/com/raptnor/io/BasicDirectoryWalkerCallback.java'      =>15,
    't/test-code/com/raptnor/io/DirectoryWalker.java'                   =>26,
    't/test-code/com/raptnor/io/DirectoryWalkerCallback.java'           =>6,
    't/test-code/com/raptnor/psp/statistics/StandardDeviation.java'     =>29,
);

my %results;
my $base_count = 250;
my $results_base_count;

BEGIN { use_ok( 'Metrics::CodeCounter' ); }

ok(%results = base_count('t/test-code', 't/standards.xml'), 'We did receive actual results');

my ($result_count, $base_file_count);
$result_count    = keys %results;
$base_file_count = keys %base_files_and_counts;
ok($result_count == $base_file_count, 'File counts are the same');

foreach my $file (keys %base_files_and_counts){
    my ($bcount, $rcount);
    ok( exists $results{$file}, "$file exists in results" );
    $bcount = $base_files_and_counts{$file};
    $rcount = $results{$file};
    ok( $rcount == $bcount, "counts are the correct for $file ($rcount == $bcount)" )
}

$results_base_count = base_count('t/test-code', 't/standards.xml');
ok($base_count == $results_base_count, "base counts match ($results_base_count == $base_count)");

# todo: write a test for invalid file extentions