#!/usr/bin/perl

# A simple utility to view a picture from the command line
#
# The first option should be the file name to show
# The (optional) second option is 'mali' if a MALI GPU.

use strict;

use Graphics::Framebuffer;

my $mali = 0;
$mali    = 1 if ($ARGV[1] =~ /mali/i);

my ($c,$p);
my $f = Graphics::Framebuffer->new('MALI'=>$mali,'SPLASH' => 0,'SHOW_ERRORS' => 1);

system('clear');
$f->cls();

# This centers and shows the picture by proportionally scaling the height and width

$f->blit_write(
    $f->load_image(
        {
            'width'  => $f->{'XRES'},
            'height' => $f->{'YRES'},
            'file'   => $ARGV[0]
        }
    )
);
sleep 2;
